/*
 * Copyright (C) 2010 Freescale Semiconductor, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */
#ifndef __MX28_EVK_H
#define __MX28_EVK_H

#include <asm/arch/mx28.h>

#ifndef __ASSEMBLY__
/* prototypes for the bitbanging drivers */
int  spi_bitbang_read ();
void spi_bitbang_sda (int bit);
void spi_bitbang_scl (int bit);

int  i2c_bitbang_read ();
void i2c_bitbang_active ();
void i2c_bitbang_tristate ();
void i2c_bitbang_sda (int bit);
void i2c_bitbang_scl (int bit);
#endif

/*
 * SoC configurations
 */
#define CONFIG_MX28				/* i.MX28 SoC */
#define CONFIG_MX28_TO1_2
#define CONFIG_SYS_HZ		1000		/* Ticks per second */
/* ROM loads UBOOT into DRAM */
#define CONFIG_SKIP_RELOCATE_UBOOT

/*
 * Memory configurations
 */
#define CONFIG_NR_DRAM_BANKS	1		/* 1 bank of DRAM */
#define PHYS_SDRAM_1		0x40000000	/* Base address */
#define PHYS_SDRAM_1_SIZE	0x08000000	/* 128 MB */
#define CONFIG_STACKSIZE	0x00020000	/* 128 KB stack */
#define CONFIG_SYS_MALLOC_LEN	0x00400000	/* 4 MB for malloc */
#define CONFIG_SYS_GBL_DATA_SIZE 128		/* Reserved for initial data */
#define CONFIG_SYS_MEMTEST_START 0x40000000	/* Memtest start address */
#define CONFIG_SYS_MEMTEST_END	 0x40400000	/* 4 MB RAM test */

/*
 * U-Boot general configurations
 */
#define CONFIG_SYS_LONGHELP
#define CONFIG_DISPLAY_BOARDINFO
#define CONFIG_SYS_PROMPT	"cc51> "
#define CONFIG_SYS_CBSIZE	2048		/* Console I/O buffer size */
#define CONFIG_SYS_PBSIZE \
	(CONFIG_SYS_CBSIZE + sizeof(CONFIG_SYS_PROMPT) + 16)
						/* Print buffer size */
#define CONFIG_SYS_MAXARGS	64		/* Max number of command args */
#define CONFIG_SYS_BARGSIZE	CONFIG_SYS_CBSIZE
						/* Boot argument buffer size */
#define CONFIG_VERSION_VARIABLE			/* U-BOOT version */
#undef  CONFIG_AUTO_COMPLETE			/* Command auto complete */
#define CONFIG_SYS_HUSH_PARSER		1
#define CONFIG_SYS_PROMPT_HUSH_PS2	"> "
#define CONFIG_CMDLINE_EDITING			/* Command history etc */

#define CONFIG_SYS_64BIT_VSPRINTF

/*
 * Boot Linux
 */
#define CONFIG_CMDLINE_TAG
#define CONFIG_SETUP_MEMORY_TAGS
#define CONFIG_BOOTDELAY	3
#define CONFIG_BOOTFILE		"uImage"
#define CONFIG_BOOTARGS		"console=ttyAMA0,115200n8 "
#define CONFIG_BOOTCOMMAND	"run bootcmd_nand"
#define CONFIG_LOADADDR		0x40100000
#define CONFIG_SYS_LOAD_ADDR	CONFIG_LOADADDR

/*
 * Extra Environments
 */
#define	CONFIG_EXTRA_ENV_SETTINGS					\
	"nfsroot=/home/notroot/nfs/rootfs\0"				\
	"bootargs_nfs=setenv bootargs ${bootargs} root=/dev/nfs "	\
	"ip=dhcp nfsroot=${serverip}:${nfsroot},v3,tcp "		\
	"fec_mac=${ethaddr}\0"						\
	"bootcmd_net=echo \"Welcome to CC51\"\0"			\
	"bootargs_mmc=setenv bootargs ${bootargs} root=/dev/mmcblk0p3 " \
	"rw rootwait ip=dhcp fec_mac=${ethaddr}\0"			\
	"bootcmd_mmc=run bootargs_mmc; "				\
	"mmc read 0 ${loadaddr} 100 3000; bootm\0"			\
	"mtdids=" MTDIDS_DEFAULT "\0"					\
	"mtdparts=" MTDPARTS_DEFAULT "\0"				\
	"autostart=no\0"

#define MTD_NAME			"gpmi-nand"
#define MTDIDS_DEFAULT			"nand0=" MTD_NAME
#define MTDPARTS_DEFAULT		"mtdparts=" MTD_NAME ":1m@0x40000(u-boot),4m(kernel),-(rootfs)\0"

/*
 * U-Boot Commands
 */
#define CONFIG_SYS_NO_FLASH
#include <config_cmd_default.h>
#define CONFIG_ARCH_CPU_INIT
#define CONFIG_DISPLAY_CPUINFO

/*
 * Serial Driver
 */
#define CONFIG_UARTDBG_CLK		24000000
#define CONFIG_BAUDRATE			115200		/* Default baud rate */
#define CONFIG_SYS_BAUDRATE_TABLE	{ 9600, 19200, 38400, 57600, 115200 }

/* SPI EEPROM on the cc51 */
#define CONFIG_SPI
#define CONFIG_SOFT_SPI         /* Enable SPI driver */
#define CONFIG_CMD_SF
#define CONFIG_SPI_FLASH
#define CONFIG_SPI_FLASH_STMICRO

/* I2C driver for USB Host configuration */
#define CONFIG_I2C
#define CONFIG_SOFT_I2C
#define CONFIG_SOFT_I2C_READ_REPEATED_START
#define CONFIG_CMD_I2C
#define CONFIG_SYS_I2C_SPEED 100000

#if 0
/* USB support? */
#define CONFIG_CMD_USB
#define CONFIG_USB_EHCI
#define CONFIG_USB_EHCI_MX28
#endif

/*
 * Software (bit-bang) SPI driver configuration
 */
#ifdef CONFIG_SOFT_SPI
# define SPI_READ     spi_bitbang_read ()
# define SPI_SDA(bit) spi_bitbang_sda(bit)
# define SPI_SCL(bit) spi_bitbang_scl(bit)
# define SPI_DELAY    /* No delay is needed */
#endif


/*
 * Software (bit-bang) I2C driver configuration
 */
#ifdef CONFIG_SOFT_I2C
# define I2C_READ     i2c_bitbang_read ()
# define I2C_ACTIVE   i2c_bitbang_active ()
# define I2C_TRISTATE i2c_bitbang_tristate ()
# define I2C_SDA(bit) i2c_bitbang_sda (bit)
# define I2C_SCL(bit) i2c_bitbang_scl (bit)
# define I2C_DELAY    udelay((1000000 - 1 + 4*CONFIG_SYS_I2C_SPEED)/(4*CONFIG_SYS_I2C_SPEED))
#endif


/*
 * FEC Driver
 */
#define CONFIG_MXC_FEC
#define CONFIG_GET_FEC_MAC_ADDR_FROM_IIM
#define CONFIG_FEC0_IOBASE		((volatile void *)REGS_ENET_BASE)
#define CONFIG_FEC0_PHY_ADDR		0
#define CONFIG_NET_MULTI
#define CONFIG_ETH_PRIME
#define CONFIG_RMII
#define CONFIG_CMD_MII
#define CONFIG_CMD_DHCP
#define CONFIG_CMD_PING
/* Add for working with "strict" DHCP server */
#define CONFIG_BOOTP_SUBNETMASK
#define CONFIG_BOOTP_GATEWAY
#define CONFIG_BOOTP_DNS

#define CONFIG_CMD_MMC
#define CONFIG_CMD_NAND
#define CONFIG_CMD_MTDPARTS

#if 0
/* for UBI */
#define CONFIG_RBTREE
#define CONFIG_LZO
#define CONFIG_CMD_UBI
#define CONFIG_CMD_UBIFS
#endif

/*
 * NAND flash driver
 */
#ifdef CONFIG_CMD_NAND
#define CONFIG_MTD_DEVICE
#define CONFIG_MTD_PARTITIONS
#define CONFIG_ENV_IS_IN_NAND
#define CONFIG_MXS_NAND
#define CONFIG_SYS_MXS_DMA_CHANNEL	4
#define CONFIG_SYS_MAX_FLASH_SECT	1024
#define CONFIG_SYS_MAX_FLASH_BANKS	1
#define CONFIG_SYS_NAND_MAX_CHIPS	1
#define CONFIG_SYS_MAX_NAND_DEVICE	1
#ifdef CONFIG_ENV_IS_IN_NAND
#define CONFIG_ENV_OVERWRITE
#define CONFIG_ENV_OFFSET		0x20000
#define CONFIG_ENV_SIZE			0x20000 /* 128 KiB */
#endif
#ifndef CONFIG_SYS_NO_FLASH
#define CONFIG_CMD_FLASH
#define CONFIG_SYS_NAND_BASE		0xa0000000
#define CONFIG_FIT
#define CONFIG_OF_LIBFDT
#else
#define CONFIG_SYS_NAND_BASE		0x00000000
#define CONFIG_CMD_ROMUPDATE
#endif
#endif /* CONFIG_CMD_NAND */

/*
 * MMC Driver
 */
#ifdef CONFIG_CMD_MMC
#ifndef CONFIG_ENV_IS_IN_NAND
#define CONFIG_ENV_IS_IN_MMC
#endif
#define CONFIG_MMC
#define CONFIG_IMX_SSP_MMC		/* MMC driver based on SSP */
#define CONFIG_GENERIC_MMC
#define CONFIG_DOS_PARTITION
#define CONFIG_CMD_FAT
#define CONFIG_SYS_SSP_MMC_NUM		1

#define CONFIG_BOOT_PARTITION_ACCESS
#define CONFIG_DOS_PARTITION
#define CONFIG_CMD_FAT
#define CONFIG_CMD_EXT2

/*
 * Environments on MMC
 */
#ifdef CONFIG_ENV_IS_IN_MMC
#define CONFIG_SYS_MMC_ENV_DEV	0
#define CONFIG_CMD_ENV
#define CONFIG_ENV_OVERWRITE
/* Assoiated with the MMC layout defined in mmcops.c */
#define CONFIG_ENV_OFFSET		0x400 /* 1 KB */
#define CONFIG_ENV_SIZE			(0x20000 - 0x400) /* 127 KB */
#define CONFIG_DYNAMIC_MMC_DEVNO
#endif /* CONFIG_ENV_IS_IN_MMC */
#endif /* CONFIG_CMD_MMC */

/* The global boot mode will be detected by ROM code and
 * a boot mode value will be stored at fixed address:
 * TO1.0 addr 0x0001a7f0
 * TO1.2 addr 0x00019BF0
 */
#ifndef MX28_EVK_TO1_0
 #define GLOBAL_BOOT_MODE_ADDR 0x00019BF0
#else
 #define GLOBAL_BOOT_MODE_ADDR 0x0001a7f0
#endif
#define BOOT_MODE_SD0 0x9
#define BOOT_MODE_SD1 0xa

#endif /* __MX28_EVK_H */
