/*
 * Freescale ENET Register Definitions
 *
 * Copyright 2008-2010 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * This file is created by xml file. Don't Edit it.
 *
 * Xml Revision: 1.32
 * Template revision: 26195
 */

#ifndef __ARCH_ARM___ENET_H
#define __ARCH_ARM___ENET_H


#define HW_ENET_MAC0_EIR	(0x00000000)

#define BM_ENET_MAC0_EIR_RSRVD0	0x80000000
#define BM_ENET_MAC0_EIR_BABR	0x40000000
#define BM_ENET_MAC0_EIR_BABT	0x20000000
#define BM_ENET_MAC0_EIR_GRA	0x10000000
#define BM_ENET_MAC0_EIR_TXF	0x08000000
#define BM_ENET_MAC0_EIR_TXB	0x04000000
#define BM_ENET_MAC0_EIR_RXF	0x02000000
#define BM_ENET_MAC0_EIR_RXB	0x01000000
#define BM_ENET_MAC0_EIR_MII	0x00800000
#define BM_ENET_MAC0_EIR_EBERR	0x00400000
#define BM_ENET_MAC0_EIR_LC	0x00200000
#define BM_ENET_MAC0_EIR_RL	0x00100000
#define BM_ENET_MAC0_EIR_UN	0x00080000
#define BM_ENET_MAC0_EIR_PLR	0x00040000
#define BM_ENET_MAC0_EIR_WAKEUP	0x00020000
#define BM_ENET_MAC0_EIR_TS_AVAIL	0x00010000
#define BM_ENET_MAC0_EIR_TS_TIMER	0x00008000
#define BP_ENET_MAC0_EIR_RSRVD1	0
#define BM_ENET_MAC0_EIR_RSRVD1	0x00007FFF
#define BF_ENET_MAC0_EIR_RSRVD1(v)  \
		(((v) << 0) & BM_ENET_MAC0_EIR_RSRVD1)

#define HW_ENET_MAC0_EIMR	(0x00000004)

#define BP_ENET_MAC0_EIMR_EIMR	0
#define BM_ENET_MAC0_EIMR_EIMR	0xFFFFFFFF
#define BF_ENET_MAC0_EIMR_EIMR(v)	(v)

#define HW_ENET_MAC0_RDAR	(0x0000000c)

#define BP_ENET_MAC0_RDAR_RSRVD0	25
#define BM_ENET_MAC0_RDAR_RSRVD0	0xFE000000
#define BF_ENET_MAC0_RDAR_RSRVD0(v) \
		(((v) << 25) & BM_ENET_MAC0_RDAR_RSRVD0)
#define BM_ENET_MAC0_RDAR_RDAR	0x01000000
#define BP_ENET_MAC0_RDAR_RSRVD1	0
#define BM_ENET_MAC0_RDAR_RSRVD1	0x00FFFFFF
#define BF_ENET_MAC0_RDAR_RSRVD1(v)  \
		(((v) << 0) & BM_ENET_MAC0_RDAR_RSRVD1)

#define HW_ENET_MAC0_TDAR	(0x00000010)

#define BP_ENET_MAC0_TDAR_RSRVD0	25
#define BM_ENET_MAC0_TDAR_RSRVD0	0xFE000000
#define BF_ENET_MAC0_TDAR_RSRVD0(v) \
		(((v) << 25) & BM_ENET_MAC0_TDAR_RSRVD0)
#define BM_ENET_MAC0_TDAR_TDAR	0x01000000
#define BP_ENET_MAC0_TDAR_RSRVD1	0
#define BM_ENET_MAC0_TDAR_RSRVD1	0x00FFFFFF
#define BF_ENET_MAC0_TDAR_RSRVD1(v)  \
		(((v) << 0) & BM_ENET_MAC0_TDAR_RSRVD1)

#define HW_ENET_MAC0_ECR	(0x00000020)

#define BP_ENET_MAC0_ECR_RSRVD0	7
#define BM_ENET_MAC0_ECR_RSRVD0	0xFFFFFF80
#define BF_ENET_MAC0_ECR_RSRVD0(v) \
		(((v) << 7) & BM_ENET_MAC0_ECR_RSRVD0)
#define BM_ENET_MAC0_ECR_DBG_EN	0x00000040
#define BM_ENET_MAC0_ECR_ETH_SPEED	0x00000020
#define BM_ENET_MAC0_ECR_ENA_1588	0x00000010
#define BM_ENET_MAC0_ECR_SLEEP	0x00000008
#define BM_ENET_MAC0_ECR_MAGIC_ENA	0x00000004
#define BM_ENET_MAC0_ECR_ETHER_EN	0x00000002
#define BM_ENET_MAC0_ECR_RESET	0x00000001

#define HW_ENET_MAC0_MMFR	(0x0000003c)

#define BP_ENET_MAC0_MMFR_ST	30
#define BM_ENET_MAC0_MMFR_ST	0xC0000000
#define BF_ENET_MAC0_MMFR_ST(v) \
		(((v) << 30) & BM_ENET_MAC0_MMFR_ST)
#define BP_ENET_MAC0_MMFR_OP	28
#define BM_ENET_MAC0_MMFR_OP	0x30000000
#define BF_ENET_MAC0_MMFR_OP(v)  \
		(((v) << 28) & BM_ENET_MAC0_MMFR_OP)
#define BP_ENET_MAC0_MMFR_PA	23
#define BM_ENET_MAC0_MMFR_PA	0x0F800000
#define BF_ENET_MAC0_MMFR_PA(v)  \
		(((v) << 23) & BM_ENET_MAC0_MMFR_PA)
#define BP_ENET_MAC0_MMFR_RA	18
#define BM_ENET_MAC0_MMFR_RA	0x007C0000
#define BF_ENET_MAC0_MMFR_RA(v)  \
		(((v) << 18) & BM_ENET_MAC0_MMFR_RA)
#define BP_ENET_MAC0_MMFR_TA	16
#define BM_ENET_MAC0_MMFR_TA	0x00030000
#define BF_ENET_MAC0_MMFR_TA(v)  \
		(((v) << 16) & BM_ENET_MAC0_MMFR_TA)
#define BP_ENET_MAC0_MMFR_DATA	0
#define BM_ENET_MAC0_MMFR_DATA	0x0000FFFF
#define BF_ENET_MAC0_MMFR_DATA(v)  \
		(((v) << 0) & BM_ENET_MAC0_MMFR_DATA)

#define HW_ENET_MAC0_MSCR	(0x00000040)

#define BP_ENET_MAC0_MSCR_RSRVD0	11
#define BM_ENET_MAC0_MSCR_RSRVD0	0xFFFFF800
#define BF_ENET_MAC0_MSCR_RSRVD0(v) \
		(((v) << 11) & BM_ENET_MAC0_MSCR_RSRVD0)
#define BP_ENET_MAC0_MSCR_HOLDTIME	8
#define BM_ENET_MAC0_MSCR_HOLDTIME	0x00000700
#define BF_ENET_MAC0_MSCR_HOLDTIME(v)  \
		(((v) << 8) & BM_ENET_MAC0_MSCR_HOLDTIME)
#define BM_ENET_MAC0_MSCR_DIS_PRE	0x00000080
#define BP_ENET_MAC0_MSCR_MII_SPEED	1
#define BM_ENET_MAC0_MSCR_MII_SPEED	0x0000007E
#define BF_ENET_MAC0_MSCR_MII_SPEED(v)  \
		(((v) << 1) & BM_ENET_MAC0_MSCR_MII_SPEED)
#define BM_ENET_MAC0_MSCR_RSRVD1	0x00000001

#define HW_ENET_MAC0_MIBC	(0x00000060)

#define BM_ENET_MAC0_MIBC_MIB_DIS	0x80000000
#define BM_ENET_MAC0_MIBC_MIB_IDLE	0x40000000
#define BM_ENET_MAC0_MIBC_MIB_CLEAR	0x20000000
#define BP_ENET_MAC0_MIBC_RSRVD0	0
#define BM_ENET_MAC0_MIBC_RSRVD0	0x1FFFFFFF
#define BF_ENET_MAC0_MIBC_RSRVD0(v)  \
		(((v) << 0) & BM_ENET_MAC0_MIBC_RSRVD0)

#define HW_ENET_MAC0_RCR	(0x00000080)

#define BM_ENET_MAC0_RCR_GRS	0x80000000
#define BM_ENET_MAC0_RCR_NO_LGTH_CHECK	0x40000000
#define BP_ENET_MAC0_RCR_MAX_FL	16
#define BM_ENET_MAC0_RCR_MAX_FL	0x3FFF0000
#define BF_ENET_MAC0_RCR_MAX_FL(v)  \
		(((v) << 16) & BM_ENET_MAC0_RCR_MAX_FL)
#define BM_ENET_MAC0_RCR_CNTL_FRM_ENA	0x00008000
#define BM_ENET_MAC0_RCR_CRC_FWD	0x00004000
#define BM_ENET_MAC0_RCR_PAUSE_FWD	0x00002000
#define BM_ENET_MAC0_RCR_PAD_EN	0x00001000
#define BM_ENET_MAC0_RCR_RMII_ECHO	0x00000800
#define BM_ENET_MAC0_RCR_RMII_LOOP	0x00000400
#define BM_ENET_MAC0_RCR_RMII_10T	0x00000200
#define BM_ENET_MAC0_RCR_RMII_MODE	0x00000100
#define BM_ENET_MAC0_RCR_SGMII_ENA	0x00000080
#define BM_ENET_MAC0_RCR_RGMII_ENA	0x00000040
#define BM_ENET_MAC0_RCR_FCE	0x00000020
#define BM_ENET_MAC0_RCR_BC_REJ	0x00000010
#define BM_ENET_MAC0_RCR_PROM	0x00000008
#define BM_ENET_MAC0_RCR_MII_MODE	0x00000004
#define BM_ENET_MAC0_RCR_DRT	0x00000002
#define BM_ENET_MAC0_RCR_LOOP	0x00000001

#define HW_ENET_MAC0_TCR	(0x000000c0)

#define BP_ENET_MAC0_TCR_RSRVD0	10
#define BM_ENET_MAC0_TCR_RSRVD0	0xFFFFFC00
#define BF_ENET_MAC0_TCR_RSRVD0(v) \
		(((v) << 10) & BM_ENET_MAC0_TCR_RSRVD0)
#define BM_ENET_MAC0_TCR_TX_CRC_FWD	0x00000200
#define BM_ENET_MAC0_TCR_TX_ADDR_INS	0x00000100
#define BP_ENET_MAC0_TCR_TX_ADDR_SEL	5
#define BM_ENET_MAC0_TCR_TX_ADDR_SEL	0x000000E0
#define BF_ENET_MAC0_TCR_TX_ADDR_SEL(v)  \
		(((v) << 5) & BM_ENET_MAC0_TCR_TX_ADDR_SEL)
#define BM_ENET_MAC0_TCR_RFC_PAUSE	0x00000010
#define BM_ENET_MAC0_TCR_TFC_PAUSE	0x00000008
#define BM_ENET_MAC0_TCR_FEDN	0x00000004
#define BM_ENET_MAC0_TCR_HBC	0x00000002
#define BM_ENET_MAC0_TCR_GTS	0x00000001

#define HW_ENET_MAC0_PALR	(0x000000e0)

#define BP_ENET_MAC0_PALR_PADDR1	0
#define BM_ENET_MAC0_PALR_PADDR1	0xFFFFFFFF
#define BF_ENET_MAC0_PALR_PADDR1(v)	(v)

#define HW_ENET_MAC0_PAUR	(0x000000e4)

#define BP_ENET_MAC0_PAUR_PADDR2	16
#define BM_ENET_MAC0_PAUR_PADDR2	0xFFFF0000
#define BF_ENET_MAC0_PAUR_PADDR2(v) \
		(((v) << 16) & BM_ENET_MAC0_PAUR_PADDR2)
#define BP_ENET_MAC0_PAUR_TYPE	0
#define BM_ENET_MAC0_PAUR_TYPE	0x0000FFFF
#define BF_ENET_MAC0_PAUR_TYPE(v)  \
		(((v) << 0) & BM_ENET_MAC0_PAUR_TYPE)

#define HW_ENET_MAC0_OPD	(0x000000e8)

#define BP_ENET_MAC0_OPD_OPCODE	16
#define BM_ENET_MAC0_OPD_OPCODE	0xFFFF0000
#define BF_ENET_MAC0_OPD_OPCODE(v) \
		(((v) << 16) & BM_ENET_MAC0_OPD_OPCODE)
#define BP_ENET_MAC0_OPD_PAUSE_DUR	0
#define BM_ENET_MAC0_OPD_PAUSE_DUR	0x0000FFFF
#define BF_ENET_MAC0_OPD_PAUSE_DUR(v)  \
		(((v) << 0) & BM_ENET_MAC0_OPD_PAUSE_DUR)

#define HW_ENET_MAC0_IAUR	(0x00000114)

#define BP_ENET_MAC0_IAUR_IADDR1	0
#define BM_ENET_MAC0_IAUR_IADDR1	0xFFFFFFFF
#define BF_ENET_MAC0_IAUR_IADDR1(v)	(v)

#define HW_ENET_MAC0_IALR	(0x00000118)

#define BP_ENET_MAC0_IALR_IADDR2	0
#define BM_ENET_MAC0_IALR_IADDR2	0xFFFFFFFF
#define BF_ENET_MAC0_IALR_IADDR2(v)	(v)

#define HW_ENET_MAC0_GAUR	(0x0000011c)

#define BP_ENET_MAC0_GAUR_GADDR1	0
#define BM_ENET_MAC0_GAUR_GADDR1	0xFFFFFFFF
#define BF_ENET_MAC0_GAUR_GADDR1(v)	(v)

#define HW_ENET_MAC0_GALR	(0x00000120)

#define BP_ENET_MAC0_GALR_GADDR2	0
#define BM_ENET_MAC0_GALR_GADDR2	0xFFFFFFFF
#define BF_ENET_MAC0_GALR_GADDR2(v)	(v)

#define HW_ENET_MAC0_TFW_SFCR	(0x00000140)

#define BP_ENET_MAC0_TFW_SFCR_RSRVD0	9
#define BM_ENET_MAC0_TFW_SFCR_RSRVD0	0xFFFFFE00
#define BF_ENET_MAC0_TFW_SFCR_RSRVD0(v) \
		(((v) << 9) & BM_ENET_MAC0_TFW_SFCR_RSRVD0)
#define BM_ENET_MAC0_TFW_SFCR_STR_FWD	0x00000100
#define BP_ENET_MAC0_TFW_SFCR_RSRVD1	6
#define BM_ENET_MAC0_TFW_SFCR_RSRVD1	0x000000C0
#define BF_ENET_MAC0_TFW_SFCR_RSRVD1(v)  \
		(((v) << 6) & BM_ENET_MAC0_TFW_SFCR_RSRVD1)
#define BP_ENET_MAC0_TFW_SFCR_TFWR	0
#define BM_ENET_MAC0_TFW_SFCR_TFWR	0x0000003F
#define BF_ENET_MAC0_TFW_SFCR_TFWR(v)  \
		(((v) << 0) & BM_ENET_MAC0_TFW_SFCR_TFWR)

#define HW_ENET_MAC0_FRBR	(0x00000148)

#define BP_ENET_MAC0_FRBR_RSRVD0	10
#define BM_ENET_MAC0_FRBR_RSRVD0	0xFFFFFC00
#define BF_ENET_MAC0_FRBR_RSRVD0(v) \
		(((v) << 10) & BM_ENET_MAC0_FRBR_RSRVD0)
#define BP_ENET_MAC0_FRBR_R_BOUND	2
#define BM_ENET_MAC0_FRBR_R_BOUND	0x000003FC
#define BF_ENET_MAC0_FRBR_R_BOUND(v)  \
		(((v) << 2) & BM_ENET_MAC0_FRBR_R_BOUND)
#define BP_ENET_MAC0_FRBR_RSRVD1	0
#define BM_ENET_MAC0_FRBR_RSRVD1	0x00000003
#define BF_ENET_MAC0_FRBR_RSRVD1(v)  \
		(((v) << 0) & BM_ENET_MAC0_FRBR_RSRVD1)

#define HW_ENET_MAC0_FRSR	(0x0000014c)

#define BP_ENET_MAC0_FRSR_RSRVD0	11
#define BM_ENET_MAC0_FRSR_RSRVD0	0xFFFFF800
#define BF_ENET_MAC0_FRSR_RSRVD0(v) \
		(((v) << 11) & BM_ENET_MAC0_FRSR_RSRVD0)
#define BM_ENET_MAC0_FRSR_RSRVD1	0x00000400
#define BP_ENET_MAC0_FRSR_R_FSTART	2
#define BM_ENET_MAC0_FRSR_R_FSTART	0x000003FC
#define BF_ENET_MAC0_FRSR_R_FSTART(v)  \
		(((v) << 2) & BM_ENET_MAC0_FRSR_R_FSTART)
#define BP_ENET_MAC0_FRSR_RSRVD2	0
#define BM_ENET_MAC0_FRSR_RSRVD2	0x00000003
#define BF_ENET_MAC0_FRSR_RSRVD2(v)  \
		(((v) << 0) & BM_ENET_MAC0_FRSR_RSRVD2)

#define HW_ENET_MAC0_ERDSR	(0x0000017c)

#define BP_ENET_MAC0_ERDSR_R_DES_START	2
#define BM_ENET_MAC0_ERDSR_R_DES_START	0xFFFFFFFC
#define BF_ENET_MAC0_ERDSR_R_DES_START(v) \
		(((v) << 2) & BM_ENET_MAC0_ERDSR_R_DES_START)
#define BP_ENET_MAC0_ERDSR_RSRVD0	0
#define BM_ENET_MAC0_ERDSR_RSRVD0	0x00000003
#define BF_ENET_MAC0_ERDSR_RSRVD0(v)  \
		(((v) << 0) & BM_ENET_MAC0_ERDSR_RSRVD0)

#define HW_ENET_MAC0_ETDSR	(0x00000180)

#define BP_ENET_MAC0_ETDSR_X_DES_START	2
#define BM_ENET_MAC0_ETDSR_X_DES_START	0xFFFFFFFC
#define BF_ENET_MAC0_ETDSR_X_DES_START(v) \
		(((v) << 2) & BM_ENET_MAC0_ETDSR_X_DES_START)
#define BP_ENET_MAC0_ETDSR_RSRVD0	0
#define BM_ENET_MAC0_ETDSR_RSRVD0	0x00000003
#define BF_ENET_MAC0_ETDSR_RSRVD0(v)  \
		(((v) << 0) & BM_ENET_MAC0_ETDSR_RSRVD0)

#define HW_ENET_MAC0_EMRBR	(0x00000184)

#define BP_ENET_MAC0_EMRBR_RSRVD0	11
#define BM_ENET_MAC0_EMRBR_RSRVD0	0xFFFFF800
#define BF_ENET_MAC0_EMRBR_RSRVD0(v) \
		(((v) << 11) & BM_ENET_MAC0_EMRBR_RSRVD0)
#define BP_ENET_MAC0_EMRBR_R_BUF_SIZE	4
#define BM_ENET_MAC0_EMRBR_R_BUF_SIZE	0x000007F0
#define BF_ENET_MAC0_EMRBR_R_BUF_SIZE(v)  \
		(((v) << 4) & BM_ENET_MAC0_EMRBR_R_BUF_SIZE)
#define BP_ENET_MAC0_EMRBR_RSRVD1	0
#define BM_ENET_MAC0_EMRBR_RSRVD1	0x0000000F
#define BF_ENET_MAC0_EMRBR_RSRVD1(v)  \
		(((v) << 0) & BM_ENET_MAC0_EMRBR_RSRVD1)

#define HW_ENET_MAC0_RX_SECTION_FULL	(0x0000018c)

#define BP_ENET_MAC0_RX_SECTION_FULL_RSRVD0	8
#define BM_ENET_MAC0_RX_SECTION_FULL_RSRVD0	0xFFFFFF00
#define BF_ENET_MAC0_RX_SECTION_FULL_RSRVD0(v) \
		(((v) << 8) & BM_ENET_MAC0_RX_SECTION_FULL_RSRVD0)
#define BP_ENET_MAC0_RX_SECTION_FULL_RX_SECTION_FULL	0
#define BM_ENET_MAC0_RX_SECTION_FULL_RX_SECTION_FULL	0x000000FF
#define BF_ENET_MAC0_RX_SECTION_FULL_RX_SECTION_FULL(v)  \
		(((v) << 0) & BM_ENET_MAC0_RX_SECTION_FULL_RX_SECTION_FULL)

#define HW_ENET_MAC0_RX_SECTION_EMPTY	(0x00000190)

#define BP_ENET_MAC0_RX_SECTION_EMPTY_RSRVD0	8
#define BM_ENET_MAC0_RX_SECTION_EMPTY_RSRVD0	0xFFFFFF00
#define BF_ENET_MAC0_RX_SECTION_EMPTY_RSRVD0(v) \
		(((v) << 8) & BM_ENET_MAC0_RX_SECTION_EMPTY_RSRVD0)
#define BP_ENET_MAC0_RX_SECTION_EMPTY_RX_SECTION_EMPTY	0
#define BM_ENET_MAC0_RX_SECTION_EMPTY_RX_SECTION_EMPTY	0x000000FF
#define BF_ENET_MAC0_RX_SECTION_EMPTY_RX_SECTION_EMPTY(v)  \
		(((v) << 0) & BM_ENET_MAC0_RX_SECTION_EMPTY_RX_SECTION_EMPTY)

#define HW_ENET_MAC0_RX_ALMOST_EMPTY	(0x00000194)

#define BP_ENET_MAC0_RX_ALMOST_EMPTY_RSRVD0	8
#define BM_ENET_MAC0_RX_ALMOST_EMPTY_RSRVD0	0xFFFFFF00
#define BF_ENET_MAC0_RX_ALMOST_EMPTY_RSRVD0(v) \
		(((v) << 8) & BM_ENET_MAC0_RX_ALMOST_EMPTY_RSRVD0)
#define BP_ENET_MAC0_RX_ALMOST_EMPTY_RX_ALMOST_EMPTY	0
#define BM_ENET_MAC0_RX_ALMOST_EMPTY_RX_ALMOST_EMPTY	0x000000FF
#define BF_ENET_MAC0_RX_ALMOST_EMPTY_RX_ALMOST_EMPTY(v)  \
		(((v) << 0) & BM_ENET_MAC0_RX_ALMOST_EMPTY_RX_ALMOST_EMPTY)

#define HW_ENET_MAC0_RX_ALMOST_FULL	(0x00000198)

#define BP_ENET_MAC0_RX_ALMOST_FULL_RSRVD0	8
#define BM_ENET_MAC0_RX_ALMOST_FULL_RSRVD0	0xFFFFFF00
#define BF_ENET_MAC0_RX_ALMOST_FULL_RSRVD0(v) \
		(((v) << 8) & BM_ENET_MAC0_RX_ALMOST_FULL_RSRVD0)
#define BP_ENET_MAC0_RX_ALMOST_FULL_RX_ALMOST_FULL	0
#define BM_ENET_MAC0_RX_ALMOST_FULL_RX_ALMOST_FULL	0x000000FF
#define BF_ENET_MAC0_RX_ALMOST_FULL_RX_ALMOST_FULL(v)  \
		(((v) << 0) & BM_ENET_MAC0_RX_ALMOST_FULL_RX_ALMOST_FULL)

#define HW_ENET_MAC0_TX_SECTION_EMPTY	(0x0000019c)

#define BP_ENET_MAC0_TX_SECTION_EMPTY_RSRVD0	8
#define BM_ENET_MAC0_TX_SECTION_EMPTY_RSRVD0	0xFFFFFF00
#define BF_ENET_MAC0_TX_SECTION_EMPTY_RSRVD0(v) \
		(((v) << 8) & BM_ENET_MAC0_TX_SECTION_EMPTY_RSRVD0)
#define BP_ENET_MAC0_TX_SECTION_EMPTY_TX_SECTION_EMPTY	0
#define BM_ENET_MAC0_TX_SECTION_EMPTY_TX_SECTION_EMPTY	0x000000FF
#define BF_ENET_MAC0_TX_SECTION_EMPTY_TX_SECTION_EMPTY(v)  \
		(((v) << 0) & BM_ENET_MAC0_TX_SECTION_EMPTY_TX_SECTION_EMPTY)

#define HW_ENET_MAC0_TX_ALMOST_EMPTY	(0x000001a0)

#define BP_ENET_MAC0_TX_ALMOST_EMPTY_RSRVD0	8
#define BM_ENET_MAC0_TX_ALMOST_EMPTY_RSRVD0	0xFFFFFF00
#define BF_ENET_MAC0_TX_ALMOST_EMPTY_RSRVD0(v) \
		(((v) << 8) & BM_ENET_MAC0_TX_ALMOST_EMPTY_RSRVD0)
#define BP_ENET_MAC0_TX_ALMOST_EMPTY_TX_ALMOST_EMPTY	0
#define BM_ENET_MAC0_TX_ALMOST_EMPTY_TX_ALMOST_EMPTY	0x000000FF
#define BF_ENET_MAC0_TX_ALMOST_EMPTY_TX_ALMOST_EMPTY(v)  \
		(((v) << 0) & BM_ENET_MAC0_TX_ALMOST_EMPTY_TX_ALMOST_EMPTY)

#define HW_ENET_MAC0_TX_ALMOST_FULL	(0x000001a4)

#define BP_ENET_MAC0_TX_ALMOST_FULL_RSRVD0	8
#define BM_ENET_MAC0_TX_ALMOST_FULL_RSRVD0	0xFFFFFF00
#define BF_ENET_MAC0_TX_ALMOST_FULL_RSRVD0(v) \
		(((v) << 8) & BM_ENET_MAC0_TX_ALMOST_FULL_RSRVD0)
#define BP_ENET_MAC0_TX_ALMOST_FULL_TX_ALMOST_FULL	0
#define BM_ENET_MAC0_TX_ALMOST_FULL_TX_ALMOST_FULL	0x000000FF
#define BF_ENET_MAC0_TX_ALMOST_FULL_TX_ALMOST_FULL(v)  \
		(((v) << 0) & BM_ENET_MAC0_TX_ALMOST_FULL_TX_ALMOST_FULL)

#define HW_ENET_MAC0_TX_IPG_LENGTH	(0x000001a8)

#define BP_ENET_MAC0_TX_IPG_LENGTH_RSRVD0	5
#define BM_ENET_MAC0_TX_IPG_LENGTH_RSRVD0	0xFFFFFFE0
#define BF_ENET_MAC0_TX_IPG_LENGTH_RSRVD0(v) \
		(((v) << 5) & BM_ENET_MAC0_TX_IPG_LENGTH_RSRVD0)
#define BP_ENET_MAC0_TX_IPG_LENGTH_TX_IPG_LENGTH	0
#define BM_ENET_MAC0_TX_IPG_LENGTH_TX_IPG_LENGTH	0x0000001F
#define BF_ENET_MAC0_TX_IPG_LENGTH_TX_IPG_LENGTH(v)  \
		(((v) << 0) & BM_ENET_MAC0_TX_IPG_LENGTH_TX_IPG_LENGTH)

#define HW_ENET_MAC0_TRUNC_FL	(0x000001ac)

#define BP_ENET_MAC0_TRUNC_FL_RSRVD0	14
#define BM_ENET_MAC0_TRUNC_FL_RSRVD0	0xFFFFC000
#define BF_ENET_MAC0_TRUNC_FL_RSRVD0(v) \
		(((v) << 14) & BM_ENET_MAC0_TRUNC_FL_RSRVD0)
#define BP_ENET_MAC0_TRUNC_FL_TRUNC_FL	0
#define BM_ENET_MAC0_TRUNC_FL_TRUNC_FL	0x00003FFF
#define BF_ENET_MAC0_TRUNC_FL_TRUNC_FL(v)  \
		(((v) << 0) & BM_ENET_MAC0_TRUNC_FL_TRUNC_FL)

#define HW_ENET_MAC0_IPACCTXCONF	(0x000001bc)

#define BP_ENET_MAC0_IPACCTXCONF_RSRVD0	5
#define BM_ENET_MAC0_IPACCTXCONF_RSRVD0	0xFFFFFFE0
#define BF_ENET_MAC0_IPACCTXCONF_RSRVD0(v) \
		(((v) << 5) & BM_ENET_MAC0_IPACCTXCONF_RSRVD0)
#define BM_ENET_MAC0_IPACCTXCONF_TX_PROTCHK_INS	0x00000010
#define BM_ENET_MAC0_IPACCTXCONF_TX_IPCHK_INS	0x00000008
#define BP_ENET_MAC0_IPACCTXCONF_RSRVD1	1
#define BM_ENET_MAC0_IPACCTXCONF_RSRVD1	0x00000006
#define BF_ENET_MAC0_IPACCTXCONF_RSRVD1(v)  \
		(((v) << 1) & BM_ENET_MAC0_IPACCTXCONF_RSRVD1)
#define BM_ENET_MAC0_IPACCTXCONF_SHIFT16	0x00000001

#define HW_ENET_MAC0_IPACCRXCONF	(0x000001c0)

#define BP_ENET_MAC0_IPACCRXCONF_RSRVD0	8
#define BM_ENET_MAC0_IPACCRXCONF_RSRVD0	0xFFFFFF00
#define BF_ENET_MAC0_IPACCRXCONF_RSRVD0(v) \
		(((v) << 8) & BM_ENET_MAC0_IPACCRXCONF_RSRVD0)
#define BM_ENET_MAC0_IPACCRXCONF_SHIFT16	0x00000080
#define BM_ENET_MAC0_IPACCRXCONF_RX_LINEERR_DISC	0x00000040
#define BP_ENET_MAC0_IPACCRXCONF_RSRVD1	3
#define BM_ENET_MAC0_IPACCRXCONF_RSRVD1	0x00000038
#define BF_ENET_MAC0_IPACCRXCONF_RSRVD1(v)  \
		(((v) << 3) & BM_ENET_MAC0_IPACCRXCONF_RSRVD1)
#define BM_ENET_MAC0_IPACCRXCONF_RX_PROTERR_DISCARD	0x00000004
#define BM_ENET_MAC0_IPACCRXCONF_RX_IPERR_DISCARD	0x00000002
#define BM_ENET_MAC0_IPACCRXCONF_RX_IP_PAD_REMOVE	0x00000001

#define HW_ENET_MAC0_RMON_T_DROP	(0x000001fc)

#define BP_ENET_MAC0_RMON_T_DROP_RMON_T_DROP	0
#define BM_ENET_MAC0_RMON_T_DROP_RMON_T_DROP	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_T_DROP_RMON_T_DROP(v)	(v)

#define HW_ENET_MAC0_RMON_T_PACKETS	(0x00000200)

#define BP_ENET_MAC0_RMON_T_PACKETS_RMON_T_PACKETS	0
#define BM_ENET_MAC0_RMON_T_PACKETS_RMON_T_PACKETS	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_T_PACKETS_RMON_T_PACKETS(v)	(v)

#define HW_ENET_MAC0_RMON_T_BC_PKT	(0x00000204)

#define BP_ENET_MAC0_RMON_T_BC_PKT_RMON_T_BC_PKT	0
#define BM_ENET_MAC0_RMON_T_BC_PKT_RMON_T_BC_PKT	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_T_BC_PKT_RMON_T_BC_PKT(v)	(v)

#define HW_ENET_MAC0_RMON_T_MC_PKT	(0x00000208)

#define BP_ENET_MAC0_RMON_T_MC_PKT_RMON_T_MC_PKT	0
#define BM_ENET_MAC0_RMON_T_MC_PKT_RMON_T_MC_PKT	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_T_MC_PKT_RMON_T_MC_PKT(v)	(v)

#define HW_ENET_MAC0_RMON_T_CRC_ALIGN	(0x0000020c)

#define BP_ENET_MAC0_RMON_T_CRC_ALIGN_RMON_T_CRC_ALIGN	0
#define BM_ENET_MAC0_RMON_T_CRC_ALIGN_RMON_T_CRC_ALIGN	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_T_CRC_ALIGN_RMON_T_CRC_ALIGN(v)	(v)

#define HW_ENET_MAC0_RMON_T_UNDERSIZE	(0x00000210)

#define BP_ENET_MAC0_RMON_T_UNDERSIZE_RMON_T_UNDERSIZE	0
#define BM_ENET_MAC0_RMON_T_UNDERSIZE_RMON_T_UNDERSIZE	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_T_UNDERSIZE_RMON_T_UNDERSIZE(v)	(v)

#define HW_ENET_MAC0_RMON_T_OVERSIZE	(0x00000214)

#define BP_ENET_MAC0_RMON_T_OVERSIZE_RMON_T_OVERSIZE	0
#define BM_ENET_MAC0_RMON_T_OVERSIZE_RMON_T_OVERSIZE	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_T_OVERSIZE_RMON_T_OVERSIZE(v)	(v)

#define HW_ENET_MAC0_RMON_T_FRAG	(0x00000218)

#define BP_ENET_MAC0_RMON_T_FRAG_RMON_T_FRAG	0
#define BM_ENET_MAC0_RMON_T_FRAG_RMON_T_FRAG	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_T_FRAG_RMON_T_FRAG(v)	(v)

#define HW_ENET_MAC0_RMON_T_JAB	(0x0000021c)

#define BP_ENET_MAC0_RMON_T_JAB_RMON_T_JAB	0
#define BM_ENET_MAC0_RMON_T_JAB_RMON_T_JAB	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_T_JAB_RMON_T_JAB(v)	(v)

#define HW_ENET_MAC0_RMON_T_COL	(0x00000220)

#define BP_ENET_MAC0_RMON_T_COL_RMON_T_COL	0
#define BM_ENET_MAC0_RMON_T_COL_RMON_T_COL	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_T_COL_RMON_T_COL(v)	(v)

#define HW_ENET_MAC0_RMON_T_P64	(0x00000224)

#define BP_ENET_MAC0_RMON_T_P64_RMON_T_P64	0
#define BM_ENET_MAC0_RMON_T_P64_RMON_T_P64	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_T_P64_RMON_T_P64(v)	(v)

#define HW_ENET_MAC0_RMON_T_P65TO127N	(0x00000228)

#define BP_ENET_MAC0_RMON_T_P65TO127N_RMON_T_P65TO127N	0
#define BM_ENET_MAC0_RMON_T_P65TO127N_RMON_T_P65TO127N	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_T_P65TO127N_RMON_T_P65TO127N(v)	(v)

#define HW_ENET_MAC0_RMON_T_P128TO255N	(0x0000022c)

#define BP_ENET_MAC0_RMON_T_P128TO255N_RMON_T_P128TO255N	0
#define BM_ENET_MAC0_RMON_T_P128TO255N_RMON_T_P128TO255N	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_T_P128TO255N_RMON_T_P128TO255N(v)	(v)

#define HW_ENET_MAC0_RMON_T_P256TO511	(0x00000230)

#define BP_ENET_MAC0_RMON_T_P256TO511_RMON_T_P256TO511	0
#define BM_ENET_MAC0_RMON_T_P256TO511_RMON_T_P256TO511	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_T_P256TO511_RMON_T_P256TO511(v)	(v)

#define HW_ENET_MAC0_RMON_T_P512TO1023	(0x00000234)

#define BP_ENET_MAC0_RMON_T_P512TO1023_RMON_T_P512TO1023	0
#define BM_ENET_MAC0_RMON_T_P512TO1023_RMON_T_P512TO1023	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_T_P512TO1023_RMON_T_P512TO1023(v)	(v)

#define HW_ENET_MAC0_RMON_T_P1024TO2047	(0x00000238)

#define BP_ENET_MAC0_RMON_T_P1024TO2047_RMON_T_P1024TO2047	0
#define BM_ENET_MAC0_RMON_T_P1024TO2047_RMON_T_P1024TO2047	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_T_P1024TO2047_RMON_T_P1024TO2047(v)	(v)

#define HW_ENET_MAC0_RMON_T_P_GTE2048	(0x0000023c)

#define BP_ENET_MAC0_RMON_T_P_GTE2048_RMON_T_P_GTE2048	0
#define BM_ENET_MAC0_RMON_T_P_GTE2048_RMON_T_P_GTE2048	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_T_P_GTE2048_RMON_T_P_GTE2048(v)	(v)

#define HW_ENET_MAC0_RMON_T_OCTETS	(0x00000240)

#define BP_ENET_MAC0_RMON_T_OCTETS_RMON_T_OCTETS	0
#define BM_ENET_MAC0_RMON_T_OCTETS_RMON_T_OCTETS	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_T_OCTETS_RMON_T_OCTETS(v)	(v)

#define HW_ENET_MAC0_IEEE_T_DROP	(0x00000244)

#define BP_ENET_MAC0_IEEE_T_DROP_IEEE_T_DROP	0
#define BM_ENET_MAC0_IEEE_T_DROP_IEEE_T_DROP	0xFFFFFFFF
#define BF_ENET_MAC0_IEEE_T_DROP_IEEE_T_DROP(v)	(v)

#define HW_ENET_MAC0_IEEE_T_FRAME_OK	(0x00000248)

#define BP_ENET_MAC0_IEEE_T_FRAME_OK_IEEE_T_FRAME_OK	0
#define BM_ENET_MAC0_IEEE_T_FRAME_OK_IEEE_T_FRAME_OK	0xFFFFFFFF
#define BF_ENET_MAC0_IEEE_T_FRAME_OK_IEEE_T_FRAME_OK(v)	(v)

#define HW_ENET_MAC0_IEEE_T_1COL	(0x0000024c)

#define BP_ENET_MAC0_IEEE_T_1COL_IEEE_T_1COL	0
#define BM_ENET_MAC0_IEEE_T_1COL_IEEE_T_1COL	0xFFFFFFFF
#define BF_ENET_MAC0_IEEE_T_1COL_IEEE_T_1COL(v)	(v)

#define HW_ENET_MAC0_IEEE_T_MCOL	(0x00000250)

#define BP_ENET_MAC0_IEEE_T_MCOL_IEEE_T_MCOL	0
#define BM_ENET_MAC0_IEEE_T_MCOL_IEEE_T_MCOL	0xFFFFFFFF
#define BF_ENET_MAC0_IEEE_T_MCOL_IEEE_T_MCOL(v)	(v)

#define HW_ENET_MAC0_IEEE_T_DEF	(0x00000254)

#define BP_ENET_MAC0_IEEE_T_DEF_IEEE_T_DEF	0
#define BM_ENET_MAC0_IEEE_T_DEF_IEEE_T_DEF	0xFFFFFFFF
#define BF_ENET_MAC0_IEEE_T_DEF_IEEE_T_DEF(v)	(v)

#define HW_ENET_MAC0_IEEE_T_LCOL	(0x00000258)

#define BP_ENET_MAC0_IEEE_T_LCOL_IEEE_T_LCOL	0
#define BM_ENET_MAC0_IEEE_T_LCOL_IEEE_T_LCOL	0xFFFFFFFF
#define BF_ENET_MAC0_IEEE_T_LCOL_IEEE_T_LCOL(v)	(v)

#define HW_ENET_MAC0_IEEE_T_EXCOL	(0x0000025c)

#define BP_ENET_MAC0_IEEE_T_EXCOL_IEEE_T_EXCOL	0
#define BM_ENET_MAC0_IEEE_T_EXCOL_IEEE_T_EXCOL	0xFFFFFFFF
#define BF_ENET_MAC0_IEEE_T_EXCOL_IEEE_T_EXCOL(v)	(v)

#define HW_ENET_MAC0_IEEE_T_MACERR	(0x00000260)

#define BP_ENET_MAC0_IEEE_T_MACERR_IEEE_T_MACERR	0
#define BM_ENET_MAC0_IEEE_T_MACERR_IEEE_T_MACERR	0xFFFFFFFF
#define BF_ENET_MAC0_IEEE_T_MACERR_IEEE_T_MACERR(v)	(v)

#define HW_ENET_MAC0_IEEE_T_CSERR	(0x00000264)

#define BP_ENET_MAC0_IEEE_T_CSERR_IEEE_T_CSERR	0
#define BM_ENET_MAC0_IEEE_T_CSERR_IEEE_T_CSERR	0xFFFFFFFF
#define BF_ENET_MAC0_IEEE_T_CSERR_IEEE_T_CSERR(v)	(v)

#define HW_ENET_MAC0_IEEE_T_SQE	(0x00000268)

#define BP_ENET_MAC0_IEEE_T_SQE_IEEE_T_SQE	0
#define BM_ENET_MAC0_IEEE_T_SQE_IEEE_T_SQE	0xFFFFFFFF
#define BF_ENET_MAC0_IEEE_T_SQE_IEEE_T_SQE(v)	(v)

#define HW_ENET_MAC0_IEEE_T_FDXFC	(0x0000026c)

#define BP_ENET_MAC0_IEEE_T_FDXFC_IEEE_T_FDXFC	0
#define BM_ENET_MAC0_IEEE_T_FDXFC_IEEE_T_FDXFC	0xFFFFFFFF
#define BF_ENET_MAC0_IEEE_T_FDXFC_IEEE_T_FDXFC(v)	(v)

#define HW_ENET_MAC0_IEEE_T_OCTETS_OK	(0x00000270)

#define BP_ENET_MAC0_IEEE_T_OCTETS_OK_IEEE_T_OCTETS_OK	0
#define BM_ENET_MAC0_IEEE_T_OCTETS_OK_IEEE_T_OCTETS_OK	0xFFFFFFFF
#define BF_ENET_MAC0_IEEE_T_OCTETS_OK_IEEE_T_OCTETS_OK(v)	(v)

#define HW_ENET_MAC0_RMON_R_PACKETS	(0x00000280)

#define BP_ENET_MAC0_RMON_R_PACKETS_RMON_R_PACKETS	0
#define BM_ENET_MAC0_RMON_R_PACKETS_RMON_R_PACKETS	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_R_PACKETS_RMON_R_PACKETS(v)	(v)

#define HW_ENET_MAC0_RMON_R_BC_PKT	(0x00000284)

#define BP_ENET_MAC0_RMON_R_BC_PKT_RMON_R_BC_PKT	0
#define BM_ENET_MAC0_RMON_R_BC_PKT_RMON_R_BC_PKT	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_R_BC_PKT_RMON_R_BC_PKT(v)	(v)

#define HW_ENET_MAC0_RMON_R_MC_PKT	(0x00000288)

#define BP_ENET_MAC0_RMON_R_MC_PKT_RMON_R_MC_PKT	0
#define BM_ENET_MAC0_RMON_R_MC_PKT_RMON_R_MC_PKT	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_R_MC_PKT_RMON_R_MC_PKT(v)	(v)

#define HW_ENET_MAC0_RMON_R_CRC_ALIGN	(0x0000028c)

#define BP_ENET_MAC0_RMON_R_CRC_ALIGN_RMON_R_CRC_ALIGN	0
#define BM_ENET_MAC0_RMON_R_CRC_ALIGN_RMON_R_CRC_ALIGN	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_R_CRC_ALIGN_RMON_R_CRC_ALIGN(v)	(v)

#define HW_ENET_MAC0_RMON_R_UNDERSIZE	(0x00000290)

#define BP_ENET_MAC0_RMON_R_UNDERSIZE_RMON_R_UNDERSIZE	0
#define BM_ENET_MAC0_RMON_R_UNDERSIZE_RMON_R_UNDERSIZE	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_R_UNDERSIZE_RMON_R_UNDERSIZE(v)	(v)

#define HW_ENET_MAC0_RMON_R_OVERSIZE	(0x00000294)

#define BP_ENET_MAC0_RMON_R_OVERSIZE_RMON_R_OVERSIZE	0
#define BM_ENET_MAC0_RMON_R_OVERSIZE_RMON_R_OVERSIZE	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_R_OVERSIZE_RMON_R_OVERSIZE(v)	(v)

#define HW_ENET_MAC0_RMON_R_FRAG	(0x00000298)

#define BP_ENET_MAC0_RMON_R_FRAG_RMON_R_FRAG	0
#define BM_ENET_MAC0_RMON_R_FRAG_RMON_R_FRAG	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_R_FRAG_RMON_R_FRAG(v)	(v)

#define HW_ENET_MAC0_RMON_R_JAB	(0x0000029c)

#define BP_ENET_MAC0_RMON_R_JAB_RMON_R_JAB	0
#define BM_ENET_MAC0_RMON_R_JAB_RMON_R_JAB	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_R_JAB_RMON_R_JAB(v)	(v)

#define HW_ENET_MAC0_RMON_R_P64	(0x000002a4)

#define BP_ENET_MAC0_RMON_R_P64_RMON_R_P64	0
#define BM_ENET_MAC0_RMON_R_P64_RMON_R_P64	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_R_P64_RMON_R_P64(v)	(v)

#define HW_ENET_MAC0_RMON_R_P65TO127	(0x000002a8)

#define BP_ENET_MAC0_RMON_R_P65TO127_RMON_R_P65TO127	0
#define BM_ENET_MAC0_RMON_R_P65TO127_RMON_R_P65TO127	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_R_P65TO127_RMON_R_P65TO127(v)	(v)

#define HW_ENET_MAC0_RMON_R_P128TO255	(0x000002ac)

#define BP_ENET_MAC0_RMON_R_P128TO255_RMON_R_P128TO255	0
#define BM_ENET_MAC0_RMON_R_P128TO255_RMON_R_P128TO255	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_R_P128TO255_RMON_R_P128TO255(v)	(v)

#define HW_ENET_MAC0_RMON_R_P256TO511	(0x000002b0)

#define BP_ENET_MAC0_RMON_R_P256TO511_RMON_R_P256TO511	0
#define BM_ENET_MAC0_RMON_R_P256TO511_RMON_R_P256TO511	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_R_P256TO511_RMON_R_P256TO511(v)	(v)

#define HW_ENET_MAC0_RMON_R_P512TO1023	(0x000002b4)

#define BP_ENET_MAC0_RMON_R_P512TO1023_RMON_R_P512TO1023	0
#define BM_ENET_MAC0_RMON_R_P512TO1023_RMON_R_P512TO1023	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_R_P512TO1023_RMON_R_P512TO1023(v)	(v)

#define HW_ENET_MAC0_RMON_R_P1024TO2047	(0x000002b8)

#define BP_ENET_MAC0_RMON_R_P1024TO2047_RMON_R_P1024TO2047	0
#define BM_ENET_MAC0_RMON_R_P1024TO2047_RMON_R_P1024TO2047	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_R_P1024TO2047_RMON_R_P1024TO2047(v)	(v)

#define HW_ENET_MAC0_RMON_R_P_GTE2048	(0x000002bc)

#define BP_ENET_MAC0_RMON_R_P_GTE2048_RMON_R_P_GTE2048	0
#define BM_ENET_MAC0_RMON_R_P_GTE2048_RMON_R_P_GTE2048	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_R_P_GTE2048_RMON_R_P_GTE2048(v)	(v)

#define HW_ENET_MAC0_RMON_R_OCTETS	(0x000002c0)

#define BP_ENET_MAC0_RMON_R_OCTETS_RMON_R_OCTETS	0
#define BM_ENET_MAC0_RMON_R_OCTETS_RMON_R_OCTETS	0xFFFFFFFF
#define BF_ENET_MAC0_RMON_R_OCTETS_RMON_R_OCTETS(v)	(v)

#define HW_ENET_MAC0_IEEE_R_DROP	(0x000002c4)

#define BP_ENET_MAC0_IEEE_R_DROP_IEEE_R_DROP	0
#define BM_ENET_MAC0_IEEE_R_DROP_IEEE_R_DROP	0xFFFFFFFF
#define BF_ENET_MAC0_IEEE_R_DROP_IEEE_R_DROP(v)	(v)

#define HW_ENET_MAC0_IEEE_R_FRAME_OK	(0x000002c8)

#define BP_ENET_MAC0_IEEE_R_FRAME_OK_IEEE_R_FRAME_OK	0
#define BM_ENET_MAC0_IEEE_R_FRAME_OK_IEEE_R_FRAME_OK	0xFFFFFFFF
#define BF_ENET_MAC0_IEEE_R_FRAME_OK_IEEE_R_FRAME_OK(v)	(v)

#define HW_ENET_MAC0_IEEE_R_CRC	(0x000002cc)

#define BP_ENET_MAC0_IEEE_R_CRC_IEEE_R_CRC	0
#define BM_ENET_MAC0_IEEE_R_CRC_IEEE_R_CRC	0xFFFFFFFF
#define BF_ENET_MAC0_IEEE_R_CRC_IEEE_R_CRC(v)	(v)

#define HW_ENET_MAC0_IEEE_R_ALIGN	(0x000002d0)

#define BP_ENET_MAC0_IEEE_R_ALIGN_IEEE_R_ALIGN	0
#define BM_ENET_MAC0_IEEE_R_ALIGN_IEEE_R_ALIGN	0xFFFFFFFF
#define BF_ENET_MAC0_IEEE_R_ALIGN_IEEE_R_ALIGN(v)	(v)

#define HW_ENET_MAC0_IEEE_R_MACERR	(0x000002d4)

#define BP_ENET_MAC0_IEEE_R_MACERR_IEEE_R_MACERR	0
#define BM_ENET_MAC0_IEEE_R_MACERR_IEEE_R_MACERR	0xFFFFFFFF
#define BF_ENET_MAC0_IEEE_R_MACERR_IEEE_R_MACERR(v)	(v)

#define HW_ENET_MAC0_IEEE_R_FDXFC	(0x000002d8)

#define BP_ENET_MAC0_IEEE_R_FDXFC_IEEE_R_FDXFC	0
#define BM_ENET_MAC0_IEEE_R_FDXFC_IEEE_R_FDXFC	0xFFFFFFFF
#define BF_ENET_MAC0_IEEE_R_FDXFC_IEEE_R_FDXFC(v)	(v)

#define HW_ENET_MAC0_IEEE_R_OCTETS_OK	(0x000002dc)

#define BP_ENET_MAC0_IEEE_R_OCTETS_OK_IEEE_R_OCTETS_OK	0
#define BM_ENET_MAC0_IEEE_R_OCTETS_OK_IEEE_R_OCTETS_OK	0xFFFFFFFF
#define BF_ENET_MAC0_IEEE_R_OCTETS_OK_IEEE_R_OCTETS_OK(v)	(v)

#define HW_ENET_MAC0_ATIME_CTRL	(0x000003fc)

#define BP_ENET_MAC0_ATIME_CTRL_RSRVD0	14
#define BM_ENET_MAC0_ATIME_CTRL_RSRVD0	0xFFFFC000
#define BF_ENET_MAC0_ATIME_CTRL_RSRVD0(v) \
		(((v) << 14) & BM_ENET_MAC0_ATIME_CTRL_RSRVD0)
#define BM_ENET_MAC0_ATIME_CTRL_FRC_SLAVE	0x00002000
#define BM_ENET_MAC0_ATIME_CTRL_RSRVD1	0x00001000
#define BM_ENET_MAC0_ATIME_CTRL_CAPTURE	0x00000800
#define BM_ENET_MAC0_ATIME_CTRL_RSRVD2	0x00000400
#define BM_ENET_MAC0_ATIME_CTRL_RESTART	0x00000200
#define BM_ENET_MAC0_ATIME_CTRL_RSRVD3	0x00000100
#define BM_ENET_MAC0_ATIME_CTRL_PIN_PERIOD_ENA	0x00000080
#define BM_ENET_MAC0_ATIME_CTRL_RSRVD4	0x00000040
#define BM_ENET_MAC0_ATIME_CTRL_EVT_PERIOD_RST	0x00000020
#define BM_ENET_MAC0_ATIME_CTRL_EVT_PERIOD_ENA	0x00000010
#define BM_ENET_MAC0_ATIME_CTRL_EVT_OFFSET_RST	0x00000008
#define BM_ENET_MAC0_ATIME_CTRL_EVT_OFFSET_ENA	0x00000004
#define BM_ENET_MAC0_ATIME_CTRL_ONE_SHOT	0x00000002
#define BM_ENET_MAC0_ATIME_CTRL_ENABLE	0x00000001

#define HW_ENET_MAC0_ATIME	(0x00000400)

#define BP_ENET_MAC0_ATIME_ATIME	0
#define BM_ENET_MAC0_ATIME_ATIME	0xFFFFFFFF
#define BF_ENET_MAC0_ATIME_ATIME(v)	(v)

#define HW_ENET_MAC0_ATIME_EVT_OFFSET	(0x00000404)

#define BP_ENET_MAC0_ATIME_EVT_OFFSET_ATIME_EVT_OFFSET	0
#define BM_ENET_MAC0_ATIME_EVT_OFFSET_ATIME_EVT_OFFSET	0xFFFFFFFF
#define BF_ENET_MAC0_ATIME_EVT_OFFSET_ATIME_EVT_OFFSET(v)	(v)

#define HW_ENET_MAC0_ATIME_EVT_PERIOD	(0x00000408)

#define BP_ENET_MAC0_ATIME_EVT_PERIOD_ATIME_EVT_PERIOD	0
#define BM_ENET_MAC0_ATIME_EVT_PERIOD_ATIME_EVT_PERIOD	0xFFFFFFFF
#define BF_ENET_MAC0_ATIME_EVT_PERIOD_ATIME_EVT_PERIOD(v)	(v)

#define HW_ENET_MAC0_ATIME_CORR	(0x0000040c)

#define BM_ENET_MAC0_ATIME_CORR_RSRVD0	0x80000000
#define BP_ENET_MAC0_ATIME_CORR_ATIME_CORR	0
#define BM_ENET_MAC0_ATIME_CORR_ATIME_CORR	0x7FFFFFFF
#define BF_ENET_MAC0_ATIME_CORR_ATIME_CORR(v)  \
		(((v) << 0) & BM_ENET_MAC0_ATIME_CORR_ATIME_CORR)

#define HW_ENET_MAC0_ATIME_INC	(0x00000410)

#define BP_ENET_MAC0_ATIME_INC_RSRVD0	15
#define BM_ENET_MAC0_ATIME_INC_RSRVD0	0xFFFF8000
#define BF_ENET_MAC0_ATIME_INC_RSRVD0(v) \
		(((v) << 15) & BM_ENET_MAC0_ATIME_INC_RSRVD0)
#define BP_ENET_MAC0_ATIME_INC_ATIME_INC_CORR	8
#define BM_ENET_MAC0_ATIME_INC_ATIME_INC_CORR	0x00007F00
#define BF_ENET_MAC0_ATIME_INC_ATIME_INC_CORR(v)  \
		(((v) << 8) & BM_ENET_MAC0_ATIME_INC_ATIME_INC_CORR)
#define BM_ENET_MAC0_ATIME_INC_RSRVD1	0x00000080
#define BP_ENET_MAC0_ATIME_INC_ATIME_INC	0
#define BM_ENET_MAC0_ATIME_INC_ATIME_INC	0x0000007F
#define BF_ENET_MAC0_ATIME_INC_ATIME_INC(v)  \
		(((v) << 0) & BM_ENET_MAC0_ATIME_INC_ATIME_INC)

#define HW_ENET_MAC0_TS_TIMESTAMP	(0x00000414)

#define BP_ENET_MAC0_TS_TIMESTAMP_TS_TIMESTAMP	0
#define BM_ENET_MAC0_TS_TIMESTAMP_TS_TIMESTAMP	0xFFFFFFFF
#define BF_ENET_MAC0_TS_TIMESTAMP_TS_TIMESTAMP(v)	(v)

#define HW_ENET_MAC0_SMAC_0_0	(0x000004fc)

#define BP_ENET_MAC0_SMAC_0_0_SMAC_0_0	0
#define BM_ENET_MAC0_SMAC_0_0_SMAC_0_0	0xFFFFFFFF
#define BF_ENET_MAC0_SMAC_0_0_SMAC_0_0(v)	(v)

#define HW_ENET_MAC0_SMAC_0_1	(0x00000500)

#define BP_ENET_MAC0_SMAC_0_1_SMAC_0_1	0
#define BM_ENET_MAC0_SMAC_0_1_SMAC_0_1	0xFFFFFFFF
#define BF_ENET_MAC0_SMAC_0_1_SMAC_0_1(v)	(v)

#define HW_ENET_MAC0_SMAC_1_0	(0x00000504)

#define BP_ENET_MAC0_SMAC_1_0_SMAC_1_0	0
#define BM_ENET_MAC0_SMAC_1_0_SMAC_1_0	0xFFFFFFFF
#define BF_ENET_MAC0_SMAC_1_0_SMAC_1_0(v)	(v)

#define HW_ENET_MAC0_SMAC_1_1	(0x00000508)

#define BP_ENET_MAC0_SMAC_1_1_SMAC_1_1	0
#define BM_ENET_MAC0_SMAC_1_1_SMAC_1_1	0xFFFFFFFF
#define BF_ENET_MAC0_SMAC_1_1_SMAC_1_1(v)	(v)

#define HW_ENET_MAC0_SMAC_2_0	(0x0000050c)

#define BP_ENET_MAC0_SMAC_2_0_SMAC_2_0	0
#define BM_ENET_MAC0_SMAC_2_0_SMAC_2_0	0xFFFFFFFF
#define BF_ENET_MAC0_SMAC_2_0_SMAC_2_0(v)	(v)

#define HW_ENET_MAC0_SMAC_2_1	(0x00000510)

#define BP_ENET_MAC0_SMAC_2_1_SMAC_2_1	0
#define BM_ENET_MAC0_SMAC_2_1_SMAC_2_1	0xFFFFFFFF
#define BF_ENET_MAC0_SMAC_2_1_SMAC_2_1(v)	(v)

#define HW_ENET_MAC0_SMAC_3_0	(0x00000514)

#define BP_ENET_MAC0_SMAC_3_0_SMAC_3_0	0
#define BM_ENET_MAC0_SMAC_3_0_SMAC_3_0	0xFFFFFFFF
#define BF_ENET_MAC0_SMAC_3_0_SMAC_3_0(v)	(v)

#define HW_ENET_MAC0_SMAC_3_1	(0x00000518)

#define BP_ENET_MAC0_SMAC_3_1_SMAC_3_1	0
#define BM_ENET_MAC0_SMAC_3_1_SMAC_3_1	0xFFFFFFFF
#define BF_ENET_MAC0_SMAC_3_1_SMAC_3_1(v)	(v)

#define HW_ENET_MAC0_COMP_REG_0	(0x000005fc)

#define BP_ENET_MAC0_COMP_REG_0_COMP_REG_0	0
#define BM_ENET_MAC0_COMP_REG_0_COMP_REG_0	0xFFFFFFFF
#define BF_ENET_MAC0_COMP_REG_0_COMP_REG_0(v)	(v)

#define HW_ENET_MAC0_COMP_REG_1	(0x00000600)

#define BP_ENET_MAC0_COMP_REG_1_COMP_REG_1	0
#define BM_ENET_MAC0_COMP_REG_1_COMP_REG_1	0xFFFFFFFF
#define BF_ENET_MAC0_COMP_REG_1_COMP_REG_1(v)	(v)

#define HW_ENET_MAC0_COMP_REG_2	(0x00000604)

#define BP_ENET_MAC0_COMP_REG_2_COMP_REG_2	0
#define BM_ENET_MAC0_COMP_REG_2_COMP_REG_2	0xFFFFFFFF
#define BF_ENET_MAC0_COMP_REG_2_COMP_REG_2(v)	(v)

#define HW_ENET_MAC0_COMP_REG_3	(0x00000608)

#define BP_ENET_MAC0_COMP_REG_3_COMP_REG_3	0
#define BM_ENET_MAC0_COMP_REG_3_COMP_REG_3	0xFFFFFFFF
#define BF_ENET_MAC0_COMP_REG_3_COMP_REG_3(v)	(v)

#define HW_ENET_MAC0_CAPT_REG_0	(0x0000063c)

#define BP_ENET_MAC0_CAPT_REG_0_CAPT_REG_0	0
#define BM_ENET_MAC0_CAPT_REG_0_CAPT_REG_0	0xFFFFFFFF
#define BF_ENET_MAC0_CAPT_REG_0_CAPT_REG_0(v)	(v)

#define HW_ENET_MAC0_CAPT_REG_1	(0x00000640)

#define BP_ENET_MAC0_CAPT_REG_1_CAPT_REG_1	0
#define BM_ENET_MAC0_CAPT_REG_1_CAPT_REG_1	0xFFFFFFFF
#define BF_ENET_MAC0_CAPT_REG_1_CAPT_REG_1(v)	(v)

#define HW_ENET_MAC0_CAPT_REG_2	(0x00000644)

#define BP_ENET_MAC0_CAPT_REG_2_CAPT_REG_2	0
#define BM_ENET_MAC0_CAPT_REG_2_CAPT_REG_2	0xFFFFFFFF
#define BF_ENET_MAC0_CAPT_REG_2_CAPT_REG_2(v)	(v)

#define HW_ENET_MAC0_CAPT_REG_3	(0x00000648)

#define BP_ENET_MAC0_CAPT_REG_3_CAPT_REG_3	0
#define BM_ENET_MAC0_CAPT_REG_3_CAPT_REG_3	0xFFFFFFFF
#define BF_ENET_MAC0_CAPT_REG_3_CAPT_REG_3(v)	(v)

#define HW_ENET_MAC0_CCB_INT	(0x0000067c)

#define BP_ENET_MAC0_CCB_INT_RSRVD0	20
#define BM_ENET_MAC0_CCB_INT_RSRVD0	0xFFF00000
#define BF_ENET_MAC0_CCB_INT_RSRVD0(v) \
		(((v) << 20) & BM_ENET_MAC0_CCB_INT_RSRVD0)
#define BM_ENET_MAC0_CCB_INT_COMPARE3	0x00080000
#define BM_ENET_MAC0_CCB_INT_COMPARE2	0x00040000
#define BM_ENET_MAC0_CCB_INT_COMPARE1	0x00020000
#define BM_ENET_MAC0_CCB_INT_COMPARE0	0x00010000
#define BP_ENET_MAC0_CCB_INT_RSRVD1	4
#define BM_ENET_MAC0_CCB_INT_RSRVD1	0x0000FFF0
#define BF_ENET_MAC0_CCB_INT_RSRVD1(v)  \
		(((v) << 4) & BM_ENET_MAC0_CCB_INT_RSRVD1)
#define BM_ENET_MAC0_CCB_INT_CAPTURE3	0x00000008
#define BM_ENET_MAC0_CCB_INT_CAPTURE2	0x00000004
#define BM_ENET_MAC0_CCB_INT_CAPTURE1	0x00000002
#define BM_ENET_MAC0_CCB_INT_CAPTURE0	0x00000001

#define HW_ENET_MAC0_CCB_INT_MASK	(0x00000680)

#define BP_ENET_MAC0_CCB_INT_MASK_RSRVD0	20
#define BM_ENET_MAC0_CCB_INT_MASK_RSRVD0	0xFFF00000
#define BF_ENET_MAC0_CCB_INT_MASK_RSRVD0(v) \
		(((v) << 20) & BM_ENET_MAC0_CCB_INT_MASK_RSRVD0)
#define BM_ENET_MAC0_CCB_INT_MASK_COMPARE3	0x00080000
#define BM_ENET_MAC0_CCB_INT_MASK_COMPARE2	0x00040000
#define BM_ENET_MAC0_CCB_INT_MASK_COMPARE1	0x00020000
#define BM_ENET_MAC0_CCB_INT_MASK_COMPARE0	0x00010000
#define BP_ENET_MAC0_CCB_INT_MASK_RSRVD1	4
#define BM_ENET_MAC0_CCB_INT_MASK_RSRVD1	0x0000FFF0
#define BF_ENET_MAC0_CCB_INT_MASK_RSRVD1(v)  \
		(((v) << 4) & BM_ENET_MAC0_CCB_INT_MASK_RSRVD1)
#define BM_ENET_MAC0_CCB_INT_MASK_CAPTURE3	0x00000008
#define BM_ENET_MAC0_CCB_INT_MASK_CAPTURE2	0x00000004
#define BM_ENET_MAC0_CCB_INT_MASK_CAPTURE1	0x00000002
#define BM_ENET_MAC0_CCB_INT_MASK_CAPTURE0	0x00000001

#define HW_ENET_MAC1_EIR	(0x00004000)

#define BM_ENET_MAC1_EIR_RSRVD0	0x80000000
#define BM_ENET_MAC1_EIR_BABR	0x40000000
#define BM_ENET_MAC1_EIR_BABT	0x20000000
#define BM_ENET_MAC1_EIR_GRA	0x10000000
#define BM_ENET_MAC1_EIR_TXF	0x08000000
#define BM_ENET_MAC1_EIR_TXB	0x04000000
#define BM_ENET_MAC1_EIR_RXF	0x02000000
#define BM_ENET_MAC1_EIR_RXB	0x01000000
#define BM_ENET_MAC1_EIR_MII	0x00800000
#define BM_ENET_MAC1_EIR_EBERR	0x00400000
#define BM_ENET_MAC1_EIR_LC	0x00200000
#define BM_ENET_MAC1_EIR_RL	0x00100000
#define BM_ENET_MAC1_EIR_UN	0x00080000
#define BM_ENET_MAC1_EIR_PLR	0x00040000
#define BM_ENET_MAC1_EIR_WAKEUP	0x00020000
#define BM_ENET_MAC1_EIR_TS_AVAIL	0x00010000
#define BM_ENET_MAC1_EIR_TS_TIMER	0x00008000
#define BP_ENET_MAC1_EIR_RSRVD1	0
#define BM_ENET_MAC1_EIR_RSRVD1	0x00007FFF
#define BF_ENET_MAC1_EIR_RSRVD1(v)  \
		(((v) << 0) & BM_ENET_MAC1_EIR_RSRVD1)

#define HW_ENET_MAC1_EIMR	(0x00004004)

#define BP_ENET_MAC1_EIMR_EIMR	0
#define BM_ENET_MAC1_EIMR_EIMR	0xFFFFFFFF
#define BF_ENET_MAC1_EIMR_EIMR(v)	(v)

#define HW_ENET_MAC1_RDAR	(0x0000400c)

#define BP_ENET_MAC1_RDAR_RSRVD0	25
#define BM_ENET_MAC1_RDAR_RSRVD0	0xFE000000
#define BF_ENET_MAC1_RDAR_RSRVD0(v) \
		(((v) << 25) & BM_ENET_MAC1_RDAR_RSRVD0)
#define BM_ENET_MAC1_RDAR_RDAR	0x01000000
#define BP_ENET_MAC1_RDAR_RSRVD1	0
#define BM_ENET_MAC1_RDAR_RSRVD1	0x00FFFFFF
#define BF_ENET_MAC1_RDAR_RSRVD1(v)  \
		(((v) << 0) & BM_ENET_MAC1_RDAR_RSRVD1)

#define HW_ENET_MAC1_TDAR	(0x00004010)

#define BP_ENET_MAC1_TDAR_RSRVD0	25
#define BM_ENET_MAC1_TDAR_RSRVD0	0xFE000000
#define BF_ENET_MAC1_TDAR_RSRVD0(v) \
		(((v) << 25) & BM_ENET_MAC1_TDAR_RSRVD0)
#define BM_ENET_MAC1_TDAR_TDAR	0x01000000
#define BP_ENET_MAC1_TDAR_RSRVD1	0
#define BM_ENET_MAC1_TDAR_RSRVD1	0x00FFFFFF
#define BF_ENET_MAC1_TDAR_RSRVD1(v)  \
		(((v) << 0) & BM_ENET_MAC1_TDAR_RSRVD1)

#define HW_ENET_MAC1_ECR	(0x00004020)

#define BP_ENET_MAC1_ECR_RSRVD0	7
#define BM_ENET_MAC1_ECR_RSRVD0	0xFFFFFF80
#define BF_ENET_MAC1_ECR_RSRVD0(v) \
		(((v) << 7) & BM_ENET_MAC1_ECR_RSRVD0)
#define BM_ENET_MAC1_ECR_DBG_EN	0x00000040
#define BM_ENET_MAC1_ECR_ETH_SPEED	0x00000020
#define BM_ENET_MAC1_ECR_ENA_1588	0x00000010
#define BM_ENET_MAC1_ECR_SLEEP	0x00000008
#define BM_ENET_MAC1_ECR_MAGIC_ENA	0x00000004
#define BM_ENET_MAC1_ECR_ETHER_EN	0x00000002
#define BM_ENET_MAC1_ECR_RESET	0x00000001

#define HW_ENET_MAC1_MMFR	(0x0000403c)

#define BP_ENET_MAC1_MMFR_ST	30
#define BM_ENET_MAC1_MMFR_ST	0xC0000000
#define BF_ENET_MAC1_MMFR_ST(v) \
		(((v) << 30) & BM_ENET_MAC1_MMFR_ST)
#define BP_ENET_MAC1_MMFR_OP	28
#define BM_ENET_MAC1_MMFR_OP	0x30000000
#define BF_ENET_MAC1_MMFR_OP(v)  \
		(((v) << 28) & BM_ENET_MAC1_MMFR_OP)
#define BP_ENET_MAC1_MMFR_PA	23
#define BM_ENET_MAC1_MMFR_PA	0x0F800000
#define BF_ENET_MAC1_MMFR_PA(v)  \
		(((v) << 23) & BM_ENET_MAC1_MMFR_PA)
#define BP_ENET_MAC1_MMFR_RA	18
#define BM_ENET_MAC1_MMFR_RA	0x007C0000
#define BF_ENET_MAC1_MMFR_RA(v)  \
		(((v) << 18) & BM_ENET_MAC1_MMFR_RA)
#define BP_ENET_MAC1_MMFR_TA	16
#define BM_ENET_MAC1_MMFR_TA	0x00030000
#define BF_ENET_MAC1_MMFR_TA(v)  \
		(((v) << 16) & BM_ENET_MAC1_MMFR_TA)
#define BP_ENET_MAC1_MMFR_DATA	0
#define BM_ENET_MAC1_MMFR_DATA	0x0000FFFF
#define BF_ENET_MAC1_MMFR_DATA(v)  \
		(((v) << 0) & BM_ENET_MAC1_MMFR_DATA)

#define HW_ENET_MAC1_MSCR	(0x00004040)

#define BP_ENET_MAC1_MSCR_RSRVD0	11
#define BM_ENET_MAC1_MSCR_RSRVD0	0xFFFFF800
#define BF_ENET_MAC1_MSCR_RSRVD0(v) \
		(((v) << 11) & BM_ENET_MAC1_MSCR_RSRVD0)
#define BP_ENET_MAC1_MSCR_HOLDTIME	8
#define BM_ENET_MAC1_MSCR_HOLDTIME	0x00000700
#define BF_ENET_MAC1_MSCR_HOLDTIME(v)  \
		(((v) << 8) & BM_ENET_MAC1_MSCR_HOLDTIME)
#define BM_ENET_MAC1_MSCR_DIS_PRE	0x00000080
#define BP_ENET_MAC1_MSCR_MII_SPEED	1
#define BM_ENET_MAC1_MSCR_MII_SPEED	0x0000007E
#define BF_ENET_MAC1_MSCR_MII_SPEED(v)  \
		(((v) << 1) & BM_ENET_MAC1_MSCR_MII_SPEED)
#define BM_ENET_MAC1_MSCR_RSRVD1	0x00000001

#define HW_ENET_MAC1_MIBC	(0x00004060)

#define BM_ENET_MAC1_MIBC_MIB_DIS	0x80000000
#define BM_ENET_MAC1_MIBC_MIB_IDLE	0x40000000
#define BM_ENET_MAC1_MIBC_MIB_CLEAR	0x20000000
#define BP_ENET_MAC1_MIBC_RSRVD0	0
#define BM_ENET_MAC1_MIBC_RSRVD0	0x1FFFFFFF
#define BF_ENET_MAC1_MIBC_RSRVD0(v)  \
		(((v) << 0) & BM_ENET_MAC1_MIBC_RSRVD0)

#define HW_ENET_MAC1_RCR	(0x00004080)

#define BM_ENET_MAC1_RCR_GRS	0x80000000
#define BM_ENET_MAC1_RCR_NO_LGTH_CHECK	0x40000000
#define BP_ENET_MAC1_RCR_MAX_FL	16
#define BM_ENET_MAC1_RCR_MAX_FL	0x3FFF0000
#define BF_ENET_MAC1_RCR_MAX_FL(v)  \
		(((v) << 16) & BM_ENET_MAC1_RCR_MAX_FL)
#define BM_ENET_MAC1_RCR_CNTL_FRM_ENA	0x00008000
#define BM_ENET_MAC1_RCR_CRC_FWD	0x00004000
#define BM_ENET_MAC1_RCR_PAUSE_FWD	0x00002000
#define BM_ENET_MAC1_RCR_PAD_EN	0x00001000
#define BM_ENET_MAC1_RCR_RMII_ECHO	0x00000800
#define BM_ENET_MAC1_RCR_RMII_LOOP	0x00000400
#define BM_ENET_MAC1_RCR_RMII_10T	0x00000200
#define BM_ENET_MAC1_RCR_RMII_MODE	0x00000100
#define BM_ENET_MAC1_RCR_SGMII_ENA	0x00000080
#define BM_ENET_MAC1_RCR_RGMII_ENA	0x00000040
#define BM_ENET_MAC1_RCR_FCE	0x00000020
#define BM_ENET_MAC1_RCR_BC_REJ	0x00000010
#define BM_ENET_MAC1_RCR_PROM	0x00000008
#define BM_ENET_MAC1_RCR_MII_MODE	0x00000004
#define BM_ENET_MAC1_RCR_DRT	0x00000002
#define BM_ENET_MAC1_RCR_LOOP	0x00000001

#define HW_ENET_MAC1_TCR	(0x000040c0)

#define BP_ENET_MAC1_TCR_RSRVD0	10
#define BM_ENET_MAC1_TCR_RSRVD0	0xFFFFFC00
#define BF_ENET_MAC1_TCR_RSRVD0(v) \
		(((v) << 10) & BM_ENET_MAC1_TCR_RSRVD0)
#define BM_ENET_MAC1_TCR_TX_CRC_FWD	0x00000200
#define BM_ENET_MAC1_TCR_TX_ADDR_INS	0x00000100
#define BP_ENET_MAC1_TCR_TX_ADDR_SEL	5
#define BM_ENET_MAC1_TCR_TX_ADDR_SEL	0x000000E0
#define BF_ENET_MAC1_TCR_TX_ADDR_SEL(v)  \
		(((v) << 5) & BM_ENET_MAC1_TCR_TX_ADDR_SEL)
#define BM_ENET_MAC1_TCR_RFC_PAUSE	0x00000010
#define BM_ENET_MAC1_TCR_TFC_PAUSE	0x00000008
#define BM_ENET_MAC1_TCR_FEDN	0x00000004
#define BM_ENET_MAC1_TCR_HBC	0x00000002
#define BM_ENET_MAC1_TCR_GTS	0x00000001

#define HW_ENET_MAC1_PALR	(0x000040e0)

#define BP_ENET_MAC1_PALR_PADDR1	0
#define BM_ENET_MAC1_PALR_PADDR1	0xFFFFFFFF
#define BF_ENET_MAC1_PALR_PADDR1(v)	(v)

#define HW_ENET_MAC1_PAUR	(0x000040e4)

#define BP_ENET_MAC1_PAUR_PADDR2	16
#define BM_ENET_MAC1_PAUR_PADDR2	0xFFFF0000
#define BF_ENET_MAC1_PAUR_PADDR2(v) \
		(((v) << 16) & BM_ENET_MAC1_PAUR_PADDR2)
#define BP_ENET_MAC1_PAUR_TYPE	0
#define BM_ENET_MAC1_PAUR_TYPE	0x0000FFFF
#define BF_ENET_MAC1_PAUR_TYPE(v)  \
		(((v) << 0) & BM_ENET_MAC1_PAUR_TYPE)

#define HW_ENET_MAC1_OPD	(0x000040e8)

#define BP_ENET_MAC1_OPD_OPCODE	16
#define BM_ENET_MAC1_OPD_OPCODE	0xFFFF0000
#define BF_ENET_MAC1_OPD_OPCODE(v) \
		(((v) << 16) & BM_ENET_MAC1_OPD_OPCODE)
#define BP_ENET_MAC1_OPD_PAUSE_DUR	0
#define BM_ENET_MAC1_OPD_PAUSE_DUR	0x0000FFFF
#define BF_ENET_MAC1_OPD_PAUSE_DUR(v)  \
		(((v) << 0) & BM_ENET_MAC1_OPD_PAUSE_DUR)

#define HW_ENET_MAC1_IAUR	(0x00004114)

#define BP_ENET_MAC1_IAUR_IADDR1	0
#define BM_ENET_MAC1_IAUR_IADDR1	0xFFFFFFFF
#define BF_ENET_MAC1_IAUR_IADDR1(v)	(v)

#define HW_ENET_MAC1_IALR	(0x00004118)

#define BP_ENET_MAC1_IALR_IADDR2	0
#define BM_ENET_MAC1_IALR_IADDR2	0xFFFFFFFF
#define BF_ENET_MAC1_IALR_IADDR2(v)	(v)

#define HW_ENET_MAC1_GAUR	(0x0000411c)

#define BP_ENET_MAC1_GAUR_GADDR1	0
#define BM_ENET_MAC1_GAUR_GADDR1	0xFFFFFFFF
#define BF_ENET_MAC1_GAUR_GADDR1(v)	(v)

#define HW_ENET_MAC1_GALR	(0x00004120)

#define BP_ENET_MAC1_GALR_GADDR2	0
#define BM_ENET_MAC1_GALR_GADDR2	0xFFFFFFFF
#define BF_ENET_MAC1_GALR_GADDR2(v)	(v)

#define HW_ENET_MAC1_TFW_SFCR	(0x00004140)

#define BP_ENET_MAC1_TFW_SFCR_RSRVD0	9
#define BM_ENET_MAC1_TFW_SFCR_RSRVD0	0xFFFFFE00
#define BF_ENET_MAC1_TFW_SFCR_RSRVD0(v) \
		(((v) << 9) & BM_ENET_MAC1_TFW_SFCR_RSRVD0)
#define BM_ENET_MAC1_TFW_SFCR_STR_FWD	0x00000100
#define BP_ENET_MAC1_TFW_SFCR_RSRVD1	6
#define BM_ENET_MAC1_TFW_SFCR_RSRVD1	0x000000C0
#define BF_ENET_MAC1_TFW_SFCR_RSRVD1(v)  \
		(((v) << 6) & BM_ENET_MAC1_TFW_SFCR_RSRVD1)
#define BP_ENET_MAC1_TFW_SFCR_TFWR	0
#define BM_ENET_MAC1_TFW_SFCR_TFWR	0x0000003F
#define BF_ENET_MAC1_TFW_SFCR_TFWR(v)  \
		(((v) << 0) & BM_ENET_MAC1_TFW_SFCR_TFWR)

#define HW_ENET_MAC1_FRBR	(0x00004148)

#define BP_ENET_MAC1_FRBR_RSRVD0	10
#define BM_ENET_MAC1_FRBR_RSRVD0	0xFFFFFC00
#define BF_ENET_MAC1_FRBR_RSRVD0(v) \
		(((v) << 10) & BM_ENET_MAC1_FRBR_RSRVD0)
#define BP_ENET_MAC1_FRBR_R_BOUND	2
#define BM_ENET_MAC1_FRBR_R_BOUND	0x000003FC
#define BF_ENET_MAC1_FRBR_R_BOUND(v)  \
		(((v) << 2) & BM_ENET_MAC1_FRBR_R_BOUND)
#define BP_ENET_MAC1_FRBR_RSRVD1	0
#define BM_ENET_MAC1_FRBR_RSRVD1	0x00000003
#define BF_ENET_MAC1_FRBR_RSRVD1(v)  \
		(((v) << 0) & BM_ENET_MAC1_FRBR_RSRVD1)

#define HW_ENET_MAC1_FRSR	(0x0000414c)

#define BP_ENET_MAC1_FRSR_RSRVD0	11
#define BM_ENET_MAC1_FRSR_RSRVD0	0xFFFFF800
#define BF_ENET_MAC1_FRSR_RSRVD0(v) \
		(((v) << 11) & BM_ENET_MAC1_FRSR_RSRVD0)
#define BM_ENET_MAC1_FRSR_RSRVD1	0x00000400
#define BP_ENET_MAC1_FRSR_R_FSTART	2
#define BM_ENET_MAC1_FRSR_R_FSTART	0x000003FC
#define BF_ENET_MAC1_FRSR_R_FSTART(v)  \
		(((v) << 2) & BM_ENET_MAC1_FRSR_R_FSTART)
#define BP_ENET_MAC1_FRSR_RSRVD2	0
#define BM_ENET_MAC1_FRSR_RSRVD2	0x00000003
#define BF_ENET_MAC1_FRSR_RSRVD2(v)  \
		(((v) << 0) & BM_ENET_MAC1_FRSR_RSRVD2)

#define HW_ENET_MAC1_ERDSR	(0x0000417c)

#define BP_ENET_MAC1_ERDSR_R_DES_START	2
#define BM_ENET_MAC1_ERDSR_R_DES_START	0xFFFFFFFC
#define BF_ENET_MAC1_ERDSR_R_DES_START(v) \
		(((v) << 2) & BM_ENET_MAC1_ERDSR_R_DES_START)
#define BP_ENET_MAC1_ERDSR_RSRVD0	0
#define BM_ENET_MAC1_ERDSR_RSRVD0	0x00000003
#define BF_ENET_MAC1_ERDSR_RSRVD0(v)  \
		(((v) << 0) & BM_ENET_MAC1_ERDSR_RSRVD0)

#define HW_ENET_MAC1_ETDSR	(0x00004180)

#define BP_ENET_MAC1_ETDSR_X_DES_START	2
#define BM_ENET_MAC1_ETDSR_X_DES_START	0xFFFFFFFC
#define BF_ENET_MAC1_ETDSR_X_DES_START(v) \
		(((v) << 2) & BM_ENET_MAC1_ETDSR_X_DES_START)
#define BP_ENET_MAC1_ETDSR_RSRVD0	0
#define BM_ENET_MAC1_ETDSR_RSRVD0	0x00000003
#define BF_ENET_MAC1_ETDSR_RSRVD0(v)  \
		(((v) << 0) & BM_ENET_MAC1_ETDSR_RSRVD0)

#define HW_ENET_MAC1_EMRBR	(0x00004184)

#define BP_ENET_MAC1_EMRBR_RSRVD0	11
#define BM_ENET_MAC1_EMRBR_RSRVD0	0xFFFFF800
#define BF_ENET_MAC1_EMRBR_RSRVD0(v) \
		(((v) << 11) & BM_ENET_MAC1_EMRBR_RSRVD0)
#define BP_ENET_MAC1_EMRBR_R_BUF_SIZE	4
#define BM_ENET_MAC1_EMRBR_R_BUF_SIZE	0x000007F0
#define BF_ENET_MAC1_EMRBR_R_BUF_SIZE(v)  \
		(((v) << 4) & BM_ENET_MAC1_EMRBR_R_BUF_SIZE)
#define BP_ENET_MAC1_EMRBR_RSRVD1	0
#define BM_ENET_MAC1_EMRBR_RSRVD1	0x0000000F
#define BF_ENET_MAC1_EMRBR_RSRVD1(v)  \
		(((v) << 0) & BM_ENET_MAC1_EMRBR_RSRVD1)

#define HW_ENET_MAC1_RX_SECTION_FULL	(0x0000418c)

#define BP_ENET_MAC1_RX_SECTION_FULL_RSRVD0	8
#define BM_ENET_MAC1_RX_SECTION_FULL_RSRVD0	0xFFFFFF00
#define BF_ENET_MAC1_RX_SECTION_FULL_RSRVD0(v) \
		(((v) << 8) & BM_ENET_MAC1_RX_SECTION_FULL_RSRVD0)
#define BP_ENET_MAC1_RX_SECTION_FULL_RX_SECTION_FULL	0
#define BM_ENET_MAC1_RX_SECTION_FULL_RX_SECTION_FULL	0x000000FF
#define BF_ENET_MAC1_RX_SECTION_FULL_RX_SECTION_FULL(v)  \
		(((v) << 0) & BM_ENET_MAC1_RX_SECTION_FULL_RX_SECTION_FULL)

#define HW_ENET_MAC1_RX_SECTION_EMPTY	(0x00004190)

#define BP_ENET_MAC1_RX_SECTION_EMPTY_RSRVD0	8
#define BM_ENET_MAC1_RX_SECTION_EMPTY_RSRVD0	0xFFFFFF00
#define BF_ENET_MAC1_RX_SECTION_EMPTY_RSRVD0(v) \
		(((v) << 8) & BM_ENET_MAC1_RX_SECTION_EMPTY_RSRVD0)
#define BP_ENET_MAC1_RX_SECTION_EMPTY_RX_SECTION_EMPTY	0
#define BM_ENET_MAC1_RX_SECTION_EMPTY_RX_SECTION_EMPTY	0x000000FF
#define BF_ENET_MAC1_RX_SECTION_EMPTY_RX_SECTION_EMPTY(v)  \
		(((v) << 0) & BM_ENET_MAC1_RX_SECTION_EMPTY_RX_SECTION_EMPTY)

#define HW_ENET_MAC1_RX_ALMOST_EMPTY	(0x00004194)

#define BP_ENET_MAC1_RX_ALMOST_EMPTY_RSRVD0	8
#define BM_ENET_MAC1_RX_ALMOST_EMPTY_RSRVD0	0xFFFFFF00
#define BF_ENET_MAC1_RX_ALMOST_EMPTY_RSRVD0(v) \
		(((v) << 8) & BM_ENET_MAC1_RX_ALMOST_EMPTY_RSRVD0)
#define BP_ENET_MAC1_RX_ALMOST_EMPTY_RX_ALMOST_EMPTY	0
#define BM_ENET_MAC1_RX_ALMOST_EMPTY_RX_ALMOST_EMPTY	0x000000FF
#define BF_ENET_MAC1_RX_ALMOST_EMPTY_RX_ALMOST_EMPTY(v)  \
		(((v) << 0) & BM_ENET_MAC1_RX_ALMOST_EMPTY_RX_ALMOST_EMPTY)

#define HW_ENET_MAC1_RX_ALMOST_FULL	(0x00004198)

#define BP_ENET_MAC1_RX_ALMOST_FULL_RSRVD0	8
#define BM_ENET_MAC1_RX_ALMOST_FULL_RSRVD0	0xFFFFFF00
#define BF_ENET_MAC1_RX_ALMOST_FULL_RSRVD0(v) \
		(((v) << 8) & BM_ENET_MAC1_RX_ALMOST_FULL_RSRVD0)
#define BP_ENET_MAC1_RX_ALMOST_FULL_RX_ALMOST_FULL	0
#define BM_ENET_MAC1_RX_ALMOST_FULL_RX_ALMOST_FULL	0x000000FF
#define BF_ENET_MAC1_RX_ALMOST_FULL_RX_ALMOST_FULL(v)  \
		(((v) << 0) & BM_ENET_MAC1_RX_ALMOST_FULL_RX_ALMOST_FULL)

#define HW_ENET_MAC1_TX_SECTION_EMPTY	(0x0000419c)

#define BP_ENET_MAC1_TX_SECTION_EMPTY_RSRVD0	8
#define BM_ENET_MAC1_TX_SECTION_EMPTY_RSRVD0	0xFFFFFF00
#define BF_ENET_MAC1_TX_SECTION_EMPTY_RSRVD0(v) \
		(((v) << 8) & BM_ENET_MAC1_TX_SECTION_EMPTY_RSRVD0)
#define BP_ENET_MAC1_TX_SECTION_EMPTY_TX_SECTION_EMPTY	0
#define BM_ENET_MAC1_TX_SECTION_EMPTY_TX_SECTION_EMPTY	0x000000FF
#define BF_ENET_MAC1_TX_SECTION_EMPTY_TX_SECTION_EMPTY(v)  \
		(((v) << 0) & BM_ENET_MAC1_TX_SECTION_EMPTY_TX_SECTION_EMPTY)

#define HW_ENET_MAC1_TX_ALMOST_EMPTY	(0x000041a0)

#define BP_ENET_MAC1_TX_ALMOST_EMPTY_RSRVD0	8
#define BM_ENET_MAC1_TX_ALMOST_EMPTY_RSRVD0	0xFFFFFF00
#define BF_ENET_MAC1_TX_ALMOST_EMPTY_RSRVD0(v) \
		(((v) << 8) & BM_ENET_MAC1_TX_ALMOST_EMPTY_RSRVD0)
#define BP_ENET_MAC1_TX_ALMOST_EMPTY_TX_ALMOST_EMPTY	0
#define BM_ENET_MAC1_TX_ALMOST_EMPTY_TX_ALMOST_EMPTY	0x000000FF
#define BF_ENET_MAC1_TX_ALMOST_EMPTY_TX_ALMOST_EMPTY(v)  \
		(((v) << 0) & BM_ENET_MAC1_TX_ALMOST_EMPTY_TX_ALMOST_EMPTY)

#define HW_ENET_MAC1_TX_ALMOST_FULL	(0x000041a4)

#define BP_ENET_MAC1_TX_ALMOST_FULL_RSRVD0	8
#define BM_ENET_MAC1_TX_ALMOST_FULL_RSRVD0	0xFFFFFF00
#define BF_ENET_MAC1_TX_ALMOST_FULL_RSRVD0(v) \
		(((v) << 8) & BM_ENET_MAC1_TX_ALMOST_FULL_RSRVD0)
#define BP_ENET_MAC1_TX_ALMOST_FULL_TX_ALMOST_FULL	0
#define BM_ENET_MAC1_TX_ALMOST_FULL_TX_ALMOST_FULL	0x000000FF
#define BF_ENET_MAC1_TX_ALMOST_FULL_TX_ALMOST_FULL(v)  \
		(((v) << 0) & BM_ENET_MAC1_TX_ALMOST_FULL_TX_ALMOST_FULL)

#define HW_ENET_MAC1_TX_IPG_LENGTH	(0x000041a8)

#define BP_ENET_MAC1_TX_IPG_LENGTH_RSRVD0	5
#define BM_ENET_MAC1_TX_IPG_LENGTH_RSRVD0	0xFFFFFFE0
#define BF_ENET_MAC1_TX_IPG_LENGTH_RSRVD0(v) \
		(((v) << 5) & BM_ENET_MAC1_TX_IPG_LENGTH_RSRVD0)
#define BP_ENET_MAC1_TX_IPG_LENGTH_TX_IPG_LENGTH	0
#define BM_ENET_MAC1_TX_IPG_LENGTH_TX_IPG_LENGTH	0x0000001F
#define BF_ENET_MAC1_TX_IPG_LENGTH_TX_IPG_LENGTH(v)  \
		(((v) << 0) & BM_ENET_MAC1_TX_IPG_LENGTH_TX_IPG_LENGTH)

#define HW_ENET_MAC1_TRUNC_FL	(0x000041ac)

#define BP_ENET_MAC1_TRUNC_FL_RSRVD0	14
#define BM_ENET_MAC1_TRUNC_FL_RSRVD0	0xFFFFC000
#define BF_ENET_MAC1_TRUNC_FL_RSRVD0(v) \
		(((v) << 14) & BM_ENET_MAC1_TRUNC_FL_RSRVD0)
#define BP_ENET_MAC1_TRUNC_FL_TRUNC_FL	0
#define BM_ENET_MAC1_TRUNC_FL_TRUNC_FL	0x00003FFF
#define BF_ENET_MAC1_TRUNC_FL_TRUNC_FL(v)  \
		(((v) << 0) & BM_ENET_MAC1_TRUNC_FL_TRUNC_FL)

#define HW_ENET_MAC1_IPACCTXCONF	(0x000041bc)

#define BP_ENET_MAC1_IPACCTXCONF_RSRVD0	5
#define BM_ENET_MAC1_IPACCTXCONF_RSRVD0	0xFFFFFFE0
#define BF_ENET_MAC1_IPACCTXCONF_RSRVD0(v) \
		(((v) << 5) & BM_ENET_MAC1_IPACCTXCONF_RSRVD0)
#define BM_ENET_MAC1_IPACCTXCONF_TX_PROTCHK_INS	0x00000010
#define BM_ENET_MAC1_IPACCTXCONF_TX_IPCHK_INS	0x00000008
#define BP_ENET_MAC1_IPACCTXCONF_RSRVD1	1
#define BM_ENET_MAC1_IPACCTXCONF_RSRVD1	0x00000006
#define BF_ENET_MAC1_IPACCTXCONF_RSRVD1(v)  \
		(((v) << 1) & BM_ENET_MAC1_IPACCTXCONF_RSRVD1)
#define BM_ENET_MAC1_IPACCTXCONF_SHIFT16	0x00000001

#define HW_ENET_MAC1_IPACCRXCONF	(0x000041c0)

#define BP_ENET_MAC1_IPACCRXCONF_RSRVD0	8
#define BM_ENET_MAC1_IPACCRXCONF_RSRVD0	0xFFFFFF00
#define BF_ENET_MAC1_IPACCRXCONF_RSRVD0(v) \
		(((v) << 8) & BM_ENET_MAC1_IPACCRXCONF_RSRVD0)
#define BM_ENET_MAC1_IPACCRXCONF_SHIFT16	0x00000080
#define BM_ENET_MAC1_IPACCRXCONF_RX_LINEERR_DISC	0x00000040
#define BP_ENET_MAC1_IPACCRXCONF_RSRVD1	3
#define BM_ENET_MAC1_IPACCRXCONF_RSRVD1	0x00000038
#define BF_ENET_MAC1_IPACCRXCONF_RSRVD1(v)  \
		(((v) << 3) & BM_ENET_MAC1_IPACCRXCONF_RSRVD1)
#define BM_ENET_MAC1_IPACCRXCONF_RX_PROTERR_DISCARD	0x00000004
#define BM_ENET_MAC1_IPACCRXCONF_RX_IPERR_DISCARD	0x00000002
#define BM_ENET_MAC1_IPACCRXCONF_RX_IP_PAD_REMOVE	0x00000001

#define HW_ENET_MAC1_RMON_T_DROP	(0x000041fc)

#define BP_ENET_MAC1_RMON_T_DROP_RMON_T_DROP	0
#define BM_ENET_MAC1_RMON_T_DROP_RMON_T_DROP	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_T_DROP_RMON_T_DROP(v)	(v)

#define HW_ENET_MAC1_RMON_T_PACKETS	(0x00004200)

#define BP_ENET_MAC1_RMON_T_PACKETS_RMON_T_PACKETS	0
#define BM_ENET_MAC1_RMON_T_PACKETS_RMON_T_PACKETS	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_T_PACKETS_RMON_T_PACKETS(v)	(v)

#define HW_ENET_MAC1_RMON_T_BC_PKT	(0x00004204)

#define BP_ENET_MAC1_RMON_T_BC_PKT_RMON_T_BC_PKT	0
#define BM_ENET_MAC1_RMON_T_BC_PKT_RMON_T_BC_PKT	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_T_BC_PKT_RMON_T_BC_PKT(v)	(v)

#define HW_ENET_MAC1_RMON_T_MC_PKT	(0x00004208)

#define BP_ENET_MAC1_RMON_T_MC_PKT_RMON_T_MC_PKT	0
#define BM_ENET_MAC1_RMON_T_MC_PKT_RMON_T_MC_PKT	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_T_MC_PKT_RMON_T_MC_PKT(v)	(v)

#define HW_ENET_MAC1_RMON_T_CRC_ALIGN	(0x0000420c)

#define BP_ENET_MAC1_RMON_T_CRC_ALIGN_RMON_T_CRC_ALIGN	0
#define BM_ENET_MAC1_RMON_T_CRC_ALIGN_RMON_T_CRC_ALIGN	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_T_CRC_ALIGN_RMON_T_CRC_ALIGN(v)	(v)

#define HW_ENET_MAC1_RMON_T_UNDERSIZE	(0x00004210)

#define BP_ENET_MAC1_RMON_T_UNDERSIZE_RMON_T_UNDERSIZE	0
#define BM_ENET_MAC1_RMON_T_UNDERSIZE_RMON_T_UNDERSIZE	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_T_UNDERSIZE_RMON_T_UNDERSIZE(v)	(v)

#define HW_ENET_MAC1_RMON_T_OVERSIZE	(0x00004214)

#define BP_ENET_MAC1_RMON_T_OVERSIZE_RMON_T_OVERSIZE	0
#define BM_ENET_MAC1_RMON_T_OVERSIZE_RMON_T_OVERSIZE	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_T_OVERSIZE_RMON_T_OVERSIZE(v)	(v)

#define HW_ENET_MAC1_RMON_T_FRAG	(0x00004218)

#define BP_ENET_MAC1_RMON_T_FRAG_RMON_T_FRAG	0
#define BM_ENET_MAC1_RMON_T_FRAG_RMON_T_FRAG	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_T_FRAG_RMON_T_FRAG(v)	(v)

#define HW_ENET_MAC1_RMON_T_JAB	(0x0000421c)

#define BP_ENET_MAC1_RMON_T_JAB_RMON_T_JAB	0
#define BM_ENET_MAC1_RMON_T_JAB_RMON_T_JAB	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_T_JAB_RMON_T_JAB(v)	(v)

#define HW_ENET_MAC1_RMON_T_COL	(0x00004220)

#define BP_ENET_MAC1_RMON_T_COL_RMON_T_COL	0
#define BM_ENET_MAC1_RMON_T_COL_RMON_T_COL	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_T_COL_RMON_T_COL(v)	(v)

#define HW_ENET_MAC1_RMON_T_P64	(0x00004224)

#define BP_ENET_MAC1_RMON_T_P64_RMON_T_P64	0
#define BM_ENET_MAC1_RMON_T_P64_RMON_T_P64	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_T_P64_RMON_T_P64(v)	(v)

#define HW_ENET_MAC1_RMON_T_P65TO127N	(0x00004228)

#define BP_ENET_MAC1_RMON_T_P65TO127N_RMON_T_P65TO127N	0
#define BM_ENET_MAC1_RMON_T_P65TO127N_RMON_T_P65TO127N	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_T_P65TO127N_RMON_T_P65TO127N(v)	(v)

#define HW_ENET_MAC1_RMON_T_P128TO255N	(0x0000422c)

#define BP_ENET_MAC1_RMON_T_P128TO255N_RMON_T_P128TO255N	0
#define BM_ENET_MAC1_RMON_T_P128TO255N_RMON_T_P128TO255N	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_T_P128TO255N_RMON_T_P128TO255N(v)	(v)

#define HW_ENET_MAC1_RMON_T_P256TO511	(0x00004230)

#define BP_ENET_MAC1_RMON_T_P256TO511_RMON_T_P256TO511	0
#define BM_ENET_MAC1_RMON_T_P256TO511_RMON_T_P256TO511	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_T_P256TO511_RMON_T_P256TO511(v)	(v)

#define HW_ENET_MAC1_RMON_T_P512TO1023	(0x00004234)

#define BP_ENET_MAC1_RMON_T_P512TO1023_RMON_T_P512TO1023	0
#define BM_ENET_MAC1_RMON_T_P512TO1023_RMON_T_P512TO1023	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_T_P512TO1023_RMON_T_P512TO1023(v)	(v)

#define HW_ENET_MAC1_RMON_T_P1024TO2047	(0x00004238)

#define BP_ENET_MAC1_RMON_T_P1024TO2047_RMON_T_P1024TO2047	0
#define BM_ENET_MAC1_RMON_T_P1024TO2047_RMON_T_P1024TO2047	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_T_P1024TO2047_RMON_T_P1024TO2047(v)	(v)

#define HW_ENET_MAC1_RMON_T_P_GTE2048	(0x0000423c)

#define BP_ENET_MAC1_RMON_T_P_GTE2048_RMON_T_P_GTE2048	0
#define BM_ENET_MAC1_RMON_T_P_GTE2048_RMON_T_P_GTE2048	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_T_P_GTE2048_RMON_T_P_GTE2048(v)	(v)

#define HW_ENET_MAC1_RMON_T_OCTETS	(0x00004240)

#define BP_ENET_MAC1_RMON_T_OCTETS_RMON_T_OCTETS	0
#define BM_ENET_MAC1_RMON_T_OCTETS_RMON_T_OCTETS	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_T_OCTETS_RMON_T_OCTETS(v)	(v)

#define HW_ENET_MAC1_IEEE_T_DROP	(0x00004244)

#define BP_ENET_MAC1_IEEE_T_DROP_IEEE_T_DROP	0
#define BM_ENET_MAC1_IEEE_T_DROP_IEEE_T_DROP	0xFFFFFFFF
#define BF_ENET_MAC1_IEEE_T_DROP_IEEE_T_DROP(v)	(v)

#define HW_ENET_MAC1_IEEE_T_FRAME_OK	(0x00004248)

#define BP_ENET_MAC1_IEEE_T_FRAME_OK_IEEE_T_FRAME_OK	0
#define BM_ENET_MAC1_IEEE_T_FRAME_OK_IEEE_T_FRAME_OK	0xFFFFFFFF
#define BF_ENET_MAC1_IEEE_T_FRAME_OK_IEEE_T_FRAME_OK(v)	(v)

#define HW_ENET_MAC1_IEEE_T_1COL	(0x0000424c)

#define BP_ENET_MAC1_IEEE_T_1COL_IEEE_T_1COL	0
#define BM_ENET_MAC1_IEEE_T_1COL_IEEE_T_1COL	0xFFFFFFFF
#define BF_ENET_MAC1_IEEE_T_1COL_IEEE_T_1COL(v)	(v)

#define HW_ENET_MAC1_IEEE_T_MCOL	(0x00004250)

#define BP_ENET_MAC1_IEEE_T_MCOL_IEEE_T_MCOL	0
#define BM_ENET_MAC1_IEEE_T_MCOL_IEEE_T_MCOL	0xFFFFFFFF
#define BF_ENET_MAC1_IEEE_T_MCOL_IEEE_T_MCOL(v)	(v)

#define HW_ENET_MAC1_IEEE_T_DEF	(0x00004254)

#define BP_ENET_MAC1_IEEE_T_DEF_IEEE_T_DEF	0
#define BM_ENET_MAC1_IEEE_T_DEF_IEEE_T_DEF	0xFFFFFFFF
#define BF_ENET_MAC1_IEEE_T_DEF_IEEE_T_DEF(v)	(v)

#define HW_ENET_MAC1_IEEE_T_LCOL	(0x00004258)

#define BP_ENET_MAC1_IEEE_T_LCOL_IEEE_T_LCOL	0
#define BM_ENET_MAC1_IEEE_T_LCOL_IEEE_T_LCOL	0xFFFFFFFF
#define BF_ENET_MAC1_IEEE_T_LCOL_IEEE_T_LCOL(v)	(v)

#define HW_ENET_MAC1_IEEE_T_EXCOL	(0x0000425c)

#define BP_ENET_MAC1_IEEE_T_EXCOL_IEEE_T_EXCOL	0
#define BM_ENET_MAC1_IEEE_T_EXCOL_IEEE_T_EXCOL	0xFFFFFFFF
#define BF_ENET_MAC1_IEEE_T_EXCOL_IEEE_T_EXCOL(v)	(v)

#define HW_ENET_MAC1_IEEE_T_MACERR	(0x00004260)

#define BP_ENET_MAC1_IEEE_T_MACERR_IEEE_T_MACERR	0
#define BM_ENET_MAC1_IEEE_T_MACERR_IEEE_T_MACERR	0xFFFFFFFF
#define BF_ENET_MAC1_IEEE_T_MACERR_IEEE_T_MACERR(v)	(v)

#define HW_ENET_MAC1_IEEE_T_CSERR	(0x00004264)

#define BP_ENET_MAC1_IEEE_T_CSERR_IEEE_T_CSERR	0
#define BM_ENET_MAC1_IEEE_T_CSERR_IEEE_T_CSERR	0xFFFFFFFF
#define BF_ENET_MAC1_IEEE_T_CSERR_IEEE_T_CSERR(v)	(v)

#define HW_ENET_MAC1_IEEE_T_SQE	(0x00004268)

#define BP_ENET_MAC1_IEEE_T_SQE_IEEE_T_SQE	0
#define BM_ENET_MAC1_IEEE_T_SQE_IEEE_T_SQE	0xFFFFFFFF
#define BF_ENET_MAC1_IEEE_T_SQE_IEEE_T_SQE(v)	(v)

#define HW_ENET_MAC1_IEEE_T_FDXFC	(0x0000426c)

#define BP_ENET_MAC1_IEEE_T_FDXFC_IEEE_T_FDXFC	0
#define BM_ENET_MAC1_IEEE_T_FDXFC_IEEE_T_FDXFC	0xFFFFFFFF
#define BF_ENET_MAC1_IEEE_T_FDXFC_IEEE_T_FDXFC(v)	(v)

#define HW_ENET_MAC1_IEEE_T_OCTETS_OK	(0x00004270)

#define BP_ENET_MAC1_IEEE_T_OCTETS_OK_IEEE_T_OCTETS_OK	0
#define BM_ENET_MAC1_IEEE_T_OCTETS_OK_IEEE_T_OCTETS_OK	0xFFFFFFFF
#define BF_ENET_MAC1_IEEE_T_OCTETS_OK_IEEE_T_OCTETS_OK(v)	(v)

#define HW_ENET_MAC1_RMON_R_PACKETS	(0x00004280)

#define BP_ENET_MAC1_RMON_R_PACKETS_RMON_R_PACKETS	0
#define BM_ENET_MAC1_RMON_R_PACKETS_RMON_R_PACKETS	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_R_PACKETS_RMON_R_PACKETS(v)	(v)

#define HW_ENET_MAC1_RMON_R_BC_PKT	(0x00004284)

#define BP_ENET_MAC1_RMON_R_BC_PKT_RMON_R_BC_PKT	0
#define BM_ENET_MAC1_RMON_R_BC_PKT_RMON_R_BC_PKT	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_R_BC_PKT_RMON_R_BC_PKT(v)	(v)

#define HW_ENET_MAC1_RMON_R_MC_PKT	(0x00004288)

#define BP_ENET_MAC1_RMON_R_MC_PKT_RMON_R_MC_PKT	0
#define BM_ENET_MAC1_RMON_R_MC_PKT_RMON_R_MC_PKT	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_R_MC_PKT_RMON_R_MC_PKT(v)	(v)

#define HW_ENET_MAC1_RMON_R_CRC_ALIGN	(0x0000428c)

#define BP_ENET_MAC1_RMON_R_CRC_ALIGN_RMON_R_CRC_ALIGN	0
#define BM_ENET_MAC1_RMON_R_CRC_ALIGN_RMON_R_CRC_ALIGN	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_R_CRC_ALIGN_RMON_R_CRC_ALIGN(v)	(v)

#define HW_ENET_MAC1_RMON_R_UNDERSIZE	(0x00004290)

#define BP_ENET_MAC1_RMON_R_UNDERSIZE_RMON_R_UNDERSIZE	0
#define BM_ENET_MAC1_RMON_R_UNDERSIZE_RMON_R_UNDERSIZE	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_R_UNDERSIZE_RMON_R_UNDERSIZE(v)	(v)

#define HW_ENET_MAC1_RMON_R_OVERSIZE	(0x00004294)

#define BP_ENET_MAC1_RMON_R_OVERSIZE_RMON_R_OVERSIZE	0
#define BM_ENET_MAC1_RMON_R_OVERSIZE_RMON_R_OVERSIZE	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_R_OVERSIZE_RMON_R_OVERSIZE(v)	(v)

#define HW_ENET_MAC1_RMON_R_FRAG	(0x00004298)

#define BP_ENET_MAC1_RMON_R_FRAG_RMON_R_FRAG	0
#define BM_ENET_MAC1_RMON_R_FRAG_RMON_R_FRAG	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_R_FRAG_RMON_R_FRAG(v)	(v)

#define HW_ENET_MAC1_RMON_R_JAB	(0x0000429c)

#define BP_ENET_MAC1_RMON_R_JAB_RMON_R_JAB	0
#define BM_ENET_MAC1_RMON_R_JAB_RMON_R_JAB	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_R_JAB_RMON_R_JAB(v)	(v)

#define HW_ENET_MAC1_RMON_R_P64	(0x000042a4)

#define BP_ENET_MAC1_RMON_R_P64_RMON_R_P64	0
#define BM_ENET_MAC1_RMON_R_P64_RMON_R_P64	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_R_P64_RMON_R_P64(v)	(v)

#define HW_ENET_MAC1_RMON_R_P65TO127	(0x000042a8)

#define BP_ENET_MAC1_RMON_R_P65TO127_RMON_R_P65TO127	0
#define BM_ENET_MAC1_RMON_R_P65TO127_RMON_R_P65TO127	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_R_P65TO127_RMON_R_P65TO127(v)	(v)

#define HW_ENET_MAC1_RMON_R_P128TO255	(0x000042ac)

#define BP_ENET_MAC1_RMON_R_P128TO255_RMON_R_P128TO255	0
#define BM_ENET_MAC1_RMON_R_P128TO255_RMON_R_P128TO255	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_R_P128TO255_RMON_R_P128TO255(v)	(v)

#define HW_ENET_MAC1_RMON_R_P256TO511	(0x000042b0)

#define BP_ENET_MAC1_RMON_R_P256TO511_RMON_R_P256TO511	0
#define BM_ENET_MAC1_RMON_R_P256TO511_RMON_R_P256TO511	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_R_P256TO511_RMON_R_P256TO511(v)	(v)

#define HW_ENET_MAC1_RMON_R_P512TO1023	(0x000042b4)

#define BP_ENET_MAC1_RMON_R_P512TO1023_RMON_R_P512TO1023	0
#define BM_ENET_MAC1_RMON_R_P512TO1023_RMON_R_P512TO1023	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_R_P512TO1023_RMON_R_P512TO1023(v)	(v)

#define HW_ENET_MAC1_RMON_R_P1024TO2047	(0x000042b8)

#define BP_ENET_MAC1_RMON_R_P1024TO2047_RMON_R_P1024TO2047	0
#define BM_ENET_MAC1_RMON_R_P1024TO2047_RMON_R_P1024TO2047	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_R_P1024TO2047_RMON_R_P1024TO2047(v)	(v)

#define HW_ENET_MAC1_RMON_R_P_GTE2048	(0x000042bc)

#define BP_ENET_MAC1_RMON_R_P_GTE2048_RMON_R_P_GTE2048	0
#define BM_ENET_MAC1_RMON_R_P_GTE2048_RMON_R_P_GTE2048	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_R_P_GTE2048_RMON_R_P_GTE2048(v)	(v)

#define HW_ENET_MAC1_RMON_R_OCTETS	(0x000042c0)

#define BP_ENET_MAC1_RMON_R_OCTETS_RMON_R_OCTETS	0
#define BM_ENET_MAC1_RMON_R_OCTETS_RMON_R_OCTETS	0xFFFFFFFF
#define BF_ENET_MAC1_RMON_R_OCTETS_RMON_R_OCTETS(v)	(v)

#define HW_ENET_MAC1_IEEE_R_DROP	(0x000042c4)

#define BP_ENET_MAC1_IEEE_R_DROP_IEEE_R_DROP	0
#define BM_ENET_MAC1_IEEE_R_DROP_IEEE_R_DROP	0xFFFFFFFF
#define BF_ENET_MAC1_IEEE_R_DROP_IEEE_R_DROP(v)	(v)

#define HW_ENET_MAC1_IEEE_R_FRAME_OK	(0x000042c8)

#define BP_ENET_MAC1_IEEE_R_FRAME_OK_IEEE_R_FRAME_OK	0
#define BM_ENET_MAC1_IEEE_R_FRAME_OK_IEEE_R_FRAME_OK	0xFFFFFFFF
#define BF_ENET_MAC1_IEEE_R_FRAME_OK_IEEE_R_FRAME_OK(v)	(v)

#define HW_ENET_MAC1_IEEE_R_CRC	(0x000042cc)

#define BP_ENET_MAC1_IEEE_R_CRC_IEEE_R_CRC	0
#define BM_ENET_MAC1_IEEE_R_CRC_IEEE_R_CRC	0xFFFFFFFF
#define BF_ENET_MAC1_IEEE_R_CRC_IEEE_R_CRC(v)	(v)

#define HW_ENET_MAC1_IEEE_R_ALIGN	(0x000042d0)

#define BP_ENET_MAC1_IEEE_R_ALIGN_IEEE_R_ALIGN	0
#define BM_ENET_MAC1_IEEE_R_ALIGN_IEEE_R_ALIGN	0xFFFFFFFF
#define BF_ENET_MAC1_IEEE_R_ALIGN_IEEE_R_ALIGN(v)	(v)

#define HW_ENET_MAC1_IEEE_R_MACERR	(0x000042d4)

#define BP_ENET_MAC1_IEEE_R_MACERR_IEEE_R_MACERR	0
#define BM_ENET_MAC1_IEEE_R_MACERR_IEEE_R_MACERR	0xFFFFFFFF
#define BF_ENET_MAC1_IEEE_R_MACERR_IEEE_R_MACERR(v)	(v)

#define HW_ENET_MAC1_IEEE_R_FDXFC	(0x000042d8)

#define BP_ENET_MAC1_IEEE_R_FDXFC_IEEE_R_FDXFC	0
#define BM_ENET_MAC1_IEEE_R_FDXFC_IEEE_R_FDXFC	0xFFFFFFFF
#define BF_ENET_MAC1_IEEE_R_FDXFC_IEEE_R_FDXFC(v)	(v)

#define HW_ENET_MAC1_IEEE_R_OCTETS_OK	(0x000042dc)

#define BP_ENET_MAC1_IEEE_R_OCTETS_OK_IEEE_R_OCTETS_OK	0
#define BM_ENET_MAC1_IEEE_R_OCTETS_OK_IEEE_R_OCTETS_OK	0xFFFFFFFF
#define BF_ENET_MAC1_IEEE_R_OCTETS_OK_IEEE_R_OCTETS_OK(v)	(v)

#define HW_ENET_MAC1_ATIME_CTRL	(0x000043fc)

#define BP_ENET_MAC1_ATIME_CTRL_RSRVD0	14
#define BM_ENET_MAC1_ATIME_CTRL_RSRVD0	0xFFFFC000
#define BF_ENET_MAC1_ATIME_CTRL_RSRVD0(v) \
		(((v) << 14) & BM_ENET_MAC1_ATIME_CTRL_RSRVD0)
#define BM_ENET_MAC1_ATIME_CTRL_FRC_SLAVE	0x00002000
#define BM_ENET_MAC1_ATIME_CTRL_RSRVD1	0x00001000
#define BM_ENET_MAC1_ATIME_CTRL_CAPTURE	0x00000800
#define BM_ENET_MAC1_ATIME_CTRL_RSRVD2	0x00000400
#define BM_ENET_MAC1_ATIME_CTRL_RESTART	0x00000200
#define BM_ENET_MAC1_ATIME_CTRL_RSRVD3	0x00000100
#define BM_ENET_MAC1_ATIME_CTRL_PIN_PERIOD_ENA	0x00000080
#define BM_ENET_MAC1_ATIME_CTRL_RSRVD4	0x00000040
#define BM_ENET_MAC1_ATIME_CTRL_EVT_PERIOD_RST	0x00000020
#define BM_ENET_MAC1_ATIME_CTRL_EVT_PERIOD_ENA	0x00000010
#define BM_ENET_MAC1_ATIME_CTRL_EVT_OFFSET_RST	0x00000008
#define BM_ENET_MAC1_ATIME_CTRL_EVT_OFFSET_ENA	0x00000004
#define BM_ENET_MAC1_ATIME_CTRL_ONE_SHOT	0x00000002
#define BM_ENET_MAC1_ATIME_CTRL_ENABLE	0x00000001

#define HW_ENET_MAC1_ATIME	(0x00004400)

#define BP_ENET_MAC1_ATIME_ATIME	0
#define BM_ENET_MAC1_ATIME_ATIME	0xFFFFFFFF
#define BF_ENET_MAC1_ATIME_ATIME(v)	(v)

#define HW_ENET_MAC1_ATIME_EVT_OFFSET	(0x00004404)

#define BP_ENET_MAC1_ATIME_EVT_OFFSET_ATIME_EVT_OFFSET	0
#define BM_ENET_MAC1_ATIME_EVT_OFFSET_ATIME_EVT_OFFSET	0xFFFFFFFF
#define BF_ENET_MAC1_ATIME_EVT_OFFSET_ATIME_EVT_OFFSET(v)	(v)

#define HW_ENET_MAC1_ATIME_EVT_PERIOD	(0x00004408)

#define BP_ENET_MAC1_ATIME_EVT_PERIOD_ATIME_EVT_PERIOD	0
#define BM_ENET_MAC1_ATIME_EVT_PERIOD_ATIME_EVT_PERIOD	0xFFFFFFFF
#define BF_ENET_MAC1_ATIME_EVT_PERIOD_ATIME_EVT_PERIOD(v)	(v)

#define HW_ENET_MAC1_ATIME_CORR	(0x0000440c)

#define BM_ENET_MAC1_ATIME_CORR_RSRVD0	0x80000000
#define BP_ENET_MAC1_ATIME_CORR_ATIME_CORR	0
#define BM_ENET_MAC1_ATIME_CORR_ATIME_CORR	0x7FFFFFFF
#define BF_ENET_MAC1_ATIME_CORR_ATIME_CORR(v)  \
		(((v) << 0) & BM_ENET_MAC1_ATIME_CORR_ATIME_CORR)

#define HW_ENET_MAC1_ATIME_INC	(0x00004410)

#define BP_ENET_MAC1_ATIME_INC_RSRVD0	15
#define BM_ENET_MAC1_ATIME_INC_RSRVD0	0xFFFF8000
#define BF_ENET_MAC1_ATIME_INC_RSRVD0(v) \
		(((v) << 15) & BM_ENET_MAC1_ATIME_INC_RSRVD0)
#define BP_ENET_MAC1_ATIME_INC_ATIME_INC_CORR	8
#define BM_ENET_MAC1_ATIME_INC_ATIME_INC_CORR	0x00007F00
#define BF_ENET_MAC1_ATIME_INC_ATIME_INC_CORR(v)  \
		(((v) << 8) & BM_ENET_MAC1_ATIME_INC_ATIME_INC_CORR)
#define BM_ENET_MAC1_ATIME_INC_RSRVD1	0x00000080
#define BP_ENET_MAC1_ATIME_INC_ATIME_INC	0
#define BM_ENET_MAC1_ATIME_INC_ATIME_INC	0x0000007F
#define BF_ENET_MAC1_ATIME_INC_ATIME_INC(v)  \
		(((v) << 0) & BM_ENET_MAC1_ATIME_INC_ATIME_INC)

#define HW_ENET_MAC1_TS_TIMESTAMP	(0x00004414)

#define BP_ENET_MAC1_TS_TIMESTAMP_TS_TIMESTAMP	0
#define BM_ENET_MAC1_TS_TIMESTAMP_TS_TIMESTAMP	0xFFFFFFFF
#define BF_ENET_MAC1_TS_TIMESTAMP_TS_TIMESTAMP(v)	(v)

#define HW_ENET_MAC1_SMAC_0_0	(0x000044fc)

#define BP_ENET_MAC1_SMAC_0_0_SMAC_0_0	0
#define BM_ENET_MAC1_SMAC_0_0_SMAC_0_0	0xFFFFFFFF
#define BF_ENET_MAC1_SMAC_0_0_SMAC_0_0(v)	(v)

#define HW_ENET_MAC1_SMAC_0_1	(0x00004500)

#define BP_ENET_MAC1_SMAC_0_1_SMAC_0_1	0
#define BM_ENET_MAC1_SMAC_0_1_SMAC_0_1	0xFFFFFFFF
#define BF_ENET_MAC1_SMAC_0_1_SMAC_0_1(v)	(v)

#define HW_ENET_MAC1_SMAC_1_0	(0x00004504)

#define BP_ENET_MAC1_SMAC_1_0_SMAC_1_0	0
#define BM_ENET_MAC1_SMAC_1_0_SMAC_1_0	0xFFFFFFFF
#define BF_ENET_MAC1_SMAC_1_0_SMAC_1_0(v)	(v)

#define HW_ENET_MAC1_SMAC_1_1	(0x00004508)

#define BP_ENET_MAC1_SMAC_1_1_SMAC_1_1	0
#define BM_ENET_MAC1_SMAC_1_1_SMAC_1_1	0xFFFFFFFF
#define BF_ENET_MAC1_SMAC_1_1_SMAC_1_1(v)	(v)

#define HW_ENET_MAC1_SMAC_2_0	(0x0000450c)

#define BP_ENET_MAC1_SMAC_2_0_SMAC_2_0	0
#define BM_ENET_MAC1_SMAC_2_0_SMAC_2_0	0xFFFFFFFF
#define BF_ENET_MAC1_SMAC_2_0_SMAC_2_0(v)	(v)

#define HW_ENET_MAC1_SMAC_2_1	(0x00004510)

#define BP_ENET_MAC1_SMAC_2_1_SMAC_2_1	0
#define BM_ENET_MAC1_SMAC_2_1_SMAC_2_1	0xFFFFFFFF
#define BF_ENET_MAC1_SMAC_2_1_SMAC_2_1(v)	(v)

#define HW_ENET_MAC1_SMAC_3_0	(0x00004514)

#define BP_ENET_MAC1_SMAC_3_0_SMAC_3_0	0
#define BM_ENET_MAC1_SMAC_3_0_SMAC_3_0	0xFFFFFFFF
#define BF_ENET_MAC1_SMAC_3_0_SMAC_3_0(v)	(v)

#define HW_ENET_MAC1_SMAC_3_1	(0x00004518)

#define BP_ENET_MAC1_SMAC_3_1_SMAC_3_1	0
#define BM_ENET_MAC1_SMAC_3_1_SMAC_3_1	0xFFFFFFFF
#define BF_ENET_MAC1_SMAC_3_1_SMAC_3_1(v)	(v)

#define HW_ENET_MAC1_COMP_REG_0	(0x000045fc)

#define BP_ENET_MAC1_COMP_REG_0_COMP_REG_0	0
#define BM_ENET_MAC1_COMP_REG_0_COMP_REG_0	0xFFFFFFFF
#define BF_ENET_MAC1_COMP_REG_0_COMP_REG_0(v)	(v)

#define HW_ENET_MAC1_COMP_REG_1	(0x00004600)

#define BP_ENET_MAC1_COMP_REG_1_COMP_REG_1	0
#define BM_ENET_MAC1_COMP_REG_1_COMP_REG_1	0xFFFFFFFF
#define BF_ENET_MAC1_COMP_REG_1_COMP_REG_1(v)	(v)

#define HW_ENET_MAC1_COMP_REG_2	(0x00004604)

#define BP_ENET_MAC1_COMP_REG_2_COMP_REG_2	0
#define BM_ENET_MAC1_COMP_REG_2_COMP_REG_2	0xFFFFFFFF
#define BF_ENET_MAC1_COMP_REG_2_COMP_REG_2(v)	(v)

#define HW_ENET_MAC1_COMP_REG_3	(0x00004608)

#define BP_ENET_MAC1_COMP_REG_3_COMP_REG_3	0
#define BM_ENET_MAC1_COMP_REG_3_COMP_REG_3	0xFFFFFFFF
#define BF_ENET_MAC1_COMP_REG_3_COMP_REG_3(v)	(v)

#define HW_ENET_MAC1_CAPT_REG_0	(0x0000463c)

#define BP_ENET_MAC1_CAPT_REG_0_CAPT_REG_0	0
#define BM_ENET_MAC1_CAPT_REG_0_CAPT_REG_0	0xFFFFFFFF
#define BF_ENET_MAC1_CAPT_REG_0_CAPT_REG_0(v)	(v)

#define HW_ENET_MAC1_CAPT_REG_1	(0x00004640)

#define BP_ENET_MAC1_CAPT_REG_1_CAPT_REG_1	0
#define BM_ENET_MAC1_CAPT_REG_1_CAPT_REG_1	0xFFFFFFFF
#define BF_ENET_MAC1_CAPT_REG_1_CAPT_REG_1(v)	(v)

#define HW_ENET_MAC1_CAPT_REG_2	(0x00004644)

#define BP_ENET_MAC1_CAPT_REG_2_CAPT_REG_2	0
#define BM_ENET_MAC1_CAPT_REG_2_CAPT_REG_2	0xFFFFFFFF
#define BF_ENET_MAC1_CAPT_REG_2_CAPT_REG_2(v)	(v)

#define HW_ENET_MAC1_CAPT_REG_3	(0x00004648)

#define BP_ENET_MAC1_CAPT_REG_3_CAPT_REG_3	0
#define BM_ENET_MAC1_CAPT_REG_3_CAPT_REG_3	0xFFFFFFFF
#define BF_ENET_MAC1_CAPT_REG_3_CAPT_REG_3(v)	(v)

#define HW_ENET_MAC1_CCB_INT	(0x0000467c)

#define BP_ENET_MAC1_CCB_INT_RSRVD0	20
#define BM_ENET_MAC1_CCB_INT_RSRVD0	0xFFF00000
#define BF_ENET_MAC1_CCB_INT_RSRVD0(v) \
		(((v) << 20) & BM_ENET_MAC1_CCB_INT_RSRVD0)
#define BM_ENET_MAC1_CCB_INT_COMPARE3	0x00080000
#define BM_ENET_MAC1_CCB_INT_COMPARE2	0x00040000
#define BM_ENET_MAC1_CCB_INT_COMPARE1	0x00020000
#define BM_ENET_MAC1_CCB_INT_COMPARE0	0x00010000
#define BP_ENET_MAC1_CCB_INT_RSRVD1	4
#define BM_ENET_MAC1_CCB_INT_RSRVD1	0x0000FFF0
#define BF_ENET_MAC1_CCB_INT_RSRVD1(v)  \
		(((v) << 4) & BM_ENET_MAC1_CCB_INT_RSRVD1)
#define BM_ENET_MAC1_CCB_INT_CAPTURE3	0x00000008
#define BM_ENET_MAC1_CCB_INT_CAPTURE2	0x00000004
#define BM_ENET_MAC1_CCB_INT_CAPTURE1	0x00000002
#define BM_ENET_MAC1_CCB_INT_CAPTURE0	0x00000001

#define HW_ENET_MAC1_CCB_INT_MASK	(0x00004680)

#define BP_ENET_MAC1_CCB_INT_MASK_RSRVD0	20
#define BM_ENET_MAC1_CCB_INT_MASK_RSRVD0	0xFFF00000
#define BF_ENET_MAC1_CCB_INT_MASK_RSRVD0(v) \
		(((v) << 20) & BM_ENET_MAC1_CCB_INT_MASK_RSRVD0)
#define BM_ENET_MAC1_CCB_INT_MASK_COMPARE3	0x00080000
#define BM_ENET_MAC1_CCB_INT_MASK_COMPARE2	0x00040000
#define BM_ENET_MAC1_CCB_INT_MASK_COMPARE1	0x00020000
#define BM_ENET_MAC1_CCB_INT_MASK_COMPARE0	0x00010000
#define BP_ENET_MAC1_CCB_INT_MASK_RSRVD1	4
#define BM_ENET_MAC1_CCB_INT_MASK_RSRVD1	0x0000FFF0
#define BF_ENET_MAC1_CCB_INT_MASK_RSRVD1(v)  \
		(((v) << 4) & BM_ENET_MAC1_CCB_INT_MASK_RSRVD1)
#define BM_ENET_MAC1_CCB_INT_MASK_CAPTURE3	0x00000008
#define BM_ENET_MAC1_CCB_INT_MASK_CAPTURE2	0x00000004
#define BM_ENET_MAC1_CCB_INT_MASK_CAPTURE1	0x00000002
#define BM_ENET_MAC1_CCB_INT_MASK_CAPTURE0	0x00000001

#define HW_ENET_SWI_REVISION	(0x00007ffc)

#define BP_ENET_SWI_REVISION_CUSTOMER_REVISION	16
#define BM_ENET_SWI_REVISION_CUSTOMER_REVISION	0xFFFF0000
#define BF_ENET_SWI_REVISION_CUSTOMER_REVISION(v) \
		(((v) << 16) & BM_ENET_SWI_REVISION_CUSTOMER_REVISION)
#define BP_ENET_SWI_REVISION_CORE_REVISION	0
#define BM_ENET_SWI_REVISION_CORE_REVISION	0x0000FFFF
#define BF_ENET_SWI_REVISION_CORE_REVISION(v)  \
		(((v) << 0) & BM_ENET_SWI_REVISION_CORE_REVISION)

#define HW_ENET_SWI_SCRATCH	(0x00008000)

#define BP_ENET_SWI_SCRATCH_COMPARE0	0
#define BM_ENET_SWI_SCRATCH_COMPARE0	0xFFFFFFFF
#define BF_ENET_SWI_SCRATCH_COMPARE0(v)	(v)

#define HW_ENET_SWI_PORT_ENA	(0x00008004)

#define BP_ENET_SWI_PORT_ENA_RSRVD1	19
#define BM_ENET_SWI_PORT_ENA_RSRVD1	0xFFF80000
#define BF_ENET_SWI_PORT_ENA_RSRVD1(v) \
		(((v) << 19) & BM_ENET_SWI_PORT_ENA_RSRVD1)
#define BM_ENET_SWI_PORT_ENA_ENA_RECEIVE_2	0x00040000
#define BM_ENET_SWI_PORT_ENA_ENA_RECEIVE_1	0x00020000
#define BM_ENET_SWI_PORT_ENA_ENA_RECEIVE_0	0x00010000
#define BP_ENET_SWI_PORT_ENA_RSRVD0	3
#define BM_ENET_SWI_PORT_ENA_RSRVD0	0x0000FFF8
#define BF_ENET_SWI_PORT_ENA_RSRVD0(v)  \
		(((v) << 3) & BM_ENET_SWI_PORT_ENA_RSRVD0)
#define BM_ENET_SWI_PORT_ENA_ENA_TRANSMIT_2	0x00000004
#define BM_ENET_SWI_PORT_ENA_ENA_TRANSMIT_1	0x00000002
#define BM_ENET_SWI_PORT_ENA_ENA_TRANSMIT_0	0x00000001

#define HW_ENET_SWI_VLAN_VERIFY	(0x0000800c)

#define BP_ENET_SWI_VLAN_VERIFY_RSRVD1	19
#define BM_ENET_SWI_VLAN_VERIFY_RSRVD1	0xFFF80000
#define BF_ENET_SWI_VLAN_VERIFY_RSRVD1(v) \
		(((v) << 19) & BM_ENET_SWI_VLAN_VERIFY_RSRVD1)
#define BM_ENET_SWI_VLAN_VERIFY_DISCARD_P2	0x00040000
#define BM_ENET_SWI_VLAN_VERIFY_DISCARD_P1	0x00020000
#define BM_ENET_SWI_VLAN_VERIFY_DISCARD_P0	0x00010000
#define BP_ENET_SWI_VLAN_VERIFY_RSRVD0	3
#define BM_ENET_SWI_VLAN_VERIFY_RSRVD0	0x0000FFF8
#define BF_ENET_SWI_VLAN_VERIFY_RSRVD0(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_VERIFY_RSRVD0)
#define BM_ENET_SWI_VLAN_VERIFY_VLAN_VERIFY_2	0x00000004
#define BM_ENET_SWI_VLAN_VERIFY_VLAN_VERIFY_1	0x00000002
#define BM_ENET_SWI_VLAN_VERIFY_VLAN_VERIFY_0	0x00000001

#define HW_ENET_SWI_BCAST_DEFAULT_MASK	(0x00008010)

#define BP_ENET_SWI_BCAST_DEFAULT_MASK_RSRVD0	3
#define BM_ENET_SWI_BCAST_DEFAULT_MASK_RSRVD0	0xFFFFFFF8
#define BF_ENET_SWI_BCAST_DEFAULT_MASK_RSRVD0(v) \
		(((v) << 3) & BM_ENET_SWI_BCAST_DEFAULT_MASK_RSRVD0)
#define BM_ENET_SWI_BCAST_DEFAULT_MASK_BCAST_DEFAULT_MASK_2	0x00000004
#define BM_ENET_SWI_BCAST_DEFAULT_MASK_BCAST_DEFAULT_MASK_1	0x00000002
#define BM_ENET_SWI_BCAST_DEFAULT_MASK_BCAST_DEFAULT_MASK_0	0x00000001

#define HW_ENET_SWI_MCAST_DEFAULT_MASK	(0x00008014)

#define BP_ENET_SWI_MCAST_DEFAULT_MASK_RSRVD0	3
#define BM_ENET_SWI_MCAST_DEFAULT_MASK_RSRVD0	0xFFFFFFF8
#define BF_ENET_SWI_MCAST_DEFAULT_MASK_RSRVD0(v) \
		(((v) << 3) & BM_ENET_SWI_MCAST_DEFAULT_MASK_RSRVD0)
#define BM_ENET_SWI_MCAST_DEFAULT_MASK_MCAST_DEFAULT_MASK_2	0x00000004
#define BM_ENET_SWI_MCAST_DEFAULT_MASK_MCAST_DEFAULT_MASK_1	0x00000002
#define BM_ENET_SWI_MCAST_DEFAULT_MASK_MCAST_DEFAULT_MASK_0	0x00000001

#define HW_ENET_SWI_INPUT_LEARN_BLOCK	(0x00008018)

#define BP_ENET_SWI_INPUT_LEARN_BLOCK_RSRVD1	19
#define BM_ENET_SWI_INPUT_LEARN_BLOCK_RSRVD1	0xFFF80000
#define BF_ENET_SWI_INPUT_LEARN_BLOCK_RSRVD1(v) \
		(((v) << 19) & BM_ENET_SWI_INPUT_LEARN_BLOCK_RSRVD1)
#define BM_ENET_SWI_INPUT_LEARN_BLOCK_LEARNING_DIS_P2	0x00040000
#define BM_ENET_SWI_INPUT_LEARN_BLOCK_LEARNING_DI_P1	0x00020000
#define BM_ENET_SWI_INPUT_LEARN_BLOCK_LEARNING_DI_P0	0x00010000
#define BP_ENET_SWI_INPUT_LEARN_BLOCK_RSRVD0	3
#define BM_ENET_SWI_INPUT_LEARN_BLOCK_RSRVD0	0x0000FFF8
#define BF_ENET_SWI_INPUT_LEARN_BLOCK_RSRVD0(v)  \
		(((v) << 3) & BM_ENET_SWI_INPUT_LEARN_BLOCK_RSRVD0)
#define BM_ENET_SWI_INPUT_LEARN_BLOCK_BLOCKING_ENA_P2	0x00000004
#define BM_ENET_SWI_INPUT_LEARN_BLOCK_BLOCKING_ENA_P1	0x00000002
#define BM_ENET_SWI_INPUT_LEARN_BLOCK_BLOCKING_ENA_P0	0x00000001

#define HW_ENET_SWI_MGMT_CONFIG	(0x0000801c)

#define BP_ENET_SWI_MGMT_CONFIG_RSRVD2	19
#define BM_ENET_SWI_MGMT_CONFIG_RSRVD2	0xFFF80000
#define BF_ENET_SWI_MGMT_CONFIG_RSRVD2(v) \
		(((v) << 19) & BM_ENET_SWI_MGMT_CONFIG_RSRVD2)
#define BP_ENET_SWI_MGMT_CONFIG_PORTMASK	16
#define BM_ENET_SWI_MGMT_CONFIG_PORTMASK	0x00070000
#define BF_ENET_SWI_MGMT_CONFIG_PORTMASK(v)  \
		(((v) << 16) & BM_ENET_SWI_MGMT_CONFIG_PORTMASK)
#define BP_ENET_SWI_MGMT_CONFIG_PRIORITY	13
#define BM_ENET_SWI_MGMT_CONFIG_PRIORITY	0x0000E000
#define BF_ENET_SWI_MGMT_CONFIG_PRIORITY(v)  \
		(((v) << 13) & BM_ENET_SWI_MGMT_CONFIG_PRIORITY)
#define BP_ENET_SWI_MGMT_CONFIG_RSRVD1	8
#define BM_ENET_SWI_MGMT_CONFIG_RSRVD1	0x00001F00
#define BF_ENET_SWI_MGMT_CONFIG_RSRVD1(v)  \
		(((v) << 8) & BM_ENET_SWI_MGMT_CONFIG_RSRVD1)
#define BM_ENET_SWI_MGMT_CONFIG_DISCARD	0x00000080
#define BM_ENET_SWI_MGMT_CONFIG_ENABLE	0x00000040
#define BM_ENET_SWI_MGMT_CONFIG_MESSAGE_TRANSMITTED	0x00000020
#define BM_ENET_SWI_MGMT_CONFIG_RSRVD0	0x00000010
#define BP_ENET_SWI_MGMT_CONFIG_PORT	0
#define BM_ENET_SWI_MGMT_CONFIG_PORT	0x0000000F
#define BF_ENET_SWI_MGMT_CONFIG_PORT(v)  \
		(((v) << 0) & BM_ENET_SWI_MGMT_CONFIG_PORT)

#define HW_ENET_SWI_MODE_CONFIG	(0x00008020)

#define BM_ENET_SWI_MODE_CONFIG_STATSRESET	0x80000000
#define BP_ENET_SWI_MODE_CONFIG_RSRVD1	10
#define BM_ENET_SWI_MODE_CONFIG_RSRVD1	0x7FFFFC00
#define BF_ENET_SWI_MODE_CONFIG_RSRVD1(v)  \
		(((v) << 10) & BM_ENET_SWI_MODE_CONFIG_RSRVD1)
#define BM_ENET_SWI_MODE_CONFIG_P0BUF_CUT_THROUGH	0x00000200
#define BM_ENET_SWI_MODE_CONFIG_CRC_TRANSPARENT	0x00000100
#define BM_ENET_SWI_MODE_CONFIG_STOP_EN	0x00000080
#define BP_ENET_SWI_MODE_CONFIG_RSRVD0	2
#define BM_ENET_SWI_MODE_CONFIG_RSRVD0	0x0000007C
#define BF_ENET_SWI_MODE_CONFIG_RSRVD0(v)  \
		(((v) << 2) & BM_ENET_SWI_MODE_CONFIG_RSRVD0)
#define BM_ENET_SWI_MODE_CONFIG_SWITCH_EN	0x00000002
#define BM_ENET_SWI_MODE_CONFIG_SWITCH_RESET	0x00000001

#define HW_ENET_SWI_VLAN_IN_MODE	(0x00008024)

#define BP_ENET_SWI_VLAN_IN_MODE_RSRVD0	6
#define BM_ENET_SWI_VLAN_IN_MODE_RSRVD0	0xFFFFFFC0
#define BF_ENET_SWI_VLAN_IN_MODE_RSRVD0(v) \
		(((v) << 6) & BM_ENET_SWI_VLAN_IN_MODE_RSRVD0)
#define BP_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_2	4
#define BM_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_2	0x00000030
#define BF_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_2(v)  \
		(((v) << 4) & BM_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_2)
#define BP_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_1	2
#define BM_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_1	0x0000000C
#define BF_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_1(v)  \
		(((v) << 2) & BM_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_1)
#define BP_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_0	0
#define BM_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_0	0x00000003
#define BF_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_0(v)  \
		(((v) << 0) & BM_ENET_SWI_VLAN_IN_MODE_VLAN_IN_MODE_0)

#define HW_ENET_SWI_VLAN_OUT_MODE	(0x00008028)

#define BP_ENET_SWI_VLAN_OUT_MODE_RSRVD0	6
#define BM_ENET_SWI_VLAN_OUT_MODE_RSRVD0	0xFFFFFFC0
#define BF_ENET_SWI_VLAN_OUT_MODE_RSRVD0(v) \
		(((v) << 6) & BM_ENET_SWI_VLAN_OUT_MODE_RSRVD0)
#define BP_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_2	4
#define BM_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_2	0x00000030
#define BF_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_2(v)  \
		(((v) << 4) & BM_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_2)
#define BP_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_1	2
#define BM_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_1	0x0000000C
#define BF_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_1(v)  \
		(((v) << 2) & BM_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_1)
#define BP_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_0	0
#define BM_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_0	0x00000003
#define BF_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_0(v)  \
		(((v) << 0) & BM_ENET_SWI_VLAN_OUT_MODE_VLAN_OUT_MODE_0)

#define HW_ENET_SWI_VLAN_IN_MODE_ENA	(0x0000802c)

#define BP_ENET_SWI_VLAN_IN_MODE_ENA_RSRVD0	3
#define BM_ENET_SWI_VLAN_IN_MODE_ENA_RSRVD0	0xFFFFFFF8
#define BF_ENET_SWI_VLAN_IN_MODE_ENA_RSRVD0(v) \
		(((v) << 3) & BM_ENET_SWI_VLAN_IN_MODE_ENA_RSRVD0)
#define BM_ENET_SWI_VLAN_IN_MODE_ENA_VLAN_IN_MODE_ENA_2	0x00000004
#define BM_ENET_SWI_VLAN_IN_MODE_ENA_VLAN_IN_MODE_ENA_1	0x00000002
#define BM_ENET_SWI_VLAN_IN_MODE_ENA_VLAN_IN_MODE_ENA_0	0x00000001

#define HW_ENET_SWI_VLAN_TAG_ID	(0x00008030)

#define BP_ENET_SWI_VLAN_TAG_ID_RSRVD0	16
#define BM_ENET_SWI_VLAN_TAG_ID_RSRVD0	0xFFFF0000
#define BF_ENET_SWI_VLAN_TAG_ID_RSRVD0(v) \
		(((v) << 16) & BM_ENET_SWI_VLAN_TAG_ID_RSRVD0)
#define BP_ENET_SWI_VLAN_TAG_ID_SWI_VLAN_TAG_ID	0
#define BM_ENET_SWI_VLAN_TAG_ID_SWI_VLAN_TAG_ID	0x0000FFFF
#define BF_ENET_SWI_VLAN_TAG_ID_SWI_VLAN_TAG_ID(v)  \
		(((v) << 0) & BM_ENET_SWI_VLAN_TAG_ID_SWI_VLAN_TAG_ID)

#define HW_ENET_SWI_MIRROR_CONTROL	(0x0000803c)

#define BP_ENET_SWI_MIRROR_CONTROL_RSRVD0	11
#define BM_ENET_SWI_MIRROR_CONTROL_RSRVD0	0xFFFFF800
#define BF_ENET_SWI_MIRROR_CONTROL_RSRVD0(v) \
		(((v) << 11) & BM_ENET_SWI_MIRROR_CONTROL_RSRVD0)
#define BM_ENET_SWI_MIRROR_CONTROL_EG_DA_MATCH	0x00000400
#define BM_ENET_SWI_MIRROR_CONTROL_EG_SA_MATCH	0x00000200
#define BM_ENET_SWI_MIRROR_CONTROL_ING_DA_MATCH	0x00000100
#define BM_ENET_SWI_MIRROR_CONTROL_ING_SA_MATCH	0x00000080
#define BM_ENET_SWI_MIRROR_CONTROL_EG_MAP_ENABLE	0x00000040
#define BM_ENET_SWI_MIRROR_CONTROL_ING_MAP_ENABLE	0x00000020
#define BM_ENET_SWI_MIRROR_CONTROL_MIRROR_ENABLE	0x00000010
#define BP_ENET_SWI_MIRROR_CONTROL_PORTX	0
#define BM_ENET_SWI_MIRROR_CONTROL_PORTX	0x0000000F
#define BF_ENET_SWI_MIRROR_CONTROL_PORTX(v)  \
		(((v) << 0) & BM_ENET_SWI_MIRROR_CONTROL_PORTX)

#define HW_ENET_SWI_MIRROR_EG_MAP	(0x00008040)

#define BP_ENET_SWI_MIRROR_EG_MAP_RSRVD0	3
#define BM_ENET_SWI_MIRROR_EG_MAP_RSRVD0	0xFFFFFFF8
#define BF_ENET_SWI_MIRROR_EG_MAP_RSRVD0(v) \
		(((v) << 3) & BM_ENET_SWI_MIRROR_EG_MAP_RSRVD0)
#define BM_ENET_SWI_MIRROR_EG_MAP_MIRROR_EG_MAP_2	0x00000004
#define BM_ENET_SWI_MIRROR_EG_MAP_MIRROR_EG_MAP_1	0x00000002
#define BM_ENET_SWI_MIRROR_EG_MAP_MIRROR_EG_MAP_0	0x00000001

#define HW_ENET_SWI_MIRROR_ING_MAP	(0x00008044)

#define BP_ENET_SWI_MIRROR_ING_MAP_RSRVD0	3
#define BM_ENET_SWI_MIRROR_ING_MAP_RSRVD0	0xFFFFFFF8
#define BF_ENET_SWI_MIRROR_ING_MAP_RSRVD0(v) \
		(((v) << 3) & BM_ENET_SWI_MIRROR_ING_MAP_RSRVD0)
#define BM_ENET_SWI_MIRROR_ING_MAP_MIRROR_ING_MAP_2	0x00000004
#define BM_ENET_SWI_MIRROR_ING_MAP_MIRROR_ING_MAP_1	0x00000002
#define BM_ENET_SWI_MIRROR_ING_MAP_MIRROR_ING_MAP_0	0x00000001

#define HW_ENET_SWI_MIRROR_ISRC_0	(0x00008048)

#define BP_ENET_SWI_MIRROR_ISRC_0_MIRROR_ISRC_0	0
#define BM_ENET_SWI_MIRROR_ISRC_0_MIRROR_ISRC_0	0xFFFFFFFF
#define BF_ENET_SWI_MIRROR_ISRC_0_MIRROR_ISRC_0(v)	(v)

#define HW_ENET_SWI_MIRROR_ISRC_1	(0x0000804c)

#define BP_ENET_SWI_MIRROR_ISRC_1_RSRVD0	16
#define BM_ENET_SWI_MIRROR_ISRC_1_RSRVD0	0xFFFF0000
#define BF_ENET_SWI_MIRROR_ISRC_1_RSRVD0(v) \
		(((v) << 16) & BM_ENET_SWI_MIRROR_ISRC_1_RSRVD0)
#define BP_ENET_SWI_MIRROR_ISRC_1_MIRROR_ISRC_1	0
#define BM_ENET_SWI_MIRROR_ISRC_1_MIRROR_ISRC_1	0x0000FFFF
#define BF_ENET_SWI_MIRROR_ISRC_1_MIRROR_ISRC_1(v)  \
		(((v) << 0) & BM_ENET_SWI_MIRROR_ISRC_1_MIRROR_ISRC_1)

#define HW_ENET_SWI_MIRROR_IDST_0	(0x00008050)

#define BP_ENET_SWI_MIRROR_IDST_0_MIRROR_IDST_0	0
#define BM_ENET_SWI_MIRROR_IDST_0_MIRROR_IDST_0	0xFFFFFFFF
#define BF_ENET_SWI_MIRROR_IDST_0_MIRROR_IDST_0(v)	(v)

#define HW_ENET_SWI_MIRROR_IDST_1	(0x00008054)

#define BP_ENET_SWI_MIRROR_IDST_1_RSRVD0	16
#define BM_ENET_SWI_MIRROR_IDST_1_RSRVD0	0xFFFF0000
#define BF_ENET_SWI_MIRROR_IDST_1_RSRVD0(v) \
		(((v) << 16) & BM_ENET_SWI_MIRROR_IDST_1_RSRVD0)
#define BP_ENET_SWI_MIRROR_IDST_1_MIRROR_IDST_1	0
#define BM_ENET_SWI_MIRROR_IDST_1_MIRROR_IDST_1	0x0000FFFF
#define BF_ENET_SWI_MIRROR_IDST_1_MIRROR_IDST_1(v)  \
		(((v) << 0) & BM_ENET_SWI_MIRROR_IDST_1_MIRROR_IDST_1)

#define HW_ENET_SWI_MIRROR_ESRC_0	(0x00008058)

#define BP_ENET_SWI_MIRROR_ESRC_0_MIRROR_ESRC_0	0
#define BM_ENET_SWI_MIRROR_ESRC_0_MIRROR_ESRC_0	0xFFFFFFFF
#define BF_ENET_SWI_MIRROR_ESRC_0_MIRROR_ESRC_0(v)	(v)

#define HW_ENET_SWI_MIRROR_ESRC_1	(0x0000805c)

#define BP_ENET_SWI_MIRROR_ESRC_1_RSRVD0	16
#define BM_ENET_SWI_MIRROR_ESRC_1_RSRVD0	0xFFFF0000
#define BF_ENET_SWI_MIRROR_ESRC_1_RSRVD0(v) \
		(((v) << 16) & BM_ENET_SWI_MIRROR_ESRC_1_RSRVD0)
#define BP_ENET_SWI_MIRROR_ESRC_1_MIRROR_ESRC_1	0
#define BM_ENET_SWI_MIRROR_ESRC_1_MIRROR_ESRC_1	0x0000FFFF
#define BF_ENET_SWI_MIRROR_ESRC_1_MIRROR_ESRC_1(v)  \
		(((v) << 0) & BM_ENET_SWI_MIRROR_ESRC_1_MIRROR_ESRC_1)

#define HW_ENET_SWI_MIRROR_EDST_0	(0x00008060)

#define BP_ENET_SWI_MIRROR_EDST_0_MIRROR_ESRC_0	0
#define BM_ENET_SWI_MIRROR_EDST_0_MIRROR_ESRC_0	0xFFFFFFFF
#define BF_ENET_SWI_MIRROR_EDST_0_MIRROR_ESRC_0(v)	(v)

#define HW_ENET_SWI_MIRROR_EDST_1	(0x00008064)

#define BP_ENET_SWI_MIRROR_EDST_1_RSRVD0	16
#define BM_ENET_SWI_MIRROR_EDST_1_RSRVD0	0xFFFF0000
#define BF_ENET_SWI_MIRROR_EDST_1_RSRVD0(v) \
		(((v) << 16) & BM_ENET_SWI_MIRROR_EDST_1_RSRVD0)
#define BP_ENET_SWI_MIRROR_EDST_1_MIRROR_ESRC_1	0
#define BM_ENET_SWI_MIRROR_EDST_1_MIRROR_ESRC_1	0x0000FFFF
#define BF_ENET_SWI_MIRROR_EDST_1_MIRROR_ESRC_1(v)  \
		(((v) << 0) & BM_ENET_SWI_MIRROR_EDST_1_MIRROR_ESRC_1)

#define HW_ENET_SWI_MIRROR_CNT	(0x00008068)

#define BP_ENET_SWI_MIRROR_CNT_RSRVD0	8
#define BM_ENET_SWI_MIRROR_CNT_RSRVD0	0xFFFFFF00
#define BF_ENET_SWI_MIRROR_CNT_RSRVD0(v) \
		(((v) << 8) & BM_ENET_SWI_MIRROR_CNT_RSRVD0)
#define BP_ENET_SWI_MIRROR_CNT_MIRROR_CNT	0
#define BM_ENET_SWI_MIRROR_CNT_MIRROR_CNT	0x000000FF
#define BF_ENET_SWI_MIRROR_CNT_MIRROR_CNT(v)  \
		(((v) << 0) & BM_ENET_SWI_MIRROR_CNT_MIRROR_CNT)

#define HW_ENET_SWI_OQMGR_STATUS	(0x0000807c)

#define BP_ENET_SWI_OQMGR_STATUS_RSRVD2	24
#define BM_ENET_SWI_OQMGR_STATUS_RSRVD2	0xFF000000
#define BF_ENET_SWI_OQMGR_STATUS_RSRVD2(v) \
		(((v) << 24) & BM_ENET_SWI_OQMGR_STATUS_RSRVD2)
#define BP_ENET_SWI_OQMGR_STATUS_CELLS_AVAILABLE	16
#define BM_ENET_SWI_OQMGR_STATUS_CELLS_AVAILABLE	0x00FF0000
#define BF_ENET_SWI_OQMGR_STATUS_CELLS_AVAILABLE(v)  \
		(((v) << 16) & BM_ENET_SWI_OQMGR_STATUS_CELLS_AVAILABLE)
#define BP_ENET_SWI_OQMGR_STATUS_RSRVD1	7
#define BM_ENET_SWI_OQMGR_STATUS_RSRVD1	0x0000FF80
#define BF_ENET_SWI_OQMGR_STATUS_RSRVD1(v)  \
		(((v) << 7) & BM_ENET_SWI_OQMGR_STATUS_RSRVD1)
#define BM_ENET_SWI_OQMGR_STATUS_DEQUEUE_GRANT	0x00000040
#define BP_ENET_SWI_OQMGR_STATUS_RSRVD0	4
#define BM_ENET_SWI_OQMGR_STATUS_RSRVD0	0x00000030
#define BF_ENET_SWI_OQMGR_STATUS_RSRVD0(v)  \
		(((v) << 4) & BM_ENET_SWI_OQMGR_STATUS_RSRVD0)
#define BM_ENET_SWI_OQMGR_STATUS_MEM_FULL_LATCH	0x00000008
#define BM_ENET_SWI_OQMGR_STATUS_MEM_FULL	0x00000004
#define BM_ENET_SWI_OQMGR_STATUS_NO_CELL_LATCH	0x00000002
#define BM_ENET_SWI_OQMGR_STATUS_BUSY_INITIALIZING	0x00000001

#define HW_ENET_SWI_QMGR_MINCELLS	(0x00008080)

#define BP_ENET_SWI_QMGR_MINCELLS_RSRVD0	8
#define BM_ENET_SWI_QMGR_MINCELLS_RSRVD0	0xFFFFFF00
#define BF_ENET_SWI_QMGR_MINCELLS_RSRVD0(v) \
		(((v) << 8) & BM_ENET_SWI_QMGR_MINCELLS_RSRVD0)
#define BP_ENET_SWI_QMGR_MINCELLS_QMGR_MINCELLS	0
#define BM_ENET_SWI_QMGR_MINCELLS_QMGR_MINCELLS	0x000000FF
#define BF_ENET_SWI_QMGR_MINCELLS_QMGR_MINCELLS(v)  \
		(((v) << 0) & BM_ENET_SWI_QMGR_MINCELLS_QMGR_MINCELLS)

#define HW_ENET_SWI_QMGR_ST_MINCELLS	(0x00008084)

#define BP_ENET_SWI_QMGR_ST_MINCELLS_QMGR_ST_MINCELLS	0
#define BM_ENET_SWI_QMGR_ST_MINCELLS_QMGR_ST_MINCELLS	0xFFFFFFFF
#define BF_ENET_SWI_QMGR_ST_MINCELLS_QMGR_ST_MINCELLS(v)	(v)

#define HW_ENET_SWI_QMGR_CONGEST_STAT	(0x00008088)

#define BP_ENET_SWI_QMGR_CONGEST_STAT_RSRVD0	3
#define BM_ENET_SWI_QMGR_CONGEST_STAT_RSRVD0	0xFFFFFFF8
#define BF_ENET_SWI_QMGR_CONGEST_STAT_RSRVD0(v) \
		(((v) << 3) & BM_ENET_SWI_QMGR_CONGEST_STAT_RSRVD0)
#define BM_ENET_SWI_QMGR_CONGEST_STAT_QMGR_CONGEST_STAT_2	0x00000004
#define BM_ENET_SWI_QMGR_CONGEST_STAT_QMGR_CONGEST_STAT_1	0x00000002
#define BM_ENET_SWI_QMGR_CONGEST_STAT_QMGR_CONGEST_STAT_0	0x00000001

#define HW_ENET_SWI_QMGR_IFACE_STAT	(0x0000808c)

#define BP_ENET_SWI_QMGR_IFACE_STAT_RSRVD1	19
#define BM_ENET_SWI_QMGR_IFACE_STAT_RSRVD1	0xFFF80000
#define BF_ENET_SWI_QMGR_IFACE_STAT_RSRVD1(v) \
		(((v) << 19) & BM_ENET_SWI_QMGR_IFACE_STAT_RSRVD1)
#define BM_ENET_SWI_QMGR_IFACE_STAT_INPUT_2	0x00040000
#define BM_ENET_SWI_QMGR_IFACE_STAT_INPUT_1	0x00020000
#define BM_ENET_SWI_QMGR_IFACE_STAT_INPUT_0	0x00010000
#define BP_ENET_SWI_QMGR_IFACE_STAT_RSRVD0	3
#define BM_ENET_SWI_QMGR_IFACE_STAT_RSRVD0	0x0000FFF8
#define BF_ENET_SWI_QMGR_IFACE_STAT_RSRVD0(v)  \
		(((v) << 3) & BM_ENET_SWI_QMGR_IFACE_STAT_RSRVD0)
#define BM_ENET_SWI_QMGR_IFACE_STAT_OUTPUT_2	0x00000004
#define BM_ENET_SWI_QMGR_IFACE_STAT_OUTPUT_1	0x00000002
#define BM_ENET_SWI_QMGR_IFACE_STAT_OUTPUT_0	0x00000001

#define HW_ENET_SWI_QM_WEIGHTS	(0x00008090)

#define BP_ENET_SWI_QM_WEIGHTS_RSRVD3	29
#define BM_ENET_SWI_QM_WEIGHTS_RSRVD3	0xE0000000
#define BF_ENET_SWI_QM_WEIGHTS_RSRVD3(v) \
		(((v) << 29) & BM_ENET_SWI_QM_WEIGHTS_RSRVD3)
#define BP_ENET_SWI_QM_WEIGHTS_QUEUE_3	24
#define BM_ENET_SWI_QM_WEIGHTS_QUEUE_3	0x1F000000
#define BF_ENET_SWI_QM_WEIGHTS_QUEUE_3(v)  \
		(((v) << 24) & BM_ENET_SWI_QM_WEIGHTS_QUEUE_3)
#define BP_ENET_SWI_QM_WEIGHTS_RSRVD2	21
#define BM_ENET_SWI_QM_WEIGHTS_RSRVD2	0x00E00000
#define BF_ENET_SWI_QM_WEIGHTS_RSRVD2(v)  \
		(((v) << 21) & BM_ENET_SWI_QM_WEIGHTS_RSRVD2)
#define BP_ENET_SWI_QM_WEIGHTS_QUEUE_2	16
#define BM_ENET_SWI_QM_WEIGHTS_QUEUE_2	0x001F0000
#define BF_ENET_SWI_QM_WEIGHTS_QUEUE_2(v)  \
		(((v) << 16) & BM_ENET_SWI_QM_WEIGHTS_QUEUE_2)
#define BP_ENET_SWI_QM_WEIGHTS_RSRVD1	13
#define BM_ENET_SWI_QM_WEIGHTS_RSRVD1	0x0000E000
#define BF_ENET_SWI_QM_WEIGHTS_RSRVD1(v)  \
		(((v) << 13) & BM_ENET_SWI_QM_WEIGHTS_RSRVD1)
#define BP_ENET_SWI_QM_WEIGHTS_QUEUE_1	8
#define BM_ENET_SWI_QM_WEIGHTS_QUEUE_1	0x00001F00
#define BF_ENET_SWI_QM_WEIGHTS_QUEUE_1(v)  \
		(((v) << 8) & BM_ENET_SWI_QM_WEIGHTS_QUEUE_1)
#define BP_ENET_SWI_QM_WEIGHTS_RSRVD0	5
#define BM_ENET_SWI_QM_WEIGHTS_RSRVD0	0x000000E0
#define BF_ENET_SWI_QM_WEIGHTS_RSRVD0(v)  \
		(((v) << 5) & BM_ENET_SWI_QM_WEIGHTS_RSRVD0)
#define BP_ENET_SWI_QM_WEIGHTS_QUEUE_0	0
#define BM_ENET_SWI_QM_WEIGHTS_QUEUE_0	0x0000001F
#define BF_ENET_SWI_QM_WEIGHTS_QUEUE_0(v)  \
		(((v) << 0) & BM_ENET_SWI_QM_WEIGHTS_QUEUE_0)

#define HW_ENET_SWI_QMGR_MINCELLSP0	(0x00008098)

#define BP_ENET_SWI_QMGR_MINCELLSP0_RSRVD0	8
#define BM_ENET_SWI_QMGR_MINCELLSP0_RSRVD0	0xFFFFFF00
#define BF_ENET_SWI_QMGR_MINCELLSP0_RSRVD0(v) \
		(((v) << 8) & BM_ENET_SWI_QMGR_MINCELLSP0_RSRVD0)
#define BP_ENET_SWI_QMGR_MINCELLSP0_QMGR_MINCELLSP0	0
#define BM_ENET_SWI_QMGR_MINCELLSP0_QMGR_MINCELLSP0	0x000000FF
#define BF_ENET_SWI_QMGR_MINCELLSP0_QMGR_MINCELLSP0(v)  \
		(((v) << 0) & BM_ENET_SWI_QMGR_MINCELLSP0_QMGR_MINCELLSP0)

#define HW_ENET_SWI_FORCE_FWD_P0	(0x000080b8)

#define BP_ENET_SWI_FORCE_FWD_P0_RSRVD1	4
#define BM_ENET_SWI_FORCE_FWD_P0_RSRVD1	0xFFFFFFF0
#define BF_ENET_SWI_FORCE_FWD_P0_RSRVD1(v) \
		(((v) << 4) & BM_ENET_SWI_FORCE_FWD_P0_RSRVD1)
#define BP_ENET_SWI_FORCE_FWD_P0_FORCE_DESTINATION	2
#define BM_ENET_SWI_FORCE_FWD_P0_FORCE_DESTINATION	0x0000000C
#define BF_ENET_SWI_FORCE_FWD_P0_FORCE_DESTINATION(v)  \
		(((v) << 2) & BM_ENET_SWI_FORCE_FWD_P0_FORCE_DESTINATION)
#define BM_ENET_SWI_FORCE_FWD_P0_RSRVD0	0x00000002
#define BM_ENET_SWI_FORCE_FWD_P0_FORCE_ENABLE	0x00000001

#define HW_ENET_SWI_PORTSNOOP1	(0x000080bc)

#define BP_ENET_SWI_PORTSNOOP1_DESTINATION_PORT	16
#define BM_ENET_SWI_PORTSNOOP1_DESTINATION_PORT	0xFFFF0000
#define BF_ENET_SWI_PORTSNOOP1_DESTINATION_PORT(v) \
		(((v) << 16) & BM_ENET_SWI_PORTSNOOP1_DESTINATION_PORT)
#define BP_ENET_SWI_PORTSNOOP1_RSRVD0	5
#define BM_ENET_SWI_PORTSNOOP1_RSRVD0	0x0000FFE0
#define BF_ENET_SWI_PORTSNOOP1_RSRVD0(v)  \
		(((v) << 5) & BM_ENET_SWI_PORTSNOOP1_RSRVD0)
#define BM_ENET_SWI_PORTSNOOP1_COMPARE_SOURCE	0x00000010
#define BM_ENET_SWI_PORTSNOOP1_COMPARE_DEST	0x00000008
#define BP_ENET_SWI_PORTSNOOP1_MODE	1
#define BM_ENET_SWI_PORTSNOOP1_MODE	0x00000006
#define BF_ENET_SWI_PORTSNOOP1_MODE(v)  \
		(((v) << 1) & BM_ENET_SWI_PORTSNOOP1_MODE)
#define BM_ENET_SWI_PORTSNOOP1_ENABLE	0x00000001

#define HW_ENET_SWI_PORTSNOOP2	(0x000080c0)

#define BP_ENET_SWI_PORTSNOOP2_DESTINATION_PORT	16
#define BM_ENET_SWI_PORTSNOOP2_DESTINATION_PORT	0xFFFF0000
#define BF_ENET_SWI_PORTSNOOP2_DESTINATION_PORT(v) \
		(((v) << 16) & BM_ENET_SWI_PORTSNOOP2_DESTINATION_PORT)
#define BP_ENET_SWI_PORTSNOOP2_RSRVD0	5
#define BM_ENET_SWI_PORTSNOOP2_RSRVD0	0x0000FFE0
#define BF_ENET_SWI_PORTSNOOP2_RSRVD0(v)  \
		(((v) << 5) & BM_ENET_SWI_PORTSNOOP2_RSRVD0)
#define BM_ENET_SWI_PORTSNOOP2_COMPARE_SOURCE	0x00000010
#define BM_ENET_SWI_PORTSNOOP2_COMPARE_DEST	0x00000008
#define BP_ENET_SWI_PORTSNOOP2_MODE	1
#define BM_ENET_SWI_PORTSNOOP2_MODE	0x00000006
#define BF_ENET_SWI_PORTSNOOP2_MODE(v)  \
		(((v) << 1) & BM_ENET_SWI_PORTSNOOP2_MODE)
#define BM_ENET_SWI_PORTSNOOP2_ENABLE	0x00000001

#define HW_ENET_SWI_PORTSNOOP3	(0x000080c4)

#define BP_ENET_SWI_PORTSNOOP3_DESTINATION_PORT	16
#define BM_ENET_SWI_PORTSNOOP3_DESTINATION_PORT	0xFFFF0000
#define BF_ENET_SWI_PORTSNOOP3_DESTINATION_PORT(v) \
		(((v) << 16) & BM_ENET_SWI_PORTSNOOP3_DESTINATION_PORT)
#define BP_ENET_SWI_PORTSNOOP3_RSRVD0	5
#define BM_ENET_SWI_PORTSNOOP3_RSRVD0	0x0000FFE0
#define BF_ENET_SWI_PORTSNOOP3_RSRVD0(v)  \
		(((v) << 5) & BM_ENET_SWI_PORTSNOOP3_RSRVD0)
#define BM_ENET_SWI_PORTSNOOP3_COMPARE_SOURCE	0x00000010
#define BM_ENET_SWI_PORTSNOOP3_COMPARE_DEST	0x00000008
#define BP_ENET_SWI_PORTSNOOP3_MODE	1
#define BM_ENET_SWI_PORTSNOOP3_MODE	0x00000006
#define BF_ENET_SWI_PORTSNOOP3_MODE(v)  \
		(((v) << 1) & BM_ENET_SWI_PORTSNOOP3_MODE)
#define BM_ENET_SWI_PORTSNOOP3_ENABLE	0x00000001

#define HW_ENET_SWI_PORTSNOOP4	(0x000080c8)

#define BP_ENET_SWI_PORTSNOOP4_DESTINATION_PORT	16
#define BM_ENET_SWI_PORTSNOOP4_DESTINATION_PORT	0xFFFF0000
#define BF_ENET_SWI_PORTSNOOP4_DESTINATION_PORT(v) \
		(((v) << 16) & BM_ENET_SWI_PORTSNOOP4_DESTINATION_PORT)
#define BP_ENET_SWI_PORTSNOOP4_RSRVD0	5
#define BM_ENET_SWI_PORTSNOOP4_RSRVD0	0x0000FFE0
#define BF_ENET_SWI_PORTSNOOP4_RSRVD0(v)  \
		(((v) << 5) & BM_ENET_SWI_PORTSNOOP4_RSRVD0)
#define BM_ENET_SWI_PORTSNOOP4_COMPARE_SOURCE	0x00000010
#define BM_ENET_SWI_PORTSNOOP4_COMPARE_DEST	0x00000008
#define BP_ENET_SWI_PORTSNOOP4_MODE	1
#define BM_ENET_SWI_PORTSNOOP4_MODE	0x00000006
#define BF_ENET_SWI_PORTSNOOP4_MODE(v)  \
		(((v) << 1) & BM_ENET_SWI_PORTSNOOP4_MODE)
#define BM_ENET_SWI_PORTSNOOP4_ENABLE	0x00000001

#define HW_ENET_SWI_PORTSNOOP5	(0x000080cc)

#define BP_ENET_SWI_PORTSNOOP5_DESTINATION_PORT	16
#define BM_ENET_SWI_PORTSNOOP5_DESTINATION_PORT	0xFFFF0000
#define BF_ENET_SWI_PORTSNOOP5_DESTINATION_PORT(v) \
		(((v) << 16) & BM_ENET_SWI_PORTSNOOP5_DESTINATION_PORT)
#define BP_ENET_SWI_PORTSNOOP5_RSRVD0	5
#define BM_ENET_SWI_PORTSNOOP5_RSRVD0	0x0000FFE0
#define BF_ENET_SWI_PORTSNOOP5_RSRVD0(v)  \
		(((v) << 5) & BM_ENET_SWI_PORTSNOOP5_RSRVD0)
#define BM_ENET_SWI_PORTSNOOP5_COMPARE_SOURCE	0x00000010
#define BM_ENET_SWI_PORTSNOOP5_COMPARE_DEST	0x00000008
#define BP_ENET_SWI_PORTSNOOP5_MODE	1
#define BM_ENET_SWI_PORTSNOOP5_MODE	0x00000006
#define BF_ENET_SWI_PORTSNOOP5_MODE(v)  \
		(((v) << 1) & BM_ENET_SWI_PORTSNOOP5_MODE)
#define BM_ENET_SWI_PORTSNOOP5_ENABLE	0x00000001

#define HW_ENET_SWI_PORTSNOOP6	(0x000080d0)

#define BP_ENET_SWI_PORTSNOOP6_DESTINATION_PORT	16
#define BM_ENET_SWI_PORTSNOOP6_DESTINATION_PORT	0xFFFF0000
#define BF_ENET_SWI_PORTSNOOP6_DESTINATION_PORT(v) \
		(((v) << 16) & BM_ENET_SWI_PORTSNOOP6_DESTINATION_PORT)
#define BP_ENET_SWI_PORTSNOOP6_RSRVD0	5
#define BM_ENET_SWI_PORTSNOOP6_RSRVD0	0x0000FFE0
#define BF_ENET_SWI_PORTSNOOP6_RSRVD0(v)  \
		(((v) << 5) & BM_ENET_SWI_PORTSNOOP6_RSRVD0)
#define BM_ENET_SWI_PORTSNOOP6_COMPARE_SOURCE	0x00000010
#define BM_ENET_SWI_PORTSNOOP6_COMPARE_DEST	0x00000008
#define BP_ENET_SWI_PORTSNOOP6_MODE	1
#define BM_ENET_SWI_PORTSNOOP6_MODE	0x00000006
#define BF_ENET_SWI_PORTSNOOP6_MODE(v)  \
		(((v) << 1) & BM_ENET_SWI_PORTSNOOP6_MODE)
#define BM_ENET_SWI_PORTSNOOP6_ENABLE	0x00000001

#define HW_ENET_SWI_PORTSNOOP7	(0x000080d4)

#define BP_ENET_SWI_PORTSNOOP7_DESTINATION_PORT	16
#define BM_ENET_SWI_PORTSNOOP7_DESTINATION_PORT	0xFFFF0000
#define BF_ENET_SWI_PORTSNOOP7_DESTINATION_PORT(v) \
		(((v) << 16) & BM_ENET_SWI_PORTSNOOP7_DESTINATION_PORT)
#define BP_ENET_SWI_PORTSNOOP7_RSRVD0	5
#define BM_ENET_SWI_PORTSNOOP7_RSRVD0	0x0000FFE0
#define BF_ENET_SWI_PORTSNOOP7_RSRVD0(v)  \
		(((v) << 5) & BM_ENET_SWI_PORTSNOOP7_RSRVD0)
#define BM_ENET_SWI_PORTSNOOP7_COMPARE_SOURCE	0x00000010
#define BM_ENET_SWI_PORTSNOOP7_COMPARE_DEST	0x00000008
#define BP_ENET_SWI_PORTSNOOP7_MODE	1
#define BM_ENET_SWI_PORTSNOOP7_MODE	0x00000006
#define BF_ENET_SWI_PORTSNOOP7_MODE(v)  \
		(((v) << 1) & BM_ENET_SWI_PORTSNOOP7_MODE)
#define BM_ENET_SWI_PORTSNOOP7_ENABLE	0x00000001

#define HW_ENET_SWI_PORTSNOOP8	(0x000080d8)

#define BP_ENET_SWI_PORTSNOOP8_DESTINATION_PORT	16
#define BM_ENET_SWI_PORTSNOOP8_DESTINATION_PORT	0xFFFF0000
#define BF_ENET_SWI_PORTSNOOP8_DESTINATION_PORT(v) \
		(((v) << 16) & BM_ENET_SWI_PORTSNOOP8_DESTINATION_PORT)
#define BP_ENET_SWI_PORTSNOOP8_RSRVD0	5
#define BM_ENET_SWI_PORTSNOOP8_RSRVD0	0x0000FFE0
#define BF_ENET_SWI_PORTSNOOP8_RSRVD0(v)  \
		(((v) << 5) & BM_ENET_SWI_PORTSNOOP8_RSRVD0)
#define BM_ENET_SWI_PORTSNOOP8_COMPARE_SOURCE	0x00000010
#define BM_ENET_SWI_PORTSNOOP8_COMPARE_DEST	0x00000008
#define BP_ENET_SWI_PORTSNOOP8_MODE	1
#define BM_ENET_SWI_PORTSNOOP8_MODE	0x00000006
#define BF_ENET_SWI_PORTSNOOP8_MODE(v)  \
		(((v) << 1) & BM_ENET_SWI_PORTSNOOP8_MODE)
#define BM_ENET_SWI_PORTSNOOP8_ENABLE	0x00000001

#define HW_ENET_SWI_IPSNOOP1	(0x000080dc)

#define BP_ENET_SWI_IPSNOOP1_RSRVD1	16
#define BM_ENET_SWI_IPSNOOP1_RSRVD1	0xFFFF0000
#define BF_ENET_SWI_IPSNOOP1_RSRVD1(v) \
		(((v) << 16) & BM_ENET_SWI_IPSNOOP1_RSRVD1)
#define BP_ENET_SWI_IPSNOOP1_PROTOCOL	8
#define BM_ENET_SWI_IPSNOOP1_PROTOCOL	0x0000FF00
#define BF_ENET_SWI_IPSNOOP1_PROTOCOL(v)  \
		(((v) << 8) & BM_ENET_SWI_IPSNOOP1_PROTOCOL)
#define BP_ENET_SWI_IPSNOOP1_RSRVD0	3
#define BM_ENET_SWI_IPSNOOP1_RSRVD0	0x000000F8
#define BF_ENET_SWI_IPSNOOP1_RSRVD0(v)  \
		(((v) << 3) & BM_ENET_SWI_IPSNOOP1_RSRVD0)
#define BP_ENET_SWI_IPSNOOP1_MODE	1
#define BM_ENET_SWI_IPSNOOP1_MODE	0x00000006
#define BF_ENET_SWI_IPSNOOP1_MODE(v)  \
		(((v) << 1) & BM_ENET_SWI_IPSNOOP1_MODE)
#define BM_ENET_SWI_IPSNOOP1_ENABLE	0x00000001

#define HW_ENET_SWI_IPSNOOP2	(0x000080e0)

#define BP_ENET_SWI_IPSNOOP2_RSRVD1	16
#define BM_ENET_SWI_IPSNOOP2_RSRVD1	0xFFFF0000
#define BF_ENET_SWI_IPSNOOP2_RSRVD1(v) \
		(((v) << 16) & BM_ENET_SWI_IPSNOOP2_RSRVD1)
#define BP_ENET_SWI_IPSNOOP2_PROTOCOL	8
#define BM_ENET_SWI_IPSNOOP2_PROTOCOL	0x0000FF00
#define BF_ENET_SWI_IPSNOOP2_PROTOCOL(v)  \
		(((v) << 8) & BM_ENET_SWI_IPSNOOP2_PROTOCOL)
#define BP_ENET_SWI_IPSNOOP2_RSRVD0	3
#define BM_ENET_SWI_IPSNOOP2_RSRVD0	0x000000F8
#define BF_ENET_SWI_IPSNOOP2_RSRVD0(v)  \
		(((v) << 3) & BM_ENET_SWI_IPSNOOP2_RSRVD0)
#define BP_ENET_SWI_IPSNOOP2_MODE	1
#define BM_ENET_SWI_IPSNOOP2_MODE	0x00000006
#define BF_ENET_SWI_IPSNOOP2_MODE(v)  \
		(((v) << 1) & BM_ENET_SWI_IPSNOOP2_MODE)
#define BM_ENET_SWI_IPSNOOP2_ENABLE	0x00000001

#define HW_ENET_SWI_IPSNOOP3	(0x000080e4)

#define BP_ENET_SWI_IPSNOOP3_RSRVD1	16
#define BM_ENET_SWI_IPSNOOP3_RSRVD1	0xFFFF0000
#define BF_ENET_SWI_IPSNOOP3_RSRVD1(v) \
		(((v) << 16) & BM_ENET_SWI_IPSNOOP3_RSRVD1)
#define BP_ENET_SWI_IPSNOOP3_PROTOCOL	8
#define BM_ENET_SWI_IPSNOOP3_PROTOCOL	0x0000FF00
#define BF_ENET_SWI_IPSNOOP3_PROTOCOL(v)  \
		(((v) << 8) & BM_ENET_SWI_IPSNOOP3_PROTOCOL)
#define BP_ENET_SWI_IPSNOOP3_RSRVD0	3
#define BM_ENET_SWI_IPSNOOP3_RSRVD0	0x000000F8
#define BF_ENET_SWI_IPSNOOP3_RSRVD0(v)  \
		(((v) << 3) & BM_ENET_SWI_IPSNOOP3_RSRVD0)
#define BP_ENET_SWI_IPSNOOP3_MODE	1
#define BM_ENET_SWI_IPSNOOP3_MODE	0x00000006
#define BF_ENET_SWI_IPSNOOP3_MODE(v)  \
		(((v) << 1) & BM_ENET_SWI_IPSNOOP3_MODE)
#define BM_ENET_SWI_IPSNOOP3_ENABLE	0x00000001

#define HW_ENET_SWI_IPSNOOP4	(0x000080e8)

#define BP_ENET_SWI_IPSNOOP4_RSRVD1	16
#define BM_ENET_SWI_IPSNOOP4_RSRVD1	0xFFFF0000
#define BF_ENET_SWI_IPSNOOP4_RSRVD1(v) \
		(((v) << 16) & BM_ENET_SWI_IPSNOOP4_RSRVD1)
#define BP_ENET_SWI_IPSNOOP4_PROTOCOL	8
#define BM_ENET_SWI_IPSNOOP4_PROTOCOL	0x0000FF00
#define BF_ENET_SWI_IPSNOOP4_PROTOCOL(v)  \
		(((v) << 8) & BM_ENET_SWI_IPSNOOP4_PROTOCOL)
#define BP_ENET_SWI_IPSNOOP4_RSRVD0	3
#define BM_ENET_SWI_IPSNOOP4_RSRVD0	0x000000F8
#define BF_ENET_SWI_IPSNOOP4_RSRVD0(v)  \
		(((v) << 3) & BM_ENET_SWI_IPSNOOP4_RSRVD0)
#define BP_ENET_SWI_IPSNOOP4_MODE	1
#define BM_ENET_SWI_IPSNOOP4_MODE	0x00000006
#define BF_ENET_SWI_IPSNOOP4_MODE(v)  \
		(((v) << 1) & BM_ENET_SWI_IPSNOOP4_MODE)
#define BM_ENET_SWI_IPSNOOP4_ENABLE	0x00000001

#define HW_ENET_SWI_IPSNOOP5	(0x000080ec)

#define BP_ENET_SWI_IPSNOOP5_RSRVD1	16
#define BM_ENET_SWI_IPSNOOP5_RSRVD1	0xFFFF0000
#define BF_ENET_SWI_IPSNOOP5_RSRVD1(v) \
		(((v) << 16) & BM_ENET_SWI_IPSNOOP5_RSRVD1)
#define BP_ENET_SWI_IPSNOOP5_PROTOCOL	8
#define BM_ENET_SWI_IPSNOOP5_PROTOCOL	0x0000FF00
#define BF_ENET_SWI_IPSNOOP5_PROTOCOL(v)  \
		(((v) << 8) & BM_ENET_SWI_IPSNOOP5_PROTOCOL)
#define BP_ENET_SWI_IPSNOOP5_RSRVD0	3
#define BM_ENET_SWI_IPSNOOP5_RSRVD0	0x000000F8
#define BF_ENET_SWI_IPSNOOP5_RSRVD0(v)  \
		(((v) << 3) & BM_ENET_SWI_IPSNOOP5_RSRVD0)
#define BP_ENET_SWI_IPSNOOP5_MODE	1
#define BM_ENET_SWI_IPSNOOP5_MODE	0x00000006
#define BF_ENET_SWI_IPSNOOP5_MODE(v)  \
		(((v) << 1) & BM_ENET_SWI_IPSNOOP5_MODE)
#define BM_ENET_SWI_IPSNOOP5_ENABLE	0x00000001

#define HW_ENET_SWI_IPSNOOP6	(0x000080f0)

#define BP_ENET_SWI_IPSNOOP6_RSRVD1	16
#define BM_ENET_SWI_IPSNOOP6_RSRVD1	0xFFFF0000
#define BF_ENET_SWI_IPSNOOP6_RSRVD1(v) \
		(((v) << 16) & BM_ENET_SWI_IPSNOOP6_RSRVD1)
#define BP_ENET_SWI_IPSNOOP6_PROTOCOL	8
#define BM_ENET_SWI_IPSNOOP6_PROTOCOL	0x0000FF00
#define BF_ENET_SWI_IPSNOOP6_PROTOCOL(v)  \
		(((v) << 8) & BM_ENET_SWI_IPSNOOP6_PROTOCOL)
#define BP_ENET_SWI_IPSNOOP6_RSRVD0	3
#define BM_ENET_SWI_IPSNOOP6_RSRVD0	0x000000F8
#define BF_ENET_SWI_IPSNOOP6_RSRVD0(v)  \
		(((v) << 3) & BM_ENET_SWI_IPSNOOP6_RSRVD0)
#define BP_ENET_SWI_IPSNOOP6_MODE	1
#define BM_ENET_SWI_IPSNOOP6_MODE	0x00000006
#define BF_ENET_SWI_IPSNOOP6_MODE(v)  \
		(((v) << 1) & BM_ENET_SWI_IPSNOOP6_MODE)
#define BM_ENET_SWI_IPSNOOP6_ENABLE	0x00000001

#define HW_ENET_SWI_IPSNOOP7	(0x000080f4)

#define BP_ENET_SWI_IPSNOOP7_RSRVD1	16
#define BM_ENET_SWI_IPSNOOP7_RSRVD1	0xFFFF0000
#define BF_ENET_SWI_IPSNOOP7_RSRVD1(v) \
		(((v) << 16) & BM_ENET_SWI_IPSNOOP7_RSRVD1)
#define BP_ENET_SWI_IPSNOOP7_PROTOCOL	8
#define BM_ENET_SWI_IPSNOOP7_PROTOCOL	0x0000FF00
#define BF_ENET_SWI_IPSNOOP7_PROTOCOL(v)  \
		(((v) << 8) & BM_ENET_SWI_IPSNOOP7_PROTOCOL)
#define BP_ENET_SWI_IPSNOOP7_RSRVD0	3
#define BM_ENET_SWI_IPSNOOP7_RSRVD0	0x000000F8
#define BF_ENET_SWI_IPSNOOP7_RSRVD0(v)  \
		(((v) << 3) & BM_ENET_SWI_IPSNOOP7_RSRVD0)
#define BP_ENET_SWI_IPSNOOP7_MODE	1
#define BM_ENET_SWI_IPSNOOP7_MODE	0x00000006
#define BF_ENET_SWI_IPSNOOP7_MODE(v)  \
		(((v) << 1) & BM_ENET_SWI_IPSNOOP7_MODE)
#define BM_ENET_SWI_IPSNOOP7_ENABLE	0x00000001

#define HW_ENET_SWI_IPSNOOP8	(0x000080f8)

#define BP_ENET_SWI_IPSNOOP8_RSRVD1	16
#define BM_ENET_SWI_IPSNOOP8_RSRVD1	0xFFFF0000
#define BF_ENET_SWI_IPSNOOP8_RSRVD1(v) \
		(((v) << 16) & BM_ENET_SWI_IPSNOOP8_RSRVD1)
#define BP_ENET_SWI_IPSNOOP8_PROTOCOL	8
#define BM_ENET_SWI_IPSNOOP8_PROTOCOL	0x0000FF00
#define BF_ENET_SWI_IPSNOOP8_PROTOCOL(v)  \
		(((v) << 8) & BM_ENET_SWI_IPSNOOP8_PROTOCOL)
#define BP_ENET_SWI_IPSNOOP8_RSRVD0	3
#define BM_ENET_SWI_IPSNOOP8_RSRVD0	0x000000F8
#define BF_ENET_SWI_IPSNOOP8_RSRVD0(v)  \
		(((v) << 3) & BM_ENET_SWI_IPSNOOP8_RSRVD0)
#define BP_ENET_SWI_IPSNOOP8_MODE	1
#define BM_ENET_SWI_IPSNOOP8_MODE	0x00000006
#define BF_ENET_SWI_IPSNOOP8_MODE(v)  \
		(((v) << 1) & BM_ENET_SWI_IPSNOOP8_MODE)
#define BM_ENET_SWI_IPSNOOP8_ENABLE	0x00000001

#define HW_ENET_SWI_VLAN_PRIORITY0	(0x000080fc)

#define BP_ENET_SWI_VLAN_PRIORITY0_RSRVD0	24
#define BM_ENET_SWI_VLAN_PRIORITY0_RSRVD0	0xFF000000
#define BF_ENET_SWI_VLAN_PRIORITY0_RSRVD0(v) \
		(((v) << 24) & BM_ENET_SWI_VLAN_PRIORITY0_RSRVD0)
#define BP_ENET_SWI_VLAN_PRIORITY0_P7	21
#define BM_ENET_SWI_VLAN_PRIORITY0_P7	0x00E00000
#define BF_ENET_SWI_VLAN_PRIORITY0_P7(v)  \
		(((v) << 21) & BM_ENET_SWI_VLAN_PRIORITY0_P7)
#define BP_ENET_SWI_VLAN_PRIORITY0_P6	18
#define BM_ENET_SWI_VLAN_PRIORITY0_P6	0x001C0000
#define BF_ENET_SWI_VLAN_PRIORITY0_P6(v)  \
		(((v) << 18) & BM_ENET_SWI_VLAN_PRIORITY0_P6)
#define BP_ENET_SWI_VLAN_PRIORITY0_P5	15
#define BM_ENET_SWI_VLAN_PRIORITY0_P5	0x00038000
#define BF_ENET_SWI_VLAN_PRIORITY0_P5(v)  \
		(((v) << 15) & BM_ENET_SWI_VLAN_PRIORITY0_P5)
#define BP_ENET_SWI_VLAN_PRIORITY0_P4	12
#define BM_ENET_SWI_VLAN_PRIORITY0_P4	0x00007000
#define BF_ENET_SWI_VLAN_PRIORITY0_P4(v)  \
		(((v) << 12) & BM_ENET_SWI_VLAN_PRIORITY0_P4)
#define BP_ENET_SWI_VLAN_PRIORITY0_P3	9
#define BM_ENET_SWI_VLAN_PRIORITY0_P3	0x00000E00
#define BF_ENET_SWI_VLAN_PRIORITY0_P3(v)  \
		(((v) << 9) & BM_ENET_SWI_VLAN_PRIORITY0_P3)
#define BP_ENET_SWI_VLAN_PRIORITY0_P2	6
#define BM_ENET_SWI_VLAN_PRIORITY0_P2	0x000001C0
#define BF_ENET_SWI_VLAN_PRIORITY0_P2(v)  \
		(((v) << 6) & BM_ENET_SWI_VLAN_PRIORITY0_P2)
#define BP_ENET_SWI_VLAN_PRIORITY0_P1	3
#define BM_ENET_SWI_VLAN_PRIORITY0_P1	0x00000038
#define BF_ENET_SWI_VLAN_PRIORITY0_P1(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_PRIORITY0_P1)
#define BP_ENET_SWI_VLAN_PRIORITY0_P0	0
#define BM_ENET_SWI_VLAN_PRIORITY0_P0	0x00000007
#define BF_ENET_SWI_VLAN_PRIORITY0_P0(v)  \
		(((v) << 0) & BM_ENET_SWI_VLAN_PRIORITY0_P0)

#define HW_ENET_SWI_VLAN_PRIORITY1	(0x00008100)

#define BP_ENET_SWI_VLAN_PRIORITY1_RSRVD0	24
#define BM_ENET_SWI_VLAN_PRIORITY1_RSRVD0	0xFF000000
#define BF_ENET_SWI_VLAN_PRIORITY1_RSRVD0(v) \
		(((v) << 24) & BM_ENET_SWI_VLAN_PRIORITY1_RSRVD0)
#define BP_ENET_SWI_VLAN_PRIORITY1_P7	21
#define BM_ENET_SWI_VLAN_PRIORITY1_P7	0x00E00000
#define BF_ENET_SWI_VLAN_PRIORITY1_P7(v)  \
		(((v) << 21) & BM_ENET_SWI_VLAN_PRIORITY1_P7)
#define BP_ENET_SWI_VLAN_PRIORITY1_P6	18
#define BM_ENET_SWI_VLAN_PRIORITY1_P6	0x001C0000
#define BF_ENET_SWI_VLAN_PRIORITY1_P6(v)  \
		(((v) << 18) & BM_ENET_SWI_VLAN_PRIORITY1_P6)
#define BP_ENET_SWI_VLAN_PRIORITY1_P5	15
#define BM_ENET_SWI_VLAN_PRIORITY1_P5	0x00038000
#define BF_ENET_SWI_VLAN_PRIORITY1_P5(v)  \
		(((v) << 15) & BM_ENET_SWI_VLAN_PRIORITY1_P5)
#define BP_ENET_SWI_VLAN_PRIORITY1_P4	12
#define BM_ENET_SWI_VLAN_PRIORITY1_P4	0x00007000
#define BF_ENET_SWI_VLAN_PRIORITY1_P4(v)  \
		(((v) << 12) & BM_ENET_SWI_VLAN_PRIORITY1_P4)
#define BP_ENET_SWI_VLAN_PRIORITY1_P3	9
#define BM_ENET_SWI_VLAN_PRIORITY1_P3	0x00000E00
#define BF_ENET_SWI_VLAN_PRIORITY1_P3(v)  \
		(((v) << 9) & BM_ENET_SWI_VLAN_PRIORITY1_P3)
#define BP_ENET_SWI_VLAN_PRIORITY1_P2	6
#define BM_ENET_SWI_VLAN_PRIORITY1_P2	0x000001C0
#define BF_ENET_SWI_VLAN_PRIORITY1_P2(v)  \
		(((v) << 6) & BM_ENET_SWI_VLAN_PRIORITY1_P2)
#define BP_ENET_SWI_VLAN_PRIORITY1_P1	3
#define BM_ENET_SWI_VLAN_PRIORITY1_P1	0x00000038
#define BF_ENET_SWI_VLAN_PRIORITY1_P1(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_PRIORITY1_P1)
#define BP_ENET_SWI_VLAN_PRIORITY1_P0	0
#define BM_ENET_SWI_VLAN_PRIORITY1_P0	0x00000007
#define BF_ENET_SWI_VLAN_PRIORITY1_P0(v)  \
		(((v) << 0) & BM_ENET_SWI_VLAN_PRIORITY1_P0)

#define HW_ENET_SWI_VLAN_PRIORITY2	(0x00008104)

#define BP_ENET_SWI_VLAN_PRIORITY2_RSRVD0	24
#define BM_ENET_SWI_VLAN_PRIORITY2_RSRVD0	0xFF000000
#define BF_ENET_SWI_VLAN_PRIORITY2_RSRVD0(v) \
		(((v) << 24) & BM_ENET_SWI_VLAN_PRIORITY2_RSRVD0)
#define BP_ENET_SWI_VLAN_PRIORITY2_P7	21
#define BM_ENET_SWI_VLAN_PRIORITY2_P7	0x00E00000
#define BF_ENET_SWI_VLAN_PRIORITY2_P7(v)  \
		(((v) << 21) & BM_ENET_SWI_VLAN_PRIORITY2_P7)
#define BP_ENET_SWI_VLAN_PRIORITY2_P6	18
#define BM_ENET_SWI_VLAN_PRIORITY2_P6	0x001C0000
#define BF_ENET_SWI_VLAN_PRIORITY2_P6(v)  \
		(((v) << 18) & BM_ENET_SWI_VLAN_PRIORITY2_P6)
#define BP_ENET_SWI_VLAN_PRIORITY2_P5	15
#define BM_ENET_SWI_VLAN_PRIORITY2_P5	0x00038000
#define BF_ENET_SWI_VLAN_PRIORITY2_P5(v)  \
		(((v) << 15) & BM_ENET_SWI_VLAN_PRIORITY2_P5)
#define BP_ENET_SWI_VLAN_PRIORITY2_P4	12
#define BM_ENET_SWI_VLAN_PRIORITY2_P4	0x00007000
#define BF_ENET_SWI_VLAN_PRIORITY2_P4(v)  \
		(((v) << 12) & BM_ENET_SWI_VLAN_PRIORITY2_P4)
#define BP_ENET_SWI_VLAN_PRIORITY2_P3	9
#define BM_ENET_SWI_VLAN_PRIORITY2_P3	0x00000E00
#define BF_ENET_SWI_VLAN_PRIORITY2_P3(v)  \
		(((v) << 9) & BM_ENET_SWI_VLAN_PRIORITY2_P3)
#define BP_ENET_SWI_VLAN_PRIORITY2_P2	6
#define BM_ENET_SWI_VLAN_PRIORITY2_P2	0x000001C0
#define BF_ENET_SWI_VLAN_PRIORITY2_P2(v)  \
		(((v) << 6) & BM_ENET_SWI_VLAN_PRIORITY2_P2)
#define BP_ENET_SWI_VLAN_PRIORITY2_P1	3
#define BM_ENET_SWI_VLAN_PRIORITY2_P1	0x00000038
#define BF_ENET_SWI_VLAN_PRIORITY2_P1(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_PRIORITY2_P1)
#define BP_ENET_SWI_VLAN_PRIORITY2_P0	0
#define BM_ENET_SWI_VLAN_PRIORITY2_P0	0x00000007
#define BF_ENET_SWI_VLAN_PRIORITY2_P0(v)  \
		(((v) << 0) & BM_ENET_SWI_VLAN_PRIORITY2_P0)

#define HW_ENET_SWI_IP_PRIORITY	(0x0000813c)

#define BM_ENET_SWI_IP_PRIORITY_READ	0x80000000
#define BP_ENET_SWI_IP_PRIORITY_RSRVD0	15
#define BM_ENET_SWI_IP_PRIORITY_RSRVD0	0x7FFF8000
#define BF_ENET_SWI_IP_PRIORITY_RSRVD0(v)  \
		(((v) << 15) & BM_ENET_SWI_IP_PRIORITY_RSRVD0)
#define BP_ENET_SWI_IP_PRIORITY_PRIORITY_PORT2	13
#define BM_ENET_SWI_IP_PRIORITY_PRIORITY_PORT2	0x00006000
#define BF_ENET_SWI_IP_PRIORITY_PRIORITY_PORT2(v)  \
		(((v) << 13) & BM_ENET_SWI_IP_PRIORITY_PRIORITY_PORT2)
#define BP_ENET_SWI_IP_PRIORITY_PRIORITY_PORT1	11
#define BM_ENET_SWI_IP_PRIORITY_PRIORITY_PORT1	0x00001800
#define BF_ENET_SWI_IP_PRIORITY_PRIORITY_PORT1(v)  \
		(((v) << 11) & BM_ENET_SWI_IP_PRIORITY_PRIORITY_PORT1)
#define BP_ENET_SWI_IP_PRIORITY_PRIORITY_PORT0	9
#define BM_ENET_SWI_IP_PRIORITY_PRIORITY_PORT0	0x00000600
#define BF_ENET_SWI_IP_PRIORITY_PRIORITY_PORT0(v)  \
		(((v) << 9) & BM_ENET_SWI_IP_PRIORITY_PRIORITY_PORT0)
#define BM_ENET_SWI_IP_PRIORITY_IPV4_SELECT	0x00000100
#define BP_ENET_SWI_IP_PRIORITY_ADDRESS	0
#define BM_ENET_SWI_IP_PRIORITY_ADDRESS	0x000000FF
#define BF_ENET_SWI_IP_PRIORITY_ADDRESS(v)  \
		(((v) << 0) & BM_ENET_SWI_IP_PRIORITY_ADDRESS)

#define HW_ENET_SWI_PRIORITY_CFG0	(0x0000817c)

#define BP_ENET_SWI_PRIORITY_CFG0_RSRVD1	7
#define BM_ENET_SWI_PRIORITY_CFG0_RSRVD1	0xFFFFFF80
#define BF_ENET_SWI_PRIORITY_CFG0_RSRVD1(v) \
		(((v) << 7) & BM_ENET_SWI_PRIORITY_CFG0_RSRVD1)
#define BP_ENET_SWI_PRIORITY_CFG0_DEFAULT_PRIORITY	4
#define BM_ENET_SWI_PRIORITY_CFG0_DEFAULT_PRIORITY	0x00000070
#define BF_ENET_SWI_PRIORITY_CFG0_DEFAULT_PRIORITY(v)  \
		(((v) << 4) & BM_ENET_SWI_PRIORITY_CFG0_DEFAULT_PRIORITY)
#define BM_ENET_SWI_PRIORITY_CFG0_RSRVD0	0x00000008
#define BM_ENET_SWI_PRIORITY_CFG0_MAC_EN	0x00000004
#define BM_ENET_SWI_PRIORITY_CFG0_IP_EN	0x00000002
#define BM_ENET_SWI_PRIORITY_CFG0_VLAN_EN	0x00000001

#define HW_ENET_SWI_PRIORITY_CFG1	(0x00008180)

#define BP_ENET_SWI_PRIORITY_CFG1_RSRVD1	7
#define BM_ENET_SWI_PRIORITY_CFG1_RSRVD1	0xFFFFFF80
#define BF_ENET_SWI_PRIORITY_CFG1_RSRVD1(v) \
		(((v) << 7) & BM_ENET_SWI_PRIORITY_CFG1_RSRVD1)
#define BP_ENET_SWI_PRIORITY_CFG1_DEFAULT_PRIORITY	4
#define BM_ENET_SWI_PRIORITY_CFG1_DEFAULT_PRIORITY	0x00000070
#define BF_ENET_SWI_PRIORITY_CFG1_DEFAULT_PRIORITY(v)  \
		(((v) << 4) & BM_ENET_SWI_PRIORITY_CFG1_DEFAULT_PRIORITY)
#define BM_ENET_SWI_PRIORITY_CFG1_RSRVD0	0x00000008
#define BM_ENET_SWI_PRIORITY_CFG1_MAC_EN	0x00000004
#define BM_ENET_SWI_PRIORITY_CFG1_IP_EN	0x00000002
#define BM_ENET_SWI_PRIORITY_CFG1_VLAN_EN	0x00000001

#define HW_ENET_SWI_PRIORITY_CFG2	(0x00008184)

#define BP_ENET_SWI_PRIORITY_CFG2_RSRVD1	7
#define BM_ENET_SWI_PRIORITY_CFG2_RSRVD1	0xFFFFFF80
#define BF_ENET_SWI_PRIORITY_CFG2_RSRVD1(v) \
		(((v) << 7) & BM_ENET_SWI_PRIORITY_CFG2_RSRVD1)
#define BP_ENET_SWI_PRIORITY_CFG2_DEFAULT_PRIORITY	4
#define BM_ENET_SWI_PRIORITY_CFG2_DEFAULT_PRIORITY	0x00000070
#define BF_ENET_SWI_PRIORITY_CFG2_DEFAULT_PRIORITY(v)  \
		(((v) << 4) & BM_ENET_SWI_PRIORITY_CFG2_DEFAULT_PRIORITY)
#define BM_ENET_SWI_PRIORITY_CFG2_RSRVD0	0x00000008
#define BM_ENET_SWI_PRIORITY_CFG2_MAC_EN	0x00000004
#define BM_ENET_SWI_PRIORITY_CFG2_IP_EN	0x00000002
#define BM_ENET_SWI_PRIORITY_CFG2_VLAN_EN	0x00000001

#define HW_ENET_SWI_SYSTEM_TAGINFO0	(0x000081fc)

#define BP_ENET_SWI_SYSTEM_TAGINFO0_RSRVD0	16
#define BM_ENET_SWI_SYSTEM_TAGINFO0_RSRVD0	0xFFFF0000
#define BF_ENET_SWI_SYSTEM_TAGINFO0_RSRVD0(v) \
		(((v) << 16) & BM_ENET_SWI_SYSTEM_TAGINFO0_RSRVD0)
#define BP_ENET_SWI_SYSTEM_TAGINFO0_SYSTEM_TAGINFO0	0
#define BM_ENET_SWI_SYSTEM_TAGINFO0_SYSTEM_TAGINFO0	0x0000FFFF
#define BF_ENET_SWI_SYSTEM_TAGINFO0_SYSTEM_TAGINFO0(v)  \
		(((v) << 0) & BM_ENET_SWI_SYSTEM_TAGINFO0_SYSTEM_TAGINFO0)

#define HW_ENET_SWI_SYSTEM_TAGINFO1	(0x00008200)

#define BP_ENET_SWI_SYSTEM_TAGINFO1_RSRVD0	16
#define BM_ENET_SWI_SYSTEM_TAGINFO1_RSRVD0	0xFFFF0000
#define BF_ENET_SWI_SYSTEM_TAGINFO1_RSRVD0(v) \
		(((v) << 16) & BM_ENET_SWI_SYSTEM_TAGINFO1_RSRVD0)
#define BP_ENET_SWI_SYSTEM_TAGINFO1_SYSTEM_TAGINFO0	0
#define BM_ENET_SWI_SYSTEM_TAGINFO1_SYSTEM_TAGINFO0	0x0000FFFF
#define BF_ENET_SWI_SYSTEM_TAGINFO1_SYSTEM_TAGINFO0(v)  \
		(((v) << 0) & BM_ENET_SWI_SYSTEM_TAGINFO1_SYSTEM_TAGINFO0)

#define HW_ENET_SWI_SYSTEM_TAGINFO2	(0x00008204)

#define BP_ENET_SWI_SYSTEM_TAGINFO2_RSRVD0	16
#define BM_ENET_SWI_SYSTEM_TAGINFO2_RSRVD0	0xFFFF0000
#define BF_ENET_SWI_SYSTEM_TAGINFO2_RSRVD0(v) \
		(((v) << 16) & BM_ENET_SWI_SYSTEM_TAGINFO2_RSRVD0)
#define BP_ENET_SWI_SYSTEM_TAGINFO2_SYSTEM_TAGINFO0	0
#define BM_ENET_SWI_SYSTEM_TAGINFO2_SYSTEM_TAGINFO0	0x0000FFFF
#define BF_ENET_SWI_SYSTEM_TAGINFO2_SYSTEM_TAGINFO0(v)  \
		(((v) << 0) & BM_ENET_SWI_SYSTEM_TAGINFO2_SYSTEM_TAGINFO0)

#define HW_ENET_SWI_VLAN_RES_TABLE_0	(0x0000827c)

#define BP_ENET_SWI_VLAN_RES_TABLE_0_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_0_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_0_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_0_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_0_VLAN_ID_0	3
#define BM_ENET_SWI_VLAN_RES_TABLE_0_VLAN_ID_0	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_0_VLAN_ID_0(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_0_VLAN_ID_0)
#define BM_ENET_SWI_VLAN_RES_TABLE_0_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_0_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_0_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_1	(0x00008280)

#define BP_ENET_SWI_VLAN_RES_TABLE_1_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_1_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_1_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_1_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_1_VLAN_ID_1	3
#define BM_ENET_SWI_VLAN_RES_TABLE_1_VLAN_ID_1	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_1_VLAN_ID_1(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_1_VLAN_ID_1)
#define BM_ENET_SWI_VLAN_RES_TABLE_1_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_1_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_1_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_2	(0x00008284)

#define BP_ENET_SWI_VLAN_RES_TABLE_2_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_2_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_2_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_2_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_2_VLAN_ID_2	3
#define BM_ENET_SWI_VLAN_RES_TABLE_2_VLAN_ID_2	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_2_VLAN_ID_2(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_2_VLAN_ID_2)
#define BM_ENET_SWI_VLAN_RES_TABLE_2_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_2_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_2_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_3	(0x00008288)

#define BP_ENET_SWI_VLAN_RES_TABLE_3_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_3_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_3_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_3_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_3_VLAN_ID_3	3
#define BM_ENET_SWI_VLAN_RES_TABLE_3_VLAN_ID_3	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_3_VLAN_ID_3(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_3_VLAN_ID_3)
#define BM_ENET_SWI_VLAN_RES_TABLE_3_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_3_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_3_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_4	(0x0000828c)

#define BP_ENET_SWI_VLAN_RES_TABLE_4_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_4_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_4_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_4_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_4_VLAN_ID_4	3
#define BM_ENET_SWI_VLAN_RES_TABLE_4_VLAN_ID_4	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_4_VLAN_ID_4(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_4_VLAN_ID_4)
#define BM_ENET_SWI_VLAN_RES_TABLE_4_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_4_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_4_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_5	(0x00008290)

#define BP_ENET_SWI_VLAN_RES_TABLE_5_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_5_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_5_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_5_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_5_VLAN_ID_5	3
#define BM_ENET_SWI_VLAN_RES_TABLE_5_VLAN_ID_5	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_5_VLAN_ID_5(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_5_VLAN_ID_5)
#define BM_ENET_SWI_VLAN_RES_TABLE_5_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_5_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_5_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_6	(0x00008294)

#define BP_ENET_SWI_VLAN_RES_TABLE_6_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_6_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_6_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_6_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_6_VLAN_ID_6	3
#define BM_ENET_SWI_VLAN_RES_TABLE_6_VLAN_ID_6	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_6_VLAN_ID_6(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_6_VLAN_ID_6)
#define BM_ENET_SWI_VLAN_RES_TABLE_6_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_6_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_6_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_7	(0x00008298)

#define BP_ENET_SWI_VLAN_RES_TABLE_7_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_7_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_7_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_7_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_7_VLAN_ID_7	3
#define BM_ENET_SWI_VLAN_RES_TABLE_7_VLAN_ID_7	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_7_VLAN_ID_7(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_7_VLAN_ID_7)
#define BM_ENET_SWI_VLAN_RES_TABLE_7_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_7_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_7_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_8	(0x0000829c)

#define BP_ENET_SWI_VLAN_RES_TABLE_8_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_8_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_8_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_8_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_8_VLAN_ID_8	3
#define BM_ENET_SWI_VLAN_RES_TABLE_8_VLAN_ID_8	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_8_VLAN_ID_8(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_8_VLAN_ID_8)
#define BM_ENET_SWI_VLAN_RES_TABLE_8_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_8_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_8_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_9	(0x000082a0)

#define BP_ENET_SWI_VLAN_RES_TABLE_9_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_9_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_9_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_9_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_9_VLAN_ID_9	3
#define BM_ENET_SWI_VLAN_RES_TABLE_9_VLAN_ID_9	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_9_VLAN_ID_9(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_9_VLAN_ID_9)
#define BM_ENET_SWI_VLAN_RES_TABLE_9_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_9_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_9_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_10	(0x000082a4)

#define BP_ENET_SWI_VLAN_RES_TABLE_10_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_10_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_10_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_10_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_10_VLAN_ID_10	3
#define BM_ENET_SWI_VLAN_RES_TABLE_10_VLAN_ID_10	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_10_VLAN_ID_10(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_10_VLAN_ID_10)
#define BM_ENET_SWI_VLAN_RES_TABLE_10_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_10_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_10_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_11	(0x000082a8)

#define BP_ENET_SWI_VLAN_RES_TABLE_11_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_11_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_11_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_11_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_11_VLAN_ID_11	3
#define BM_ENET_SWI_VLAN_RES_TABLE_11_VLAN_ID_11	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_11_VLAN_ID_11(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_11_VLAN_ID_11)
#define BM_ENET_SWI_VLAN_RES_TABLE_11_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_11_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_11_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_12	(0x000082ac)

#define BP_ENET_SWI_VLAN_RES_TABLE_12_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_12_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_12_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_12_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_12_VLAN_ID_12	3
#define BM_ENET_SWI_VLAN_RES_TABLE_12_VLAN_ID_12	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_12_VLAN_ID_12(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_12_VLAN_ID_12)
#define BM_ENET_SWI_VLAN_RES_TABLE_12_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_12_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_12_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_13	(0x000082b0)

#define BP_ENET_SWI_VLAN_RES_TABLE_13_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_13_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_13_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_13_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_13_VLAN_ID_13	3
#define BM_ENET_SWI_VLAN_RES_TABLE_13_VLAN_ID_13	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_13_VLAN_ID_13(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_13_VLAN_ID_13)
#define BM_ENET_SWI_VLAN_RES_TABLE_13_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_13_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_13_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_14	(0x000082b4)

#define BP_ENET_SWI_VLAN_RES_TABLE_14_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_14_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_14_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_14_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_14_VLAN_ID_14	3
#define BM_ENET_SWI_VLAN_RES_TABLE_14_VLAN_ID_14	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_14_VLAN_ID_14(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_14_VLAN_ID_14)
#define BM_ENET_SWI_VLAN_RES_TABLE_14_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_14_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_14_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_15	(0x000082b8)

#define BP_ENET_SWI_VLAN_RES_TABLE_15_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_15_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_15_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_15_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_15_VLAN_ID_15	3
#define BM_ENET_SWI_VLAN_RES_TABLE_15_VLAN_ID_15	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_15_VLAN_ID_15(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_15_VLAN_ID_15)
#define BM_ENET_SWI_VLAN_RES_TABLE_15_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_15_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_15_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_16	(0x000082bc)

#define BP_ENET_SWI_VLAN_RES_TABLE_16_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_16_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_16_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_16_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_16_VLAN_ID_16	3
#define BM_ENET_SWI_VLAN_RES_TABLE_16_VLAN_ID_16	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_16_VLAN_ID_16(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_16_VLAN_ID_16)
#define BM_ENET_SWI_VLAN_RES_TABLE_16_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_16_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_16_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_17	(0x000082c0)

#define BP_ENET_SWI_VLAN_RES_TABLE_17_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_17_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_17_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_17_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_17_VLAN_ID_17	3
#define BM_ENET_SWI_VLAN_RES_TABLE_17_VLAN_ID_17	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_17_VLAN_ID_17(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_17_VLAN_ID_17)
#define BM_ENET_SWI_VLAN_RES_TABLE_17_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_17_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_17_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_18	(0x000082c4)

#define BP_ENET_SWI_VLAN_RES_TABLE_18_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_18_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_18_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_18_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_18_VLAN_ID_18	3
#define BM_ENET_SWI_VLAN_RES_TABLE_18_VLAN_ID_18	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_18_VLAN_ID_18(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_18_VLAN_ID_18)
#define BM_ENET_SWI_VLAN_RES_TABLE_18_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_18_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_18_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_19	(0x000082c8)

#define BP_ENET_SWI_VLAN_RES_TABLE_19_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_19_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_19_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_19_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_19_VLAN_ID_19	3
#define BM_ENET_SWI_VLAN_RES_TABLE_19_VLAN_ID_19	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_19_VLAN_ID_19(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_19_VLAN_ID_19)
#define BM_ENET_SWI_VLAN_RES_TABLE_19_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_19_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_19_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_20	(0x000082cc)

#define BP_ENET_SWI_VLAN_RES_TABLE_20_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_20_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_20_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_20_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_20_VLAN_ID_20	3
#define BM_ENET_SWI_VLAN_RES_TABLE_20_VLAN_ID_20	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_20_VLAN_ID_20(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_20_VLAN_ID_20)
#define BM_ENET_SWI_VLAN_RES_TABLE_20_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_20_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_20_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_21	(0x000082d0)

#define BP_ENET_SWI_VLAN_RES_TABLE_21_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_21_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_21_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_21_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_21_VLAN_ID_21	3
#define BM_ENET_SWI_VLAN_RES_TABLE_21_VLAN_ID_21	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_21_VLAN_ID_21(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_21_VLAN_ID_21)
#define BM_ENET_SWI_VLAN_RES_TABLE_21_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_21_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_21_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_22	(0x000082d4)

#define BP_ENET_SWI_VLAN_RES_TABLE_22_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_22_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_22_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_22_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_22_VLAN_ID_22	3
#define BM_ENET_SWI_VLAN_RES_TABLE_22_VLAN_ID_22	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_22_VLAN_ID_22(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_22_VLAN_ID_22)
#define BM_ENET_SWI_VLAN_RES_TABLE_22_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_22_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_22_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_23	(0x000082d8)

#define BP_ENET_SWI_VLAN_RES_TABLE_23_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_23_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_23_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_23_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_23_VLAN_ID_23	3
#define BM_ENET_SWI_VLAN_RES_TABLE_23_VLAN_ID_23	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_23_VLAN_ID_23(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_23_VLAN_ID_23)
#define BM_ENET_SWI_VLAN_RES_TABLE_23_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_23_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_23_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_24	(0x000082dc)

#define BP_ENET_SWI_VLAN_RES_TABLE_24_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_24_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_24_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_24_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_24_VLAN_ID_24	3
#define BM_ENET_SWI_VLAN_RES_TABLE_24_VLAN_ID_24	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_24_VLAN_ID_24(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_24_VLAN_ID_24)
#define BM_ENET_SWI_VLAN_RES_TABLE_24_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_24_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_24_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_25	(0x000082e0)

#define BP_ENET_SWI_VLAN_RES_TABLE_25_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_25_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_25_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_25_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_25_VLAN_ID_25	3
#define BM_ENET_SWI_VLAN_RES_TABLE_25_VLAN_ID_25	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_25_VLAN_ID_25(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_25_VLAN_ID_25)
#define BM_ENET_SWI_VLAN_RES_TABLE_25_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_25_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_25_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_26	(0x000082e4)

#define BP_ENET_SWI_VLAN_RES_TABLE_26_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_26_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_26_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_26_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_26_VLAN_ID_26	3
#define BM_ENET_SWI_VLAN_RES_TABLE_26_VLAN_ID_26	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_26_VLAN_ID_26(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_26_VLAN_ID_26)
#define BM_ENET_SWI_VLAN_RES_TABLE_26_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_26_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_26_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_27	(0x000082e8)

#define BP_ENET_SWI_VLAN_RES_TABLE_27_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_27_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_27_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_27_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_27_VLAN_ID_27	3
#define BM_ENET_SWI_VLAN_RES_TABLE_27_VLAN_ID_27	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_27_VLAN_ID_27(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_27_VLAN_ID_27)
#define BM_ENET_SWI_VLAN_RES_TABLE_27_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_27_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_27_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_28	(0x000082ec)

#define BP_ENET_SWI_VLAN_RES_TABLE_28_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_28_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_28_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_28_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_28_VLAN_ID_28	3
#define BM_ENET_SWI_VLAN_RES_TABLE_28_VLAN_ID_28	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_28_VLAN_ID_28(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_28_VLAN_ID_28)
#define BM_ENET_SWI_VLAN_RES_TABLE_28_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_28_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_28_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_29	(0x000082f0)

#define BP_ENET_SWI_VLAN_RES_TABLE_29_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_29_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_29_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_29_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_29_VLAN_ID_29	3
#define BM_ENET_SWI_VLAN_RES_TABLE_29_VLAN_ID_29	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_29_VLAN_ID_29(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_29_VLAN_ID_29)
#define BM_ENET_SWI_VLAN_RES_TABLE_29_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_29_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_29_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_30	(0x000082f4)

#define BP_ENET_SWI_VLAN_RES_TABLE_30_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_30_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_30_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_30_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_30_VLAN_ID_30	3
#define BM_ENET_SWI_VLAN_RES_TABLE_30_VLAN_ID_30	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_30_VLAN_ID_30(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_30_VLAN_ID_30)
#define BM_ENET_SWI_VLAN_RES_TABLE_30_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_30_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_30_PORT_0	0x00000001

#define HW_ENET_SWI_VLAN_RES_TABLE_31	(0x000082f8)

#define BP_ENET_SWI_VLAN_RES_TABLE_31_RSRVD0	15
#define BM_ENET_SWI_VLAN_RES_TABLE_31_RSRVD0	0xFFFF8000
#define BF_ENET_SWI_VLAN_RES_TABLE_31_RSRVD0(v) \
		(((v) << 15) & BM_ENET_SWI_VLAN_RES_TABLE_31_RSRVD0)
#define BP_ENET_SWI_VLAN_RES_TABLE_31_VLAN_ID_31	3
#define BM_ENET_SWI_VLAN_RES_TABLE_31_VLAN_ID_31	0x00007FF8
#define BF_ENET_SWI_VLAN_RES_TABLE_31_VLAN_ID_31(v)  \
		(((v) << 3) & BM_ENET_SWI_VLAN_RES_TABLE_31_VLAN_ID_31)
#define BM_ENET_SWI_VLAN_RES_TABLE_31_PORT_2	0x00000004
#define BM_ENET_SWI_VLAN_RES_TABLE_31_PORT_1	0x00000002
#define BM_ENET_SWI_VLAN_RES_TABLE_31_PORT_0	0x00000001

#define HW_ENET_SWI_TOTAL_DISC	(0x000082fc)

#define BP_ENET_SWI_TOTAL_DISC_TOTAL_DISC	0
#define BM_ENET_SWI_TOTAL_DISC_TOTAL_DISC	0xFFFFFFFF
#define BF_ENET_SWI_TOTAL_DISC_TOTAL_DISC(v)	(v)

#define HW_ENET_SWI_TOTAL_BYT_DISC	(0x00008300)

#define BP_ENET_SWI_TOTAL_BYT_DISC_TOTAL_BYT_DISC	0
#define BM_ENET_SWI_TOTAL_BYT_DISC_TOTAL_BYT_DISC	0xFFFFFFFF
#define BF_ENET_SWI_TOTAL_BYT_DISC_TOTAL_BYT_DISC(v)	(v)

#define HW_ENET_SWI_TOTAL_FRM	(0x00008304)

#define BP_ENET_SWI_TOTAL_FRM_TOTAL_FRM	0
#define BM_ENET_SWI_TOTAL_FRM_TOTAL_FRM	0xFFFFFFFF
#define BF_ENET_SWI_TOTAL_FRM_TOTAL_FRM(v)	(v)

#define HW_ENET_SWI_TOTAL_BYT_FRM	(0x00008308)

#define BP_ENET_SWI_TOTAL_BYT_FRM_TOTAL_BYT_FRM	0
#define BM_ENET_SWI_TOTAL_BYT_FRM_TOTAL_BYT_FRM	0xFFFFFFFF
#define BF_ENET_SWI_TOTAL_BYT_FRM_TOTAL_BYT_FRM(v)	(v)

#define HW_ENET_SWI_ODISC0	(0x0000830c)

#define BP_ENET_SWI_ODISC0_ODISC0	0
#define BM_ENET_SWI_ODISC0_ODISC0	0xFFFFFFFF
#define BF_ENET_SWI_ODISC0_ODISC0(v)	(v)

#define HW_ENET_SWI_IDISC_VLAN0	(0x00008310)

#define BP_ENET_SWI_IDISC_VLAN0_IDISC_VLAN0	0
#define BM_ENET_SWI_IDISC_VLAN0_IDISC_VLAN0	0xFFFFFFFF
#define BF_ENET_SWI_IDISC_VLAN0_IDISC_VLAN0(v)	(v)

#define HW_ENET_SWI_IDISC_UNTAGGED0	(0x00008314)

#define BP_ENET_SWI_IDISC_UNTAGGED0_IDISC_UNTAGGED0	0
#define BM_ENET_SWI_IDISC_UNTAGGED0_IDISC_UNTAGGED0	0xFFFFFFFF
#define BF_ENET_SWI_IDISC_UNTAGGED0_IDISC_UNTAGGED0(v)	(v)

#define HW_ENET_SWI_IDISC_BLOCKED0	(0x00008318)

#define BP_ENET_SWI_IDISC_BLOCKED0_IDISC_BLOCKED0	0
#define BM_ENET_SWI_IDISC_BLOCKED0_IDISC_BLOCKED0	0xFFFFFFFF
#define BF_ENET_SWI_IDISC_BLOCKED0_IDISC_BLOCKED0(v)	(v)

#define HW_ENET_SWI_ODISC1	(0x0000831c)

#define BP_ENET_SWI_ODISC1_ODISC1	0
#define BM_ENET_SWI_ODISC1_ODISC1	0xFFFFFFFF
#define BF_ENET_SWI_ODISC1_ODISC1(v)	(v)

#define HW_ENET_SWI_IDISC_VLAN1	(0x00008320)

#define BP_ENET_SWI_IDISC_VLAN1_IDISC_VLAN1	0
#define BM_ENET_SWI_IDISC_VLAN1_IDISC_VLAN1	0xFFFFFFFF
#define BF_ENET_SWI_IDISC_VLAN1_IDISC_VLAN1(v)	(v)

#define HW_ENET_SWI_IDISC_UNTAGGED1	(0x00008324)

#define BP_ENET_SWI_IDISC_UNTAGGED1_IDISC_UNTAGGED1	0
#define BM_ENET_SWI_IDISC_UNTAGGED1_IDISC_UNTAGGED1	0xFFFFFFFF
#define BF_ENET_SWI_IDISC_UNTAGGED1_IDISC_UNTAGGED1(v)	(v)

#define HW_ENET_SWI_IDISC_BLOCKED1	(0x00008328)

#define BP_ENET_SWI_IDISC_BLOCKED1_IDISC_BLOCKED1	0
#define BM_ENET_SWI_IDISC_BLOCKED1_IDISC_BLOCKED1	0xFFFFFFFF
#define BF_ENET_SWI_IDISC_BLOCKED1_IDISC_BLOCKED1(v)	(v)

#define HW_ENET_SWI_ODISC2	(0x0000832c)

#define BP_ENET_SWI_ODISC2_ODISC2	0
#define BM_ENET_SWI_ODISC2_ODISC2	0xFFFFFFFF
#define BF_ENET_SWI_ODISC2_ODISC2(v)	(v)

#define HW_ENET_SWI_IDISC_VLAN2	(0x00008330)

#define BP_ENET_SWI_IDISC_VLAN2_IDISC_VLAN2	0
#define BM_ENET_SWI_IDISC_VLAN2_IDISC_VLAN2	0xFFFFFFFF
#define BF_ENET_SWI_IDISC_VLAN2_IDISC_VLAN2(v)	(v)

#define HW_ENET_SWI_IDISC_UNTAGGED2	(0x00008334)

#define BP_ENET_SWI_IDISC_UNTAGGED2_IDISC_UNTAGGED2	0
#define BM_ENET_SWI_IDISC_UNTAGGED2_IDISC_UNTAGGED2	0xFFFFFFFF
#define BF_ENET_SWI_IDISC_UNTAGGED2_IDISC_UNTAGGED2(v)	(v)

#define HW_ENET_SWI_IDISC_BLOCKED2	(0x00008338)

#define BP_ENET_SWI_IDISC_BLOCKED2_IDISC_BLOCKED2	0
#define BM_ENET_SWI_IDISC_BLOCKED2_IDISC_BLOCKED2	0xFFFFFFFF
#define BF_ENET_SWI_IDISC_BLOCKED2_IDISC_BLOCKED2(v)	(v)

#define HW_ENET_SWI_EIR	(0x000083fc)

#define BP_ENET_SWI_EIR_RSRVD0	10
#define BM_ENET_SWI_EIR_RSRVD0	0xFFFFFC00
#define BF_ENET_SWI_EIR_RSRVD0(v) \
		(((v) << 10) & BM_ENET_SWI_EIR_RSRVD0)
#define BM_ENET_SWI_EIR_LRN	0x00000200
#define BM_ENET_SWI_EIR_OD2	0x00000100
#define BM_ENET_SWI_EIR_OD1	0x00000080
#define BM_ENET_SWI_EIR_OD0	0x00000040
#define BM_ENET_SWI_EIR_QM	0x00000020
#define BM_ENET_SWI_EIR_TXF	0x00000010
#define BM_ENET_SWI_EIR_TXB	0x00000008
#define BM_ENET_SWI_EIR_RXF	0x00000004
#define BM_ENET_SWI_EIR_RXB	0x00000002
#define BM_ENET_SWI_EIR_EBERR	0x00000001

#define HW_ENET_SWI_EIMR	(0x00008400)

#define BP_ENET_SWI_EIMR_RSRVD0	10
#define BM_ENET_SWI_EIMR_RSRVD0	0xFFFFFC00
#define BF_ENET_SWI_EIMR_RSRVD0(v) \
		(((v) << 10) & BM_ENET_SWI_EIMR_RSRVD0)
#define BM_ENET_SWI_EIMR_LRN	0x00000200
#define BM_ENET_SWI_EIMR_OD2	0x00000100
#define BM_ENET_SWI_EIMR_OD1	0x00000080
#define BM_ENET_SWI_EIMR_OD0	0x00000040
#define BM_ENET_SWI_EIMR_QM	0x00000020
#define BM_ENET_SWI_EIMR_TXF	0x00000010
#define BM_ENET_SWI_EIMR_TXB	0x00000008
#define BM_ENET_SWI_EIMR_RXF	0x00000004
#define BM_ENET_SWI_EIMR_RXB	0x00000002
#define BM_ENET_SWI_EIMR_EBERR	0x00000001

#define HW_ENET_SWI_ERDSR	(0x00008404)

#define BP_ENET_SWI_ERDSR_ERDSR	2
#define BM_ENET_SWI_ERDSR_ERDSR	0xFFFFFFFC
#define BF_ENET_SWI_ERDSR_ERDSR(v) \
		(((v) << 2) & BM_ENET_SWI_ERDSR_ERDSR)
#define BP_ENET_SWI_ERDSR_RSRVD0	0
#define BM_ENET_SWI_ERDSR_RSRVD0	0x00000003
#define BF_ENET_SWI_ERDSR_RSRVD0(v)  \
		(((v) << 0) & BM_ENET_SWI_ERDSR_RSRVD0)

#define HW_ENET_SWI_ETDSR	(0x00008408)

#define BP_ENET_SWI_ETDSR_ETDSR	2
#define BM_ENET_SWI_ETDSR_ETDSR	0xFFFFFFFC
#define BF_ENET_SWI_ETDSR_ETDSR(v) \
		(((v) << 2) & BM_ENET_SWI_ETDSR_ETDSR)
#define BP_ENET_SWI_ETDSR_RSRVD0	0
#define BM_ENET_SWI_ETDSR_RSRVD0	0x00000003
#define BF_ENET_SWI_ETDSR_RSRVD0(v)  \
		(((v) << 0) & BM_ENET_SWI_ETDSR_RSRVD0)

#define HW_ENET_SWI_EMRBR	(0x0000840c)

#define BP_ENET_SWI_EMRBR_RSRVD1	14
#define BM_ENET_SWI_EMRBR_RSRVD1	0xFFFFC000
#define BF_ENET_SWI_EMRBR_RSRVD1(v) \
		(((v) << 14) & BM_ENET_SWI_EMRBR_RSRVD1)
#define BP_ENET_SWI_EMRBR_EMRBR	4
#define BM_ENET_SWI_EMRBR_EMRBR	0x00003FF0
#define BF_ENET_SWI_EMRBR_EMRBR(v)  \
		(((v) << 4) & BM_ENET_SWI_EMRBR_EMRBR)
#define BP_ENET_SWI_EMRBR_RSRVD0	0
#define BM_ENET_SWI_EMRBR_RSRVD0	0x0000000F
#define BF_ENET_SWI_EMRBR_RSRVD0(v)  \
		(((v) << 0) & BM_ENET_SWI_EMRBR_RSRVD0)

#define HW_ENET_SWI_RDAR	(0x00008410)

#define BP_ENET_SWI_RDAR_RDAR	0
#define BM_ENET_SWI_RDAR_RDAR	0xFFFFFFFF
#define BF_ENET_SWI_RDAR_RDAR(v)	(v)

#define HW_ENET_SWI_TDAR	(0x00008414)

#define BP_ENET_SWI_TDAR_TDAR	0
#define BM_ENET_SWI_TDAR_TDAR	0xFFFFFFFF
#define BF_ENET_SWI_TDAR_TDAR(v)	(v)

#define HW_ENET_SWI_LRN_REC_0	(0x000084fc)

#define BP_ENET_SWI_LRN_REC_0_LRN_REC_0	0
#define BM_ENET_SWI_LRN_REC_0_LRN_REC_0	0xFFFFFFFF
#define BF_ENET_SWI_LRN_REC_0_LRN_REC_0(v)	(v)

#define HW_ENET_SWI_LRN_REC_1	(0x00008500)

#define BP_ENET_SWI_LRN_REC_1_RSRVD0	26
#define BM_ENET_SWI_LRN_REC_1_RSRVD0	0xFC000000
#define BF_ENET_SWI_LRN_REC_1_RSRVD0(v) \
		(((v) << 26) & BM_ENET_SWI_LRN_REC_1_RSRVD0)
#define BP_ENET_SWI_LRN_REC_1_SW_PORT	24
#define BM_ENET_SWI_LRN_REC_1_SW_PORT	0x03000000
#define BF_ENET_SWI_LRN_REC_1_SW_PORT(v)  \
		(((v) << 24) & BM_ENET_SWI_LRN_REC_1_SW_PORT)
#define BP_ENET_SWI_LRN_REC_1_HASH	16
#define BM_ENET_SWI_LRN_REC_1_HASH	0x00FF0000
#define BF_ENET_SWI_LRN_REC_1_HASH(v)  \
		(((v) << 16) & BM_ENET_SWI_LRN_REC_1_HASH)
#define BP_ENET_SWI_LRN_REC_1_MAC_ADDR1	0
#define BM_ENET_SWI_LRN_REC_1_MAC_ADDR1	0x0000FFFF
#define BF_ENET_SWI_LRN_REC_1_MAC_ADDR1(v)  \
		(((v) << 0) & BM_ENET_SWI_LRN_REC_1_MAC_ADDR1)

#define HW_ENET_SWI_LRN_STATUS	(0x00008504)

#define BP_ENET_SWI_LRN_STATUS_RSRVD0	1
#define BM_ENET_SWI_LRN_STATUS_RSRVD0	0xFFFFFFFE
#define BF_ENET_SWI_LRN_STATUS_RSRVD0(v) \
		(((v) << 1) & BM_ENET_SWI_LRN_STATUS_RSRVD0)
#define BM_ENET_SWI_LRN_STATUS_LRN_STATUS	0x00000001

#define HW_ENET_SWI_LOOKUP_MEMORY_START	(0x0000bffc)

#define BP_ENET_SWI_LOOKUP_MEMORY_START_MEMORY_DATA	0
#define BM_ENET_SWI_LOOKUP_MEMORY_START_MEMORY_DATA	0xFFFFFFFF
#define BF_ENET_SWI_LOOKUP_MEMORY_START_MEMORY_DATA(v)	(v)

#define HW_ENET_SWI_LOOKUP_MEMORY_END	(0x0000fff8)

#define BP_ENET_SWI_LOOKUP_MEMORY_END_MEMORY_DATA	0
#define BM_ENET_SWI_LOOKUP_MEMORY_END_MEMORY_DATA	0xFFFFFFFF
#define BF_ENET_SWI_LOOKUP_MEMORY_END_MEMORY_DATA(v)	(v)
#endif /* __ARCH_ARM___ENET_H */
