/*
 * Freescale GPMI NFC NAND Flash Driver
 *
 * Copyright 2008-2010 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * Xml Revision: 2.2
 * Template revision: 26195
 */

#ifndef __GPMI_NFC_GPMI_REGS_H
#define __GPMI_NFC_GPMI_REGS_H

/*============================================================================*/

#define HW_GPMI_CTRL0			0x00000000
#define HW_GPMI_CTRL0_SET		0x00000004
#define HW_GPMI_CTRL0_CLR		0x00000008
#define HW_GPMI_CTRL0_TOG		0x0000000c

#define BM_GPMI_CTRL0_SFTRST		(1 << 31)
#define BV_GPMI_CTRL0_SFTRST__RUN	0x0
#define BV_GPMI_CTRL0_SFTRST__RESET	0x1
#define BM_GPMI_CTRL0_CLKGATE		(1 << 30)
#define BV_GPMI_CTRL0_CLKGATE__RUN	0x0
#define BV_GPMI_CTRL0_CLKGATE__NO_CLKS	0x1
#define BM_GPMI_CTRL0_RUN		(1 << 29)
#define BV_GPMI_CTRL0_RUN__IDLE		0x0
#define BV_GPMI_CTRL0_RUN__BUSY		0x1
#define BM_GPMI_CTRL0_DEV_IRQ_EN	(1 << 28)
/* V0 */
#define BM_GPMI_CTRL0_TIMEOUT_IRQ_EN	(1 << 27)
/* V1 */
#define BM_GPMI_CTRL0_LOCK_CS_V1	(1 << 27)

#define BM_GPMI_CTRL0_UDMA		(1 << 26)
#define BP_GPMI_CTRL0_COMMAND_MODE	24
#define BM_GPMI_CTRL0_COMMAND_MODE	(0x3 << BP_GPMI_CTRL0_COMMAND_MODE)
#define BF_GPMI_CTRL0_COMMAND_MODE(v)			\
	(((v) << 24) & BM_GPMI_CTRL0_COMMAND_MODE)
#define BV_GPMI_CTRL0_COMMAND_MODE__WRITE	     0x0
#define BV_GPMI_CTRL0_COMMAND_MODE__READ	     0x1
#define BV_GPMI_CTRL0_COMMAND_MODE__READ_AND_COMPARE 0x2
#define BV_GPMI_CTRL0_COMMAND_MODE__WAIT_FOR_READY   0x3
#define BP_GPMI_CTRL0_WORD_LENGTH	23
#define BM_GPMI_CTRL0_WORD_LENGTH	(1 << BP_GPMI_CTRL0_WORD_LENGTH)
#define BV_GPMI_CTRL0_WORD_LENGTH__16_BIT (0x0 << BP_GPMI_CTRL0_WORD_LENGTH)
#define BV_GPMI_CTRL0_WORD_LENGTH__8_BIT  (0x1 << BP_GPMI_CTRL0_WORD_LENGTH__8_BIT)
#define BP_GPMI_CTRL0_CS		20
/* V0 */
#define BM_GPMI_CTRL0_LOCK_CS		(1 << 22)
#define BM_GPMI_CTRL0_CS		(0x3 << BP_GPMI_CTRL0_CS)
#define BF_GPMI_CTRL0_CS(v)		(((v) << BP_GPMI_CTRL0_CS) & BM_GPMI_CTRL0_CS)
/* V1 */
#define BM_GPMI_CTRL0_CS_V1		(0x7 << BP_GPMI_CTRL0_CS)
#define BF_GPMI_CTRL0_CS_V1(v)		(((v) << BP_GPMI_CTRL0_CS) & BM_GPMI_CTRL0_CS_V1)

#define BP_GPMI_CTRL0_ADDRESS		17
#define BM_GPMI_CTRL0_ADDRESS		(0x7 << BP_GPMI_CTRL0_ADDRESS)
#define BF_GPMI_CTRL0_ADDRESS(v)  (((v) << 17) & BM_GPMI_CTRL0_ADDRESS)
#define BV_GPMI_CTRL0_ADDRESS__NAND_DATA 0x0
#define BV_GPMI_CTRL0_ADDRESS__NAND_CLE	 0x1
#define BV_GPMI_CTRL0_ADDRESS__NAND_ALE	 0x2
#define BM_GPMI_CTRL0_ADDRESS_INCREMENT	 (1 << 16)
#define BP_GPMI_CTRL0_XFER_COUNT	0
#define BM_GPMI_CTRL0_XFER_COUNT	(0xFFFF << BP_GPMI_CTRL0_XFER_COUNT)
#define BF_GPMI_CTRL0_XFER_COUNT(v)  \
	(((v) << 0) & BM_GPMI_CTRL0_XFER_COUNT)

/*============================================================================*/

#define HW_GPMI_COMPARE			0x00000010

#define BP_GPMI_COMPARE_MASK		16
#define BM_GPMI_COMPARE_MASK		(0xFFFF << BP_GPMI_COMPARE_MASK)
#define BF_GPMI_COMPARE_MASK(v)		(((v) << 16) & BM_GPMI_COMPARE_MASK)
#define BP_GPMI_COMPARE_REFERENCE	0
#define BM_GPMI_COMPARE_REFERENCE	(0xFFFF << BP_GPMI_COMPARE_REFERENCE)
#define BF_GPMI_COMPARE_REFERENCE(v)	(((v) << 0) & BM_GPMI_COMPARE_REFERENCE)

/*============================================================================*/

#define HW_GPMI_ECCCTRL				0x00000020
#define HW_GPMI_ECCCTRL_SET			0x00000024
#define HW_GPMI_ECCCTRL_CLR			0x00000028
#define HW_GPMI_ECCCTRL_TOG			0x0000002c

#define BP_GPMI_ECCCTRL_HANDLE			16
#define BM_GPMI_ECCCTRL_HANDLE			(0xFFFF << BP_GPMI_ECCCTRL_HANDLE)
#define BF_GPMI_ECCCTRL_HANDLE(v)		(((v) << BP_GPMI_ECCCTRL_HANDLE) & BM_GPMI_ECCCTRL_HANDLE)
#define BP_GPMI_ECCCTRL_ECC_CMD			13
#define BM_GPMI_ECCCTRL_ECC_CMD			(3 << BP_GPMI_ECCCTRL_ECC_CMD)
#define BF_GPMI_ECCCTRL_ECC_CMD(v)		(((v) << BP_GPMI_ECCCTRL_ECC_CMD) & BM_GPMI_ECCCTRL_ECC_CMD)
/* V0 */
#define BV_GPMI_ECCCTRL_ECC_CMD__DECODE_4_BIT	0x0
#define BV_GPMI_ECCCTRL_ECC_CMD__ENCODE_4_BIT	0x1
#define BV_GPMI_ECCCTRL_ECC_CMD__DECODE_8_BIT	0x2
#define BV_GPMI_ECCCTRL_ECC_CMD__ENCODE_8_BIT	0x3
#define BV_GPMI_ECCCTRL_ECC_CMD__BCH_DECODE	0x0
#define BV_GPMI_ECCCTRL_ECC_CMD__BCH_ENCODE	0x1
/* V1 */
#define BV_GPMI_ECCCTRL_ECC_CMD__DECODE		0x0
#define BV_GPMI_ECCCTRL_ECC_CMD__ENCODE		0x1

#define BM_GPMI_ECCCTRL_ENABLE_ECC		(1 << 12)
#define BP_GPMI_ECCCTRL_BUFFER_MASK		0
#define BM_GPMI_ECCCTRL_BUFFER_MASK		(0x1FF << BP_GPMI_ECCCTRL_BUFFER_MASK)
#define BF_GPMI_ECCCTRL_BUFFER_MASK(v)		(((v) << 0) & BM_GPMI_ECCCTRL_BUFFER_MASK)
#define BV_GPMI_ECCCTRL_BUFFER_MASK__BCH_AUXONLY 0x100
#define BV_GPMI_ECCCTRL_BUFFER_MASK__BCH_PAGE	 0x1FF
/* V0 */
#define BV_GPMI_ECCCTRL_BUFFER_MASK__AUXILIARY	 0x100
#define BV_GPMI_ECCCTRL_BUFFER_MASK__BUFFER7	 0x080
#define BV_GPMI_ECCCTRL_BUFFER_MASK__BUFFER6	 0x040
#define BV_GPMI_ECCCTRL_BUFFER_MASK__BUFFER5	 0x020
#define BV_GPMI_ECCCTRL_BUFFER_MASK__BUFFER4	 0x010
#define BV_GPMI_ECCCTRL_BUFFER_MASK__BUFFER3	 0x008
#define BV_GPMI_ECCCTRL_BUFFER_MASK__BUFFER2	 0x004
#define BV_GPMI_ECCCTRL_BUFFER_MASK__BUFFER1	 0x002
#define BV_GPMI_ECCCTRL_BUFFER_MASK__BUFFER0	 0x001

/*============================================================================*/

#define HW_GPMI_ECCCOUNT			0x00000030

#define BP_GPMI_ECCCOUNT_COUNT			0
#define BM_GPMI_ECCCOUNT_COUNT			0x0000FFFF
#define BF_GPMI_ECCCOUNT_COUNT(v)		(((v) << 0) & BM_GPMI_ECCCOUNT_COUNT)

/*============================================================================*/

#define HW_GPMI_PAYLOAD				0x00000040

#define BP_GPMI_PAYLOAD_ADDRESS			2
#define BM_GPMI_PAYLOAD_ADDRESS			0xFFFFFFFC
#define BF_GPMI_PAYLOAD_ADDRESS(v)		(((v) << 2) & BM_GPMI_PAYLOAD_ADDRESS)

/*============================================================================*/

#define HW_GPMI_AUXILIARY			0x00000050

#define BP_GPMI_AUXILIARY_ADDRESS		2
#define BM_GPMI_AUXILIARY_ADDRESS		0xFFFFFFFC
#define BF_GPMI_AUXILIARY_ADDRESS(v)		(((v) << 2) & BM_GPMI_AUXILIARY_ADDRESS)

/*============================================================================*/

#define HW_GPMI_CTRL1				0x00000060
#define HW_GPMI_CTRL1_SET			0x00000064
#define HW_GPMI_CTRL1_CLR			0x00000068
#define HW_GPMI_CTRL1_TOG			0x0000006c

/* V0 */
#define BM_GPMI_CTRL1_CE3_SEL			(1 << 23)
#define BM_GPMI_CTRL1_CE2_SEL			(1 << 22)
#define BM_GPMI_CTRL1_CE1_SEL			(1 << 21)
#define BM_GPMI_CTRL1_CE0_SEL			(1 << 20)
/* V1 */
#define BM_GPMI_CTRL1_DECOUPLE_CS		(1 << 24)
#define BP_GPMI_CTRL1_WRN_DLY_SEL		22
#define BM_GPMI_CTRL1_WRN_DLY_SEL		(3 << BP_GPMI_CTRL1_WRN_DLY_SEL)
#define BF_GPMI_CTRL1_WRN_DLY_SEL(v)		(((v) << BP_GPMI_CTRL1_WRN_DLY_SEL) & BM_GPMI_CTRL1_WRN_DLY_SEL)
#define BM_GPMI_CTRL1_TIMEOUT_IRQ_EN		(1 << 20)

#define BM_GPMI_CTRL1_GANGED_RDYBUSY		(1 << 19)
/* V0 */
#define BP_GPMI_CTRL1_RDN_DELAY			12
#define BM_GPMI_CTRL1_RDN_DELAY			(0xf << BP_GPMI_CTRL1_RDN_DELAY)

#define BM_GPMI_CTRL1_BCH_MODE			(1 << 18)
#define BP_GPMI_CTRL1_DLL_ENABLE		17
#define BM_GPMI_CTRL1_DLL_ENABLE		(1 << BP_GPMI_CTRL1_DLL_ENABLE)
#define BP_GPMI_CTRL1_HALF_PERIOD		16
#define BM_GPMI_CTRL1_HALF_PERIOD		(1 << BP_GPMI_CTRL1_HALF_PERIOD)
#define BP_GPMI_CTRL1_RDN_DELAY			12
#define BM_GPMI_CTRL1_RDN_DELAY			(0xf << BP_GPMI_CTRL1_RDN_DELAY)
#define BF_GPMI_CTRL1_RDN_DELAY(v)		(((v) << 12) & BM_GPMI_CTRL1_RDN_DELAY)
#define BM_GPMI_CTRL1_DMA2ECC_MODE		(1 << 11)
#define BM_GPMI_CTRL1_DEV_IRQ			(1 << 10)
#define BM_GPMI_CTRL1_TIMEOUT_IRQ		(1 << 9)
#define BM_GPMI_CTRL1_BURST_EN			(1 << 8)
/* V0 */
#define BM_GPMI_CTRL1_ABORT_WAIT_FOR_READY3	(1 << 7)
#define BM_GPMI_CTRL1_ABORT_WAIT_FOR_READY2	(1 << 6)
#define BM_GPMI_CTRL1_ABORT_WAIT_FOR_READY1	(1 << 5)
#define BM_GPMI_CTRL1_ABORT_WAIT_FOR_READY0	(1 << 4)
/* V1 */
#define BM_GPMI_CTRL1_ABORT_WAIT_REQUEST	(1 << 7)
#define BP_GPMI_CTRL1_ABORT_WAIT_FOR_READY_CHANNEL	4
#define BM_GPMI_CTRL1_ABORT_WAIT_FOR_READY_CHANNEL	(0x7 << BP_GPMI_CTRL1_ABORT_WAIT_FOR_READY_CHANNEL)
#define BF_GPMI_CTRL1_ABORT_WAIT_FOR_READY_CHANNEL(v)  \
		(((v) << BP_GPMI_CTRL1_ABORT_WAIT_FOR_READY_CHANNEL) & BM_GPMI_CTRL1_ABORT_WAIT_FOR_READY_CHANNEL)

#define BM_GPMI_CTRL1_DEV_RESET			(1 << 3)
#define BM_GPMI_CTRL1_ATA_IRQRDY_POLARITY	(1 << 2)
#define BV_GPMI_CTRL1_ATA_IRQRDY_POLARITY__ACTIVELOW  0x0
#define BV_GPMI_CTRL1_ATA_IRQRDY_POLARITY__ACTIVEHIGH 0x1
#define BM_GPMI_CTRL1_CAMERA_MODE		(1 << 1)
#define BP_GPMI_CTRL1_GPMI_MODE			0
#define BM_GPMI_CTRL1_GPMI_MODE			(0x1 << BP_GPMI_CTRL1_GPMI_MODE)
#define BV_GPMI_CTRL1_GPMI_MODE__NAND		(0x0 << BP_GPMI_CTRL1_GPMI_MODE)
#define BV_GPMI_CTRL1_GPMI_MODE__ATA		(0x1 << BP_GPMI_CTRL1_GPMI_MODE)

/*============================================================================*/

#define HW_GPMI_TIMING0				0x00000070

#define BP_GPMI_TIMING0_ADDRESS_SETUP		16
#define BM_GPMI_TIMING0_ADDRESS_SETUP		0x00FF0000
#define BF_GPMI_TIMING0_ADDRESS_SETUP(v)  \
		(((v) << 16) & BM_GPMI_TIMING0_ADDRESS_SETUP)
#define BP_GPMI_TIMING0_DATA_HOLD		8
#define BM_GPMI_TIMING0_DATA_HOLD		0x0000FF00
#define BF_GPMI_TIMING0_DATA_HOLD(v)  \
		(((v) << 8) & BM_GPMI_TIMING0_DATA_HOLD)
#define BP_GPMI_TIMING0_DATA_SETUP		0
#define BM_GPMI_TIMING0_DATA_SETUP		0x000000FF
#define BF_GPMI_TIMING0_DATA_SETUP(v)  \
		(((v) << 0) & BM_GPMI_TIMING0_DATA_SETUP)

/*============================================================================*/

#define HW_GPMI_TIMING1				0x00000080

#define BP_GPMI_TIMING1_DEVICE_BUSY_TIMEOUT	16
#define BM_GPMI_TIMING1_DEVICE_BUSY_TIMEOUT	0xFFFF0000
#define BF_GPMI_TIMING1_DEVICE_BUSY_TIMEOUT(v) \
		(((v) << 16) & BM_GPMI_TIMING1_DEVICE_BUSY_TIMEOUT)

/*============================================================================*/

#define HW_GPMI_TIMING2				0x00000090

#define BP_GPMI_TIMING2_UDMA_TRP		24
#define BM_GPMI_TIMING2_UDMA_TRP		0xFF000000
#define BF_GPMI_TIMING2_UDMA_TRP(v) \
		(((v) << 24) & BM_GPMI_TIMING2_UDMA_TRP)
#define BP_GPMI_TIMING2_UDMA_ENV		16
#define BM_GPMI_TIMING2_UDMA_ENV		0x00FF0000
#define BF_GPMI_TIMING2_UDMA_ENV(v)  \
		(((v) << 16) & BM_GPMI_TIMING2_UDMA_ENV)
#define BP_GPMI_TIMING2_UDMA_HOLD		8
#define BM_GPMI_TIMING2_UDMA_HOLD		0x0000FF00
#define BF_GPMI_TIMING2_UDMA_HOLD(v)  \
		(((v) << 8) & BM_GPMI_TIMING2_UDMA_HOLD)
#define BP_GPMI_TIMING2_UDMA_SETUP		0
#define BM_GPMI_TIMING2_UDMA_SETUP		0x000000FF
#define BF_GPMI_TIMING2_UDMA_SETUP(v)  \
		(((v) << 0) & BM_GPMI_TIMING2_UDMA_SETUP)

/*============================================================================*/

#define HW_GPMI_DATA				0x000000a0
#define HW_GPMI_STAT				0x000000b0

/* V0 */
#define BM_GPMI_STAT_PRESENT			(1 << 31)
#define BP_GPMI_STAT_RDY_TIMEOUT		8
#define BM_GPMI_STAT_RDY_TIMEOUT		(0xf << BP_GPMI_STAT_RDY_TIMEOUT)
#define BF_GPMI_STAT_RDY_TIMEOUT(v)  \
		(((v) << BP_GPMI_STAT_RDY_TIMEOUT) & BM_GPMI_STAT_RDY_TIMEOUT)
#define BM_GPMI_STAT_ATA_IRQ			(1 << 7)
#define BM_GPMI_STAT_INVALID_BUFFER_MASK	(1 << 6)
#define BM_GPMI_STAT_FIFO_EMPTY			(1 << 5)
#define BM_GPMI_STAT_FIFO_FULL			(1 << 4)
#define BM_GPMI_STAT_DEV3_ERROR			(1 << 3)
#define BM_GPMI_STAT_DEV2_ERROR			(1 << 2)
#define BM_GPMI_STAT_DEV1_ERROR			(1 << 1)
#define BM_GPMI_STAT_DEERROR			(1 << 0)
/* V1 */
#define BP_GPMI_STAT_READY_BUSY			24
#define BM_GPMI_STAT_READY_BUSY			(0xFF << BP_GPMI_STAT_READY_BUSY)
#define BF_GPMI_STAT_READY_BUSY(v) \
		(((v) << BP_GPMI_STAT_READY_BUSY) & BM_GPMI_STAT_READY_BUSY)
#define BP_GPMI_STAT_RDY_TIMEOUT_V1		16
#define BM_GPMI_STAT_RDY_TIMEOUT_V1		(0xFF << BP_GPMI_STAT_RDY_TIMEOUT_V1)
#define BF_GPMI_STAT_RDY_TIMEOUT_V1(v)		(((v) << BM_GPMI_STAT_RDY_TIMEOUT_V1) & BM_GPMI_STAT_RDY_TIMEOUT_V1)
#define BM_GPMI_STAT_DEV7_ERROR			(1 << 15)
#define BM_GPMI_STAT_DEV6_ERROR			(1 << 14)
#define BM_GPMI_STAT_DEV5_ERROR			(1 << 13)
#define BM_GPMI_STAT_DEV4_ERROR			(1 << 12)
#define BM_GPMI_STAT_DEV3_ERROR_V1		(1 << 11)
#define BM_GPMI_STAT_DEV2_ERROR_V1		(1 << 10)
#define BM_GPMI_STAT_DEERROR_V1			(1 << 9)
#define BM_GPMI_STAT_DEV0_ERROR			(1 << 5)
#define BM_GPMI_STAT_ATA_IRQ_V1			(1 << 4)
#define BM_GPMI_STAT_INVALID_BUFFER_MASK_V1	(1 << 3)
#define BM_GPMI_STAT_FIFO_EMPTY_V1		(1 << 2)
#define BM_GPMI_STAT_FIFO_FULL_V1		(1 << 1)
#define BM_GPMI_STAT_PRESENT_V1			(1 << 0)

/*============================================================================*/

#define HW_GPMI_DEBUG				0x000000c0

/* V0 */
#define BM_GPMI_DEBUG_READY3			(1 << 31)
#define BM_GPMI_DEBUG_READY2			(1 << 30)
#define BM_GPMI_DEBUG_READY1			(1 << 29)
#define BM_GPMI_DEBUG_READY0			(1 << 28)
#define BM_GPMI_DEBUG_WAIT_FOR_READY_END3	(1 << 27)
#define BM_GPMI_DEBUG_WAIT_FOR_READY_END2	(1 << 26)
#define BM_GPMI_DEBUG_WAIT_FOR_READY_END1	(1 << 25)
#define BM_GPMI_DEBUG_WAIT_FOR_READY_END0	(1 << 24)
#define BM_GPMI_DEBUG_SENSE3			(1 << 23)
#define BM_GPMI_DEBUG_SENSE2			(1 << 22)
#define BM_GPMI_DEBUG_SENSE1			(1 << 21)
#define BM_GPMI_DEBUG_SENSE0			(1 << 20)
#define BM_GPMI_DEBUG_DMAREQ3			(1 << 19)
#define BM_GPMI_DEBUG_DMAREQ2			(1 << 18)
#define BM_GPMI_DEBUG_DMAREQ1			(1 << 17)
#define BM_GPMI_DEBUG_DMAREQ0			(1 << 16)
#define BP_GPMI_DEBUG_CMD_END			(1 << 12)
#define BM_GPMI_DEBUG_CMD_END			(0xF << BP_GPMI_DEBUG_CMD_END)
#define BF_GPMI_DEBUG_CMD_END(v)  \
		(((v) << BP_GPMI_DEBUG_CMD_END) & BM_GPMI_DEBUG_CMD_END)
#define BP_GPMI_DEBUG_UDMA_STATE		8
#define BM_GPMI_DEBUG_UDMA_STATE		(0xf << BP_GPMI_DEBUG_UDMA_STATE)
#define BF_GPMI_DEBUG_UDMA_STATE(v)  \
		(((v) << BP_GPMI_DEBUG_UDMA_STATE) & BM_GPMI_DEBUG_UDMA_STATE)
#define BM_GPMI_DEBUG_BUSY			(1 << 7)
#define BP_GPMI_DEBUG_PIN_STATE			4
#define BM_GPMI_DEBUG_PIN_STATE			(0x7 << BP_GPMI_DEBUG_PIN_STATE)
#define BF_GPMI_DEBUG_PIN_STATE(v)  \
		(((v) << BP_GPMI_DEBUG_PIN_STATE) & BM_GPMI_DEBUG_PIN_STATE)
#define BV_GPMI_DEBUG_PIN_STATE__PSM_IDLE	0x0
#define BV_GPMI_DEBUG_PIN_STATE__PSM_BYTCNT	0x1
#define BV_GPMI_DEBUG_PIN_STATE__PSM_ADDR	0x2
#define BV_GPMI_DEBUG_PIN_STATE__PSM_STALL	0x3
#define BV_GPMI_DEBUG_PIN_STATE__PSM_STROBE	0x4
#define BV_GPMI_DEBUG_PIN_STATE__PSM_ATARDY	0x5
#define BV_GPMI_DEBUG_PIN_STATE__PSM_DHOLD	0x6
#define BV_GPMI_DEBUG_PIN_STATE__PSM_DONE	0x7
#define BP_GPMI_DEBUG_MAIN_STATE		0
#define BM_GPMI_DEBUG_MAIN_STATE		(0xF << BP_GPMI_DEBUG_MAIN_STATE)
#define BF_GPMI_DEBUG_MAIN_STATE(v)  \
		(((v) << BP_GPMI_DEBUG_MAIN_STATE) & BM_GPMI_DEBUG_MAIN_STATE)
#define BV_GPMI_DEBUG_MAIN_STATE__MSM_IDLE	0x0
#define BV_GPMI_DEBUG_MAIN_STATE__MSM_BYTCNT	0x1
#define BV_GPMI_DEBUG_MAIN_STATE__MSM_WAITFE	0x2
#define BV_GPMI_DEBUG_MAIN_STATE__MSM_WAITFR	0x3
#define BV_GPMI_DEBUG_MAIN_STATE__MSM_DMAREQ	0x4
#define BV_GPMI_DEBUG_MAIN_STATE__MSM_DMAACK	0x5
#define BV_GPMI_DEBUG_MAIN_STATE__MSM_WAITFF	0x6
#define BV_GPMI_DEBUG_MAIN_STATE__MSM_LDFIFO	0x7
#define BV_GPMI_DEBUG_MAIN_STATE__MSM_LDDMAR	0x8
#define BV_GPMI_DEBUG_MAIN_STATE__MSM_RDCMP	0x9
#define BV_GPMI_DEBUG_MAIN_STATE__MSM_DONE	0xA
/* V1 */
#define BP_GPMI_DEBUG_WAIT_FOR_READY_END	24
#define BM_GPMI_DEBUG_WAIT_FOR_READY_END	(0xFF << BP_GPMI_DEBUG_WAIT_FOR_READY_END)
#define BF_GPMI_DEBUG_WAIT_FOR_READY_END(v) \
		(((v) << BP_GPMI_DEBUG_WAIT_FOR_READY_END) & BM_GPMI_DEBUG_WAIT_FOR_READY_END)
#define BP_GPMI_DEBUG_DMA_SENSE			16
#define BM_GPMI_DEBUG_DMA_SENSE			(0xFF << BP_GPMI_DEBUG_DMA_SENSE)
#define BF_GPMI_DEBUG_DMA_SENSE(v)  \
		(((v) << BP_GPMI_DEBUG_DMA_SENSE) & BM_GPMI_DEBUG_DMA_SENSE)
#define BP_GPMI_DEBUG_DMAREQ			8
#define BM_GPMI_DEBUG_DMAREQ			(0xFF << BP_GPMI_DEBUG_DMAREQ)
#define BF_GPMI_DEBUG_DMAREQ(v)  \
		(((v) << BP_GPMI_DEBUG_DMAREQ) & BM_GPMI_DEBUG_DMAREQ)
#define BP_GPMI_DEBUG_CMD_END_V1		0
#define BM_GPMI_DEBUG_CMD_END_V1		(0xFF << BP_GPMI_DEBUG_CMD_END)
#define BF_GPMI_DEBUG_CMD_END_V1(v)  \
		(((v) << BP_GPMI_DEBUG_CMD_END) & BM_GPMI_DEBUG_CMD_END)

/*============================================================================*/

#define HW_GPMI_VERSION				0x000000d0

#define BP_GPMI_VERSION_MAJOR			24
#define BM_GPMI_VERSION_MAJOR			(0xFF << BP_GPMI_VERSION_MAJOR)
#define BF_GPMI_VERSION_MAJOR(v)		(((v) << BP_GPMI_VERSION_MAJOR) & BM_GPMI_VERSION_MAJOR)
#define BP_GPMI_VERSION_MINOR			16
#define BM_GPMI_VERSION_MINOR			(0xFF << BP_GPMI_VERSION_MINOR)
#define BF_GPMI_VERSION_MINOR(v)		(((v) << BP_GPMI_VERSION_MINOR) & BM_GPMI_VERSION_MINOR)
#define BP_GPMI_VERSION_STEP			0
#define BM_GPMI_VERSION_STEP			(0xFFFF << BP_GPMI_VERSION_STEP)
#define BF_GPMI_VERSION_STEP(v)			(((v) << BP_GPMI_VERSION_STEP) & BM_GPMI_VERSION_STEP)

/*============================================================================*/

#define HW_GPMI_DEBUG2				0x000000e0

/* V1 */
#define BP_GPMI_DEBUG2_UDMA_STATE		24
#define BM_GPMI_DEBUG2_UDMA_STATE		(0xF << BP_GPMI_DEBUG2_UDMA_STATE)
#define BF_GPMI_DEBUG2_UDMA_STATE(v)  \
		(((v) << BP_GPMI_DEBUG2_UDMA_STATE) & BM_GPMI_DEBUG2_UDMA_STATE)
#define BM_GPMI_DEBUG2_BUSY			(1 << 23)
#define BP_GPMI_DEBUG2_PIN_STATE		20
#define BM_GPMI_DEBUG2_PIN_STATE		(0x7 << BP_GPMI_DEBUG2_PIN_STATE)
#define BF_GPMI_DEBUG2_PIN_STATE(v)  \
		(((v) << BP_GPMI_DEBUG2_PIN_STATE) & BM_GPMI_DEBUG2_PIN_STATE)
#define BV_GPMI_DEBUG2_PIN_STATE__PSM_IDLE	0x0
#define BV_GPMI_DEBUG2_PIN_STATE__PSM_BYTCNT	0x1
#define BV_GPMI_DEBUG2_PIN_STATE__PSM_ADDR	0x2
#define BV_GPMI_DEBUG2_PIN_STATE__PSM_STALL	0x3
#define BV_GPMI_DEBUG2_PIN_STATE__PSM_STROBE	0x4
#define BV_GPMI_DEBUG2_PIN_STATE__PSM_ATARDY	0x5
#define BV_GPMI_DEBUG2_PIN_STATE__PSM_DHOLD	0x6
#define BV_GPMI_DEBUG2_PIN_STATE__PSM_DONE	0x7
#define BP_GPMI_DEBUG2_MAIN_STATE		16
#define BM_GPMI_DEBUG2_MAIN_STATE		(0xF << BP_GPMI_DEBUG2_MAIN_STATE)
#define BF_GPMI_DEBUG2_MAIN_STATE(v)  \
		(((v) << BP_GPMI_DEBUG2_MAIN_STATE) & BM_GPMI_DEBUG2_MAIN_STATE)
#define BV_GPMI_DEBUG2_MAIN_STATE__MSM_IDLE	0x0
#define BV_GPMI_DEBUG2_MAIN_STATE__MSM_BYTCNT	0x1
#define BV_GPMI_DEBUG2_MAIN_STATE__MSM_WAITFE	0x2
#define BV_GPMI_DEBUG2_MAIN_STATE__MSM_WAITFR	0x3
#define BV_GPMI_DEBUG2_MAIN_STATE__MSM_DMAREQ	0x4
#define BV_GPMI_DEBUG2_MAIN_STATE__MSM_DMAACK	0x5
#define BV_GPMI_DEBUG2_MAIN_STATE__MSM_WAITFF	0x6
#define BV_GPMI_DEBUG2_MAIN_STATE__MSM_LDFIFO	0x7
#define BV_GPMI_DEBUG2_MAIN_STATE__MSM_LDDMAR	0x8
#define BV_GPMI_DEBUG2_MAIN_STATE__MSM_RDCMP	0x9
#define BV_GPMI_DEBUG2_MAIN_STATE__MSM_DONE	0xA
#define BP_GPMI_DEBUG2_SYND2GPMI_BE		12
#define BM_GPMI_DEBUG2_SYND2GPMI_BE		(0xF << BP_GPMI_DEBUG2_SYND2GPMI_BE)
#define BF_GPMI_DEBUG2_SYND2GPMI_BE(v)		(((v) << BP_GPMI_DEBUG2_SYND2GPMI_BE) & BM_GPMI_DEBUG2_SYND2GPMI_BE)
#define BM_GPMI_DEBUG2_GPMI2SYND_VALID		(1 << 11)
#define BM_GPMI_DEBUG2_GPMI2SYND_READY		(1 << 10)
#define BM_GPMI_DEBUG2_SYND2GPMI_VALID		(1 << 9)
#define BM_GPMI_DEBUG2_SYND2GPMI_READY		(1 << 8)
#define BM_GPMI_DEBUG2_VIEW_DELAYED_RDN		(1 << 7)
#define BM_GPMI_DEBUG2_UPDATE_WINDOW		(1 << 6)
#define BP_GPMI_DEBUG2_RDN_TAP			0
#define BM_GPMI_DEBUG2_RDN_TAP			(0x3F << BP_GPMI_DEBUG2_RDN_TAP)
#define BF_GPMI_DEBUG2_RDN_TAP(v)		(((v) << BP_GPMI_DEBUG2_RDN_TAP) & BM_GPMI_DEBUG2_RDN_TAP)

/*============================================================================*/

#define HW_GPMI_DEBUG3				0x000000f0

#define BP_GPMI_DEBUG3_APB_WORD_CNTR		16
#define BM_GPMI_DEBUG3_APB_WORD_CNTR		(0xFFFF << BP_GPMI_DEBUG3_APB_WORD_CNTR)
#define BF_GPMI_DEBUG3_APB_WORD_CNTR(v)		(((v) << )BP_GPMI_DEBUG3_APB_WORD_CNTR & BM_GPMI_DEBUG3_APB_WORD_CNTR)
#define BP_GPMI_DEBUG3_DEV_WORD_CNTR		0
#define BM_GPMI_DEBUG3_DEV_WORD_CNTR		(0xFFFF << BP_GPMI_DEBUG3_DEV_WORD_CNTR)
#define BF_GPMI_DEBUG3_DEV_WORD_CNTR(v)		(((v) << BP_GPMI_DEBUG3_DEV_WORD_CNTR) & BM_GPMI_DEBUG3_DEV_WORD_CNTR)

/*============================================================================*/
#endif
