/*
 * Freescale GPMI NFC NAND Flash Driver
 *
 * Copyright 2008-2010 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * Xml Revision: 2.5
 * Template revision: 26195
 */

#ifndef __GPMI_NFC_BCH_REGS_H
#define __GPMI_NFC_BCH_REGS_H

#define HW_BCH_CTRL				0x000
#define HW_BCH_CTRL_SET				0x004
#define HW_BCH_CTRL_CLR				0x008
#define HW_BCH_CTRL_TOG				0x00c

#define BM_BCH_CTRL_SFTRST			(1 << 31)
#define BM_BCH_CTRL_CLKGATE			(1 << 30)
#define BM_BCH_CTRL_DEBUGSYNDROME		(1 << 22)
#define BP_BCH_CTRL_M2M_LAYOUT			18
#define BM_BCH_CTRL_M2M_LAYOUT			(1 << BP_BCH_CTRL_M2M_LAYOUT)
#define BF_BCH_CTRL_M2M_LAYOUT(v)		(((v) << BP_BCH_CTRL_M2M_LAYOUT) & BM_BCH_CTRL_M2M_LAYOUT)
#define BM_BCH_CTRL_M2M_ENCODE			(1 << 17)
#define BM_BCH_CTRL_M2M_ENABLE			(1 << 16)
#define BM_BCH_CTRL_DEBUG_STALL_IRQ_EN		(1 << 10)
#define BM_BCH_CTRL_COMPLETE_IRQ_EN		(1 << 8)
#define BM_BCH_CTRL_BM_ERROR_IRQ		(1 << 3)
#define BM_BCH_CTRL_DEBUG_STALL_IRQ		(1 << 2)
#define BM_BCH_CTRL_COMPLETE_IRQ		(1 << 0)

#define HW_BCH_STATUS0				0x010

#define BP_BCH_STATUS0_HANDLE			20
#define BM_BCH_STATUS0_HANDLE			(0xFFF << BP_BCH_STATUS0_HANDLE)
#define BF_BCH_STATUS0_HANDLE(v)		(((v) << BP_BCH_STATUS0_HANDLE) & BM_BCH_STATUS0_HANDLE)
#define BP_BCH_STATUS0_COMPLETED_CE		16
#define BM_BCH_STATUS0_COMPLETED_CE		(0x000F << BP_BCH_STATUS0_COMPLETED_CE)
#define BF_BCH_STATUS0_COMPLETED_CE(v)		(((v) << BP_BCH_STATUS0_COMPLETED_CE) & BM_BCH_STATUS0_COMPLETED_CE)
#define BP_BCH_STATUS0_STATUS_BLK0		8
#define BM_BCH_STATUS0_STATUS_BLK0		(0xFF << BP_BCH_STATUS0_STATUS_BLK0)
#define BF_BCH_STATUS0_STATUS_BLK0(v)		(((v) << BP_BCH_STATUS0_STATUS_BLK0) & BM_BCH_STATUS0_STATUS_BLK0)
#define BV_BCH_STATUS0_STATUS_BLK0__ZERO	0x00
#define BV_BCH_STATUS0_STATUS_BLK0__ERROR1	0x01
#define BV_BCH_STATUS0_STATUS_BLK0__ERROR2	0x02
#define BV_BCH_STATUS0_STATUS_BLK0__ERROR3	0x03
#define BV_BCH_STATUS0_STATUS_BLK0__ERROR4	0x04
#define BV_BCH_STATUS0_STATUS_BLK0__UNCORRECTABLE 0xFE
#define BV_BCH_STATUS0_STATUS_BLK0__ERASED	0xFF
#define BM_BCH_STATUS0_ALLONES			(1 << 4)
#define BM_BCH_STATUS0_CORRECTED		(1 << 3)
#define BM_BCH_STATUS0_UNCORRECTABLE		(1 << 2)

#define HW_BCH_MODE				0x020

#define BP_BCH_MODE_ERASE_THRESHOLD		0
#define BM_BCH_MODE_ERASE_THRESHOLD		(0xFF << BP_BCH_MODE_ERASE_THRESHOLD)
#define BF_BCH_MODE_ERASE_THRESHOLD(v)		(((v) << 0) & BM_BCH_MODE_ERASE_THRESHOLD)

#define HW_BCH_ENCODEPTR			0x030

#define BP_BCH_ENCODEPTR_ADDR			0
#define BM_BCH_ENCODEPTR_ADDR			0xFFFFFFFF
#define BF_BCH_ENCODEPTR_ADDR(v)		(v)

#define HW_BCH_DATAPTR				0x040

#define BP_BCH_DATAPTR_ADDR			0
#define BM_BCH_DATAPTR_ADDR			0xFFFFFFFF
#define BF_BCH_DATAPTR_ADDR(v)			(v)

#define HW_BCH_METAPTR				0x050

#define BP_BCH_METAPTR_ADDR			0
#define BM_BCH_METAPTR_ADDR			0xFFFFFFFF
#define BF_BCH_METAPTR_ADDR(v)			(v)

#define HW_BCH_LAYOUTSELECT			0x070

#define BP_BCH_LAYOUTSELECT_CS15_SELECT		30
#define BM_BCH_LAYOUTSELECT_CS15_SELECT		(0x3 << BP_BCH_LAYOUTSELECT_CS15_SELECT)
#define BF_BCH_LAYOUTSELECT_CS15_SELECT(v)	(((v) << BP_BCH_LAYOUTSELECT_CS15_SELECT) & \
							BM_BCH_LAYOUTSELECT_CS15_SELECT)
#define BP_BCH_LAYOUTSELECT_CS14_SELECT		28
#define BM_BCH_LAYOUTSELECT_CS14_SELECT		(0x3 << BP_BCH_LAYOUTSELECT_CS14_SELECT)
#define BF_BCH_LAYOUTSELECT_CS14_SELECT(v)	(((v) << BP_BCH_LAYOUTSELECT_CS14_SELECT) & \
							BM_BCH_LAYOUTSELECT_CS14_SELECT)
#define BP_BCH_LAYOUTSELECT_CS13_SELECT		26
#define BM_BCH_LAYOUTSELECT_CS13_SELECT		(0x3 << BP_BCH_LAYOUTSELECT_CS13_SELECT)
#define BF_BCH_LAYOUTSELECT_CS13_SELECT(v)	(((v) << BP_BCH_LAYOUTSELECT_CS13_SELECT) & \
							BM_BCH_LAYOUTSELECT_CS13_SELECT)
#define BP_BCH_LAYOUTSELECT_CS12_SELECT		24
#define BM_BCH_LAYOUTSELECT_CS12_SELECT		(0x3 << BP_BCH_LAYOUTSELECT_CS12_SELECT)
#define BF_BCH_LAYOUTSELECT_CS12_SELECT(v)	(((v) << BP_BCH_LAYOUTSELECT_CS12_SELECT) & \
							BM_BCH_LAYOUTSELECT_CS12_SELECT)
#define BP_BCH_LAYOUTSELECT_CS11_SELECT		22
#define BM_BCH_LAYOUTSELECT_CS11_SELECT		(0x3 << BP_BCH_LAYOUTSELECT_CS11_SELECT)
#define BF_BCH_LAYOUTSELECT_CS11_SELECT(v)	(((v) << BP_BCH_LAYOUTSELECT_CS11_SELECT) & \
							BM_BCH_LAYOUTSELECT_CS11_SELECT)
#define BP_BCH_LAYOUTSELECT_CS10_SELECT		20
#define BM_BCH_LAYOUTSELECT_CS10_SELECT		(0x3 << BP_BCH_LAYOUTSELECT_CS10_SELECT)
#define BF_BCH_LAYOUTSELECT_CS10_SELECT(v)	(((v) << BP_BCH_LAYOUTSELECT_CS10_SELECT) & \
							BM_BCH_LAYOUTSELECT_CS10_SELECT)
#define BP_BCH_LAYOUTSELECT_CS9_SELECT		18
#define BM_BCH_LAYOUTSELECT_CS9_SELECT		0x000C0000
#define BF_BCH_LAYOUTSELECT_CS9_SELECT(v)	(((v) << 18) & \
					BM_BCH_LAYOUTSELECT_CS9_SELECT)
#define BP_BCH_LAYOUTSELECT_CS8_SELECT		16
#define BM_BCH_LAYOUTSELECT_CS8_SELECT		0x00030000
#define BF_BCH_LAYOUTSELECT_CS8_SELECT(v)	(((v) << 16) & \
					BM_BCH_LAYOUTSELECT_CS8_SELECT)
#define BP_BCH_LAYOUTSELECT_CS7_SELECT		14
#define BM_BCH_LAYOUTSELECT_CS7_SELECT		0x0000C000
#define BF_BCH_LAYOUTSELECT_CS7_SELECT(v)	(((v) << 14) & \
					BM_BCH_LAYOUTSELECT_CS7_SELECT)
#define BP_BCH_LAYOUTSELECT_CS6_SELECT		12
#define BM_BCH_LAYOUTSELECT_CS6_SELECT		0x00003000
#define BF_BCH_LAYOUTSELECT_CS6_SELECT(v)	(((v) << 12) & \
					BM_BCH_LAYOUTSELECT_CS6_SELECT)
#define BP_BCH_LAYOUTSELECT_CS5_SELECT		10
#define BM_BCH_LAYOUTSELECT_CS5_SELECT		0x00000C00
#define BF_BCH_LAYOUTSELECT_CS5_SELECT(v)	(((v) << 10) & \
					BM_BCH_LAYOUTSELECT_CS5_SELECT)
#define BP_BCH_LAYOUTSELECT_CS4_SELECT		8
#define BM_BCH_LAYOUTSELECT_CS4_SELECT		0x00000300
#define BF_BCH_LAYOUTSELECT_CS4_SELECT(v)	(((v) << 8) & \
					BM_BCH_LAYOUTSELECT_CS4_SELECT)
#define BP_BCH_LAYOUTSELECT_CS3_SELECT		6
#define BM_BCH_LAYOUTSELECT_CS3_SELECT		0x000000C0
#define BF_BCH_LAYOUTSELECT_CS3_SELECT(v)	(((v) << 6) & \
					BM_BCH_LAYOUTSELECT_CS3_SELECT)
#define BP_BCH_LAYOUTSELECT_CS2_SELECT		4
#define BM_BCH_LAYOUTSELECT_CS2_SELECT		0x00000030
#define BF_BCH_LAYOUTSELECT_CS2_SELECT(v)	(((v) << 4) & \
					BM_BCH_LAYOUTSELECT_CS2_SELECT)
#define BP_BCH_LAYOUTSELECT_CS1_SELECT		2
#define BM_BCH_LAYOUTSELECT_CS1_SELECT		0x0000000C
#define BF_BCH_LAYOUTSELECT_CS1_SELECT(v)	(((v) << 2) & \
					BM_BCH_LAYOUTSELECT_CS1_SELECT)
#define BP_BCH_LAYOUTSELECT_CS0_SELECT		0
#define BM_BCH_LAYOUTSELECT_CS0_SELECT		0x00000003
#define BF_BCH_LAYOUTSELECT_CS0_SELECT(v)	(((v) << 0) & \
					BM_BCH_LAYOUTSELECT_CS0_SELECT)

#define HW_BCH_FLASH0LAYOUT0			0x080

#define BP_BCH_FLASH0LAYOUT0_NBLOCKS		24
#define BM_BCH_FLASH0LAYOUT0_NBLOCKS		(0xFF << BP_BCH_FLASH0LAYOUT0_NBLOCKS)
#define BF_BCH_FLASH0LAYOUT0_NBLOCKS(v)		(((v) << BP_BCH_FLASH0LAYOUT0_NBLOCKS) & \
							BM_BCH_FLASH0LAYOUT0_NBLOCKS)
#define BP_BCH_FLASH0LAYOUT0_META_SIZE		16
#define BM_BCH_FLASH0LAYOUT0_META_SIZE		(0xFF << BP_BCH_FLASH0LAYOUT0_META_SIZE)
#define BF_BCH_FLASH0LAYOUT0_META_SIZE(v)	(((v) << BP_BCH_FLASH0LAYOUT0_META_SIZE) & \
							BM_BCH_FLASH0LAYOUT0_META_SIZE)
#define BP_BCH_FLASH0LAYOUT0_ECC0		12
#define BM_BCH_FLASH0LAYOUT0_ECC0		(0xF << BP_BCH_FLASH0LAYOUT0_ECC0)
#define BF_BCH_FLASH0LAYOUT0_ECC0(v)		(((v) << BP_BCH_FLASH0LAYOUT0_ECC0) & \
							BM_BCH_FLASH0LAYOUT0_ECC0)
#define BV_BCH_FLASH0LAYOUT0_ECC0__NONE		0x0
#define BV_BCH_FLASH0LAYOUT0_ECC0__ECC2		0x1
#define BV_BCH_FLASH0LAYOUT0_ECC0__ECC4		0x2
#define BV_BCH_FLASH0LAYOUT0_ECC0__ECC6		0x3
#define BV_BCH_FLASH0LAYOUT0_ECC0__ECC8		0x4
#define BV_BCH_FLASH0LAYOUT0_ECC0__ECC10	0x5
#define BV_BCH_FLASH0LAYOUT0_ECC0__ECC12	0x6
#define BV_BCH_FLASH0LAYOUT0_ECC0__ECC14	0x7
#define BV_BCH_FLASH0LAYOUT0_ECC0__ECC16	0x8
#define BV_BCH_FLASH0LAYOUT0_ECC0__ECC18	0x9
#define BV_BCH_FLASH0LAYOUT0_ECC0__ECC20	0xA
#define BP_BCH_FLASH0LAYOUT0_DATA0_SIZE		0
#define BM_BCH_FLASH0LAYOUT0_DATA0_SIZE		(0xFFF << BP_BCH_FLASH0LAYOUT0_DATA0_SIZE)
#define BF_BCH_FLASH0LAYOUT0_DATA0_SIZE(v)	(((v) << BP_BCH_FLASH0LAYOUT0_DATA0_SIZE) & \
							BM_BCH_FLASH0LAYOUT0_DATA0_SIZE)

#define HW_BCH_FLASH0LAYOUT1			0x090

#define BP_BCH_FLASH0LAYOUT1_PAGE_SIZE		16
#define BM_BCH_FLASH0LAYOUT1_PAGE_SIZE		(0xFFFF << BP_BCH_FLASH0LAYOUT1_PAGE_SIZE)
#define BF_BCH_FLASH0LAYOUT1_PAGE_SIZE(v)	(((v) << BP_BCH_FLASH0LAYOUT1_PAGE_SIZE) & \
							BM_BCH_FLASH0LAYOUT1_PAGE_SIZE)
#define BP_BCH_FLASH0LAYOUT1_ECCN		12
#define BM_BCH_FLASH0LAYOUT1_ECCN		(0xF << BP_BCH_FLASH0LAYOUT1_ECCN)
#define BF_BCH_FLASH0LAYOUT1_ECCN(v)		(((v) << BP_BCH_FLASH0LAYOUT1_ECCN) & \
							BM_BCH_FLASH0LAYOUT1_ECCN)
#define BV_BCH_FLASH0LAYOUT1_ECCN__NONE		0x0
#define BV_BCH_FLASH0LAYOUT1_ECCN__ECC2		0x1
#define BV_BCH_FLASH0LAYOUT1_ECCN__ECC4		0x2
#define BV_BCH_FLASH0LAYOUT1_ECCN__ECC6		0x3
#define BV_BCH_FLASH0LAYOUT1_ECCN__ECC8		0x4
#define BV_BCH_FLASH0LAYOUT1_ECCN__ECC10	0x5
#define BV_BCH_FLASH0LAYOUT1_ECCN__ECC12	0x6
#define BV_BCH_FLASH0LAYOUT1_ECCN__ECC14	0x7
#define BV_BCH_FLASH0LAYOUT1_ECCN__ECC16	0x8
#define BV_BCH_FLASH0LAYOUT1_ECCN__ECC18	0x9
#define BV_BCH_FLASH0LAYOUT1_ECCN__ECC20	0xA
#define BP_BCH_FLASH0LAYOUT1_DATAN_SIZE		0
#define BM_BCH_FLASH0LAYOUT1_DATAN_SIZE		(0xFFF << BP_BCH_FLASH0LAYOUT1_DATAN_SIZE)
#define BF_BCH_FLASH0LAYOUT1_DATAN_SIZE(v)	(((v) << BP_BCH_FLASH0LAYOUT1_DATAN_SIZE) & \
							BM_BCH_FLASH0LAYOUT1_DATAN_SIZE)

#define HW_BCH_FLASH1LAYOUT0			0x0a0

#define HW_BCH_FLASH1LAYOUT1			0x0b0

#define HW_BCH_FLASH2LAYOUT0			0x0c0

#define HW_BCH_FLASH2LAYOUT1			0x0d0

#define HW_BCH_FLASH3LAYOUT0			0x0e0

#define HW_BCH_FLASH3LAYOUT1			0x0f0

#if 0
#define HW_BCH_DEBUG0				0x100
#define HW_BCH_DEBUG0_SET			0x104
#define HW_BCH_DEBUG0_CLR			0x108
#define HW_BCH_DEBUG0_TOG			0x10c

#define BM_BCH_DEBUG0_ROM_BIST_ENABLE		(1 << 26)
#define BM_BCH_DEBUG0_ROM_BIST_COMPLETE		(1 << 25)
#define BP_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL	16
#define BM_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL	(0x1FF << BP_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL)
#define BF_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL(v) (((v) << BP_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL) & \
							BM_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL)
#define BV_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL__NORMAL	0x0
#define BV_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL__TEST_MODE 0x1
#define BM_BCH_DEBUG0_KES_DEBUG_SHIFT_SYND	(1 << 15)
#define BM_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG	(1 << 14)
#define BV_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG__DATA 0x1
#define BV_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG__AUX 0x1
#define BM_BCH_DEBUG0_KES_DEBUG_MODE4K		(1 << 13)
#define BV_BCH_DEBUG0_KES_DEBUG_MODE4K__4k	0x1
#define BV_BCH_DEBUG0_KES_DEBUG_MODE4K__2k	0x1
#define BM_BCH_DEBUG0_KES_DEBUG_KICK		0x00001000
#define BM_BCH_DEBUG0_KES_STANDALONE		0x00000800
#define BV_BCH_DEBUG0_KES_STANDALONE__NORMAL	0x0
#define BV_BCH_DEBUG0_KES_STANDALONE__TEST_MODE 0x1
#define BM_BCH_DEBUG0_KES_DEBUG_STEP		0x00000400
#define BM_BCH_DEBUG0_KES_DEBUG_STALL		0x00000200
#define BV_BCH_DEBUG0_KES_DEBUG_STALL__NORMAL	0x0
#define BV_BCH_DEBUG0_KES_DEBUG_STALL__WAIT	0x1
#define BM_BCH_DEBUG0_BM_KES_TEST_BYPASS	0x00000100
#define BV_BCH_DEBUG0_BM_KES_TEST_BYPASS__NORMAL    0x0
#define BV_BCH_DEBUG0_BM_KES_TEST_BYPASS__TEST_MODE 0x1
#define BP_BCH_DEBUG0_DEBUG_REG_SELECT		0
#define BM_BCH_DEBUG0_DEBUG_REG_SELECT		0x0000003F
#define BF_BCH_DEBUG0_DEBUG_REG_SELECT(v)	(((v) << BP_BCH_DEBUG0_DEBUG_REG_SELECT) & \
							BM_BCH_DEBUG0_DEBUG_REG_SELECT)

#define HW_BCH_DBGKESREAD			0x110

#define BP_BCH_DBGKESREAD_VALUES		0
#define BM_BCH_DBGKESREAD_VALUES		0xFFFFFFFF
#define BF_BCH_DBGKESREAD_VALUES(v)		(v)

#define HW_BCH_DBGCSFEREAD			0x120

#define BP_BCH_DBGCSFEREAD_VALUES		0
#define BM_BCH_DBGCSFEREAD_VALUES		0xFFFFFFFF
#define BF_BCH_DBGCSFEREAD_VALUES(v)		(v)

#define HW_BCH_DBGSYNDGENREAD			0x130

#define BP_BCH_DBGSYNDGENREAD_VALUES		0
#define BM_BCH_DBGSYNDGENREAD_VALUES		0xFFFFFFFF
#define BF_BCH_DBGSYNDGENREAD_VALUES(v)		(v)

#define HW_BCH_DBGAHBMREAD			0x140

#define BP_BCH_DBGAHBMREAD_VALUES		0
#define BM_BCH_DBGAHBMREAD_VALUES		0xFFFFFFFF
#define BF_BCH_DBGAHBMREAD_VALUES(v)		(v)

#define HW_BCH_BLOCKNAME			0x150

#define BP_BCH_BLOCKNAME_NAME			0
#define BM_BCH_BLOCKNAME_NAME			0xFFFFFFFF
#define BF_BCH_BLOCKNAME_NAME(v)		(v)
#endif

#define HW_BCH_VERSION				0x160

#define BP_BCH_VERSION_MAJOR			24
#define BM_BCH_VERSION_MAJOR			(0xFF << BP_BCH_VERSION_MAJOR)
#define BF_BCH_VERSION_MAJOR(v)			(((v) << BP_BCH_VERSION_MAJOR) & \
							BM_BCH_VERSION_MAJOR)
#define BP_BCH_VERSION_MINOR			16
#define BM_BCH_VERSION_MINOR			(0xFF << BP_BCH_VERSION_MINOR)
#define BF_BCH_VERSION_MINOR(v)			(((v) << BP_BCH_VERSION_MINOR) & \
							BM_BCH_VERSION_MINOR)
#define BP_BCH_VERSION_STEP			0
#define BM_BCH_VERSION_STEP			(0xFFFF << BP_BCH_VERSION_STEP)
#define BF_BCH_VERSION_STEP(v)			(((v) << BP_BCH_VERSION_STEP) & \
							BM_BCH_VERSION_STEP)

#endif
