/*
 * Copyright (C) 2010 Freescale Semiconductor, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */
#ifndef __EPDC_REGS_INCLUDED__
#define __EPDC_REGS_INCLUDED__

#include <linux/types.h>
#include <linux/list.h>

/*************************************
 * Register addresses
 *************************************/
#define EPDC_BASE			(EPDC_BASE_ADDR)

#define EPDC_CTRL			(0x000)
#define EPDC_CTRL_SET			(0x004)
#define EPDC_CTRL_CLR			(0x008)
#define EPDC_CTRL_TOG			(0x00c)
#define EPDC_WVADDR			(0x020)
#define EPDC_WB_ADDR			(0x030)
#define EPDC_RES			(0x040)
#define EPDC_FORMAT			(0x050)
#define EPDC_FORMAT_SET			(0x054)
#define EPDC_FORMAT_CLR			(0x058)
#define EPDC_FORMAT_TOG			(0x05c)
#define EPDC_FIFOCTRL			(0x0a0)
#define EPDC_FIFOCTRL_SET		(0x0a4)
#define EPDC_FIFOCTRL_CLR		(0x0a8)
#define EPDC_FIFOCTRL_TOG		(0x0ac)
#define EPDC_UPD_ADDR			(0x100)
#define EPDC_UPD_CORD			(0x120)
#define EPDC_UPD_SIZE			(0x140)
#define EPDC_UPD_CTRL			(0x160)
#define EPDC_UPD_FIXED			(0x180)
#define EPDC_TEMP			(0x1a0)
#define EPDC_TCE_CTRL			(0x200)
#define EPDC_TCE_SDCFG			(0x220)
#define EPDC_TCE_GDCFG			(0x240)
#define EPDC_TCE_HSCAN1			(0x260)
#define EPDC_TCE_HSCAN2			(0x280)
#define EPDC_TCE_VSCAN			(0x2a0)
#define EPDC_TCE_OE			(0x2c0)
#define EPDC_TCE_POLARITY		(0x2e0)
#define EPDC_TCE_TIMING1		(0x300)
#define EPDC_TCE_TIMING2		(0x310)
#define EPDC_TCE_TIMING3		(0x320)
#define EPDC_IRQ_MASK			(0x400)
#define EPDC_IRQ_MASK_SET		(0x404)
#define EPDC_IRQ_MASK_CLR		(0x408)
#define EPDC_IRQ_MASK_TOG		(0x40c)
#define EPDC_IRQ			(0x420)
#define EPDC_IRQ_SET			(0x424)
#define EPDC_IRQ_CLR			(0x428)
#define EPDC_IRQ_TOG			(0x42c)
#define EPDC_STATUS_LUTS		(0x440)
#define EPDC_STATUS_LUTS_SET		(0x444)
#define EPDC_STATUS_LUTS_CLR		(0x448)
#define EPDC_STATUS_LUTS_TOG		(0x44c)
#define EPDC_STATUS_NEXTLUT		(0x460)
#define EPDC_STATUS_COL			(0x480)
#define EPDC_STATUS			(0x4a0)
#define EPDC_STATUS_SET			(0x4a4)
#define EPDC_STATUS_CLR			(0x4a8)
#define EPDC_STATUS_TOG			(0x4ac)
#define EPDC_DEBUG			(0x500)
#define EPDC_DEBUG_LUT0			(0x540)
#define EPDC_DEBUG_LUT1			(0x550)
#define EPDC_DEBUG_LUT2			(0x560)
#define EPDC_DEBUG_LUT3			(0x570)
#define EPDC_DEBUG_LUT4			(0x580)
#define EPDC_DEBUG_LUT5			(0x590)
#define EPDC_DEBUG_LUT6			(0x5a0)
#define EPDC_DEBUG_LUT7			(0x5b0)
#define EPDC_DEBUG_LUT8			(0x5c0)
#define EPDC_DEBUG_LUT9			(0x5d0)
#define EPDC_DEBUG_LUT10		(0x5e0)
#define EPDC_DEBUG_LUT11		(0x5f0)
#define EPDC_DEBUG_LUT12		(0x600)
#define EPDC_DEBUG_LUT13		(0x610)
#define EPDC_DEBUG_LUT14		(0x620)
#define EPDC_DEBUG_LUT15		(0x630)
#define EPDC_GPIO			(0x700)
#define EPDC_VERSION			(0x7f0)

enum {
	/* EPDC_CTRL field values */
	EPDC_CTRL_SFTRST = 0x80000000,
	EPDC_CTRL_CLKGATE = 0x40000000,
	EPDC_CTRL_SRAM_POWERDOWN = 0x100,
	EPDC_CTRL_UPD_DATA_SWIZZLE_MASK = 0xc0,
	EPDC_CTRL_UPD_DATA_SWIZZLE_NO_SWAP = 0,
	EPDC_CTRL_UPD_DATA_SWIZZLE_ALL_BYTES_SWAP = 0x40,
	EPDC_CTRL_UPD_DATA_SWIZZLE_HWD_SWAP = 0x80,
	EPDC_CTRL_UPD_DATA_SWIZZLE_HWD_BYTE_SWAP = 0xc0,
	EPDC_CTRL_LUT_DATA_SWIZZLE_MASK = 0x30,
	EPDC_CTRL_LUT_DATA_SWIZZLE_NO_SWAP = 0,
	EPDC_CTRL_LUT_DATA_SWIZZLE_ALL_BYTES_SWAP = 0x10,
	EPDC_CTRL_LUT_DATA_SWIZZLE_HWD_SWAP = 0x20,
	EPDC_CTRL_LUT_DATA_SWIZZLE_HWD_BYTE_SWAP = 0x30,
	EPDC_CTRL_BURST_LEN_8_8 = 0x1,
	EPDC_CTRL_BURST_LEN_8_16 = 0,

	/* EPDC_RES field values */
	EPDC_RES_VERTICAL_MASK = 0x1fff0000,
	EPDC_RES_VERTICAL_OFFSET = 16,
	EPDC_RES_HORIZONTAL_MASK = 0x1fff,
	EPDC_RES_HORIZONTAL_OFFSET = 0,

	/* EPDC_FORMAT field values */
	EPDC_FORMAT_BUF_PIXEL_SCALE_ROUND = 0x1000000,
	EPDC_FORMAT_DEFAULT_TFT_PIXEL_MASK = 0xff0000,
	EPDC_FORMAT_DEFAULT_TFT_PIXEL_OFFSET = 16,
	EPDC_FORMAT_BUF_PIXEL_FORMAT_P2N = 0x200,
	EPDC_FORMAT_BUF_PIXEL_FORMAT_P3N = 0x300,
	EPDC_FORMAT_BUF_PIXEL_FORMAT_P4N = 0x400,
	EPDC_FORMAT_BUF_PIXEL_FORMAT_P5N = 0x500,
	EPDC_FORMAT_TFT_PIXEL_FORMAT_2BIT = 0x0,
	EPDC_FORMAT_TFT_PIXEL_FORMAT_2BIT_VCOM = 0x1,
	EPDC_FORMAT_TFT_PIXEL_FORMAT_4BIT = 0x2,
	EPDC_FORMAT_TFT_PIXEL_FORMAT_4BIT_VCOM = 0x3,

	/* EPDC_FIFOCTRL field values */
	EPDC_FIFOCTRL_ENABLE_PRIORITY = 0x80000000,
	EPDC_FIFOCTRL_FIFO_INIT_LEVEL_MASK = 0xff0000,
	EPDC_FIFOCTRL_FIFO_INIT_LEVEL_OFFSET = 16,
	EPDC_FIFOCTRL_FIFO_H_LEVEL_MASK = 0xff00,
	EPDC_FIFOCTRL_FIFO_H_LEVEL_OFFSET = 8,
	EPDC_FIFOCTRL_FIFO_L_LEVEL_MASK = 0xff,
	EPDC_FIFOCTRL_FIFO_L_LEVEL_OFFSET = 0,

	/* EPDC_UPD_CORD field values */
	EPDC_UPD_CORD_YCORD_MASK = 0x1fff0000,
	EPDC_UPD_CORD_YCORD_OFFSET = 16,
	EPDC_UPD_CORD_XCORD_MASK = 0x1fff,
	EPDC_UPD_CORD_XCORD_OFFSET = 0,

	/* EPDC_UPD_SIZE field values */
	EPDC_UPD_SIZE_HEIGHT_MASK = 0x1fff0000,
	EPDC_UPD_SIZE_HEIGHT_OFFSET = 16,
	EPDC_UPD_SIZE_WIDTH_MASK = 0x1fff,
	EPDC_UPD_SIZE_WIDTH_OFFSET = 0,

	/* EPDC_UPD_CTRL field values */
	EPDC_UPD_CTRL_USE_FIXED = 0x80000000,
	EPDC_UPD_CTRL_LUT_SEL_MASK = 0xf0000,
	EPDC_UPD_CTRL_LUT_SEL_OFFSET = 16,
	EPDC_UPD_CTRL_WAVEFORM_MODE_MASK = 0xff00,
	EPDC_UPD_CTRL_WAVEFORM_MODE_OFFSET = 8,
	EPDC_UPD_CTRL_UPDATE_MODE_FULL = 0x1,

	/* EPDC_UPD_FIXED field values */
	EPDC_UPD_FIXED_FIXNP_EN = 0x80000000,
	EPDC_UPD_FIXED_FIXCP_EN = 0x40000000,
	EPDC_UPD_FIXED_FIXNP_MASK = 0xff00,
	EPDC_UPD_FIXED_FIXNP_OFFSET = 8,
	EPDC_UPD_FIXED_FIXCP_MASK = 0xff,
	EPDC_UPD_FIXED_FIXCP_OFFSET = 0,

	/* EPDC_TCE_CTRL field values */
	EPDC_TCE_CTRL_VSCAN_HOLDOFF_MASK = 0x1ff0000,
	EPDC_TCE_CTRL_VSCAN_HOLDOFF_OFFSET = 16,
	EPDC_TCE_CTRL_VCOM_VAL_MASK = 0xc00,
	EPDC_TCE_CTRL_VCOM_VAL_OFFSET = 10,
	EPDC_TCE_CTRL_VCOM_MODE_AUTO = 0x200,
	EPDC_TCE_CTRL_VCOM_MODE_MANUAL = 0x000,
	EPDC_TCE_CTRL_DDR_MODE_ENABLE = 0x100,
	EPDC_TCE_CTRL_LVDS_MODE_CE_ENABLE = 0x80,
	EPDC_TCE_CTRL_LVDS_MODE_ENABLE = 0x40,
	EPDC_TCE_CTRL_SCAN_DIR_1_UP = 0x20,
	EPDC_TCE_CTRL_SCAN_DIR_0_UP = 0x10,
	EPDC_TCE_CTRL_DUAL_SCAN_ENABLE = 0x8,
	EPDC_TCE_CTRL_SDDO_WIDTH_16BIT = 0x4,
	EPDC_TCE_CTRL_PIXELS_PER_SDCLK_2 = 1,
	EPDC_TCE_CTRL_PIXELS_PER_SDCLK_4 = 2,
	EPDC_TCE_CTRL_PIXELS_PER_SDCLK_8 = 3,

	/* EPDC_TCE_SDCFG field values */
	EPDC_TCE_SDCFG_SDCLK_HOLD = 0x200000,
	EPDC_TCE_SDCFG_SDSHR = 0x100000,
	EPDC_TCE_SDCFG_NUM_CE_MASK = 0xf0000,
	EPDC_TCE_SDCFG_NUM_CE_OFFSET = 16,
	EPDC_TCE_SDCFG_SDDO_REFORMAT_STANDARD = 0,
	EPDC_TCE_SDCFG_SDDO_REFORMAT_FLIP_PIXELS = 0x4000,
	EPDC_TCE_SDCFG_SDDO_INVERT_ENABLE = 0x2000,
	EPDC_TCE_SDCFG_PIXELS_PER_CE_MASK = 0x1fff,
	EPDC_TCE_SDCFG_PIXELS_PER_CE_OFFSET = 0,

	/* EPDC_TCE_GDCFG field values */
	EPDC_TCE_SDCFG_GDRL = 0x10,
	EPDC_TCE_SDCFG_GDOE_MODE_DELAYED_GDCLK = 0x2,
	EPDC_TCE_SDCFG_GDSP_MODE_FRAME_SYNC = 0x1,
	EPDC_TCE_SDCFG_GDSP_MODE_ONE_LINE = 0x0,

	/* EPDC_TCE_HSCAN1 field values */
	EPDC_TCE_HSCAN1_LINE_SYNC_WIDTH_MASK = 0xfff0000,
	EPDC_TCE_HSCAN1_LINE_SYNC_WIDTH_OFFSET = 16,
	EPDC_TCE_HSCAN1_LINE_SYNC_MASK = 0xfff,
	EPDC_TCE_HSCAN1_LINE_SYNC_OFFSET = 0,

	/* EPDC_TCE_HSCAN2 field values */
	EPDC_TCE_HSCAN2_LINE_END_MASK = 0xfff0000,
	EPDC_TCE_HSCAN2_LINE_END_OFFSET = 16,
	EPDC_TCE_HSCAN2_LINE_BEGIN_MASK = 0xfff,
	EPDC_TCE_HSCAN2_LINE_BEGIN_OFFSET = 0,

	/* EPDC_TCE_VSCAN field values */
	EPDC_TCE_VSCAN_FRAME_END_MASK = 0xff0000,
	EPDC_TCE_VSCAN_FRAME_END_OFFSET = 16,
	EPDC_TCE_VSCAN_FRAME_BEGIN_MASK = 0xff00,
	EPDC_TCE_VSCAN_FRAME_BEGIN_OFFSET = 8,
	EPDC_TCE_VSCAN_FRAME_SYNC_MASK = 0xff,
	EPDC_TCE_VSCAN_FRAME_SYNC_OFFSET = 0,

	/* EPDC_TCE_OE field values */
	EPDC_TCE_OE_SDOED_WIDTH_MASK = 0xff000000,
	EPDC_TCE_OE_SDOED_WIDTH_OFFSET = 24,
	EPDC_TCE_OE_SDOED_DLY_MASK = 0xff0000,
	EPDC_TCE_OE_SDOED_DLY_OFFSET = 16,
	EPDC_TCE_OE_SDOEZ_WIDTH_MASK = 0xff00,
	EPDC_TCE_OE_SDOEZ_WIDTH_OFFSET = 8,
	EPDC_TCE_OE_SDOEZ_DLY_MASK = 0xff,
	EPDC_TCE_OE_SDOEZ_DLY_OFFSET = 0,

	/* EPDC_TCE_POLARITY field values */
	EPDC_TCE_POLARITY_GDSP_POL_ACTIVE_HIGH = 0x10,
	EPDC_TCE_POLARITY_GDOE_POL_ACTIVE_HIGH = 0x8,
	EPDC_TCE_POLARITY_SDOE_POL_ACTIVE_HIGH = 0x4,
	EPDC_TCE_POLARITY_SDLE_POL_ACTIVE_HIGH = 0x2,
	EPDC_TCE_POLARITY_SDCE_POL_ACTIVE_HIGH = 0x1,

	/* EPDC_TCE_TIMING1 field values */
	EPDC_TCE_TIMING1_SDLE_SHIFT_NONE = 0x00,
	EPDC_TCE_TIMING1_SDLE_SHIFT_1 = 0x10,
	EPDC_TCE_TIMING1_SDLE_SHIFT_2 = 0x20,
	EPDC_TCE_TIMING1_SDLE_SHIFT_3 = 0x30,
	EPDC_TCE_TIMING1_SDCLK_INVERT = 0x8,
	EPDC_TCE_TIMING1_SDCLK_SHIFT_NONE = 0,
	EPDC_TCE_TIMING1_SDCLK_SHIFT_1CYCLE = 1,
	EPDC_TCE_TIMING1_SDCLK_SHIFT_2CYCLES = 2,
	EPDC_TCE_TIMING1_SDCLK_SHIFT_3CYCLES = 3,

	/* EPDC_TCE_TIMING2 field values */
	EPDC_TCE_TIMING2_GDCLK_HP_MASK = 0xffff0000,
	EPDC_TCE_TIMING2_GDCLK_HP_OFFSET = 16,
	EPDC_TCE_TIMING2_GDSP_OFFSET_MASK = 0xffff,
	EPDC_TCE_TIMING2_GDSP_OFFSET_OFFSET = 0,

	/* EPDC_TCE_TIMING3 field values */
	EPDC_TCE_TIMING3_GDOE_OFFSET_MASK = 0xffff0000,
	EPDC_TCE_TIMING3_GDOE_OFFSET_OFFSET = 16,
	EPDC_TCE_TIMING3_GDCLK_OFFSET_MASK = 0xffff,
	EPDC_TCE_TIMING3_GDCLK_OFFSET_OFFSET = 0,

	/* EPDC_IRQ_MASK/EPDC_IRQ field values */
	EPDC_IRQ_WB_CMPLT_IRQ = 0x10000,
	EPDC_IRQ_LUT_COL_IRQ = 0x20000,
	EPDC_IRQ_TCE_UNDERRUN_IRQ = 0x40000,
	EPDC_IRQ_FRAME_END_IRQ = 0x80000,
	EPDC_IRQ_BUS_ERROR_IRQ = 0x100000,
	EPDC_IRQ_TCE_IDLE_IRQ = 0x200000,

	/* EPDC_STATUS_NEXTLUT field values */
	EPDC_STATUS_NEXTLUT_NEXT_LUT_VALID = 0x100,
	EPDC_STATUS_NEXTLUT_NEXT_LUT_MASK = 0xf,
	EPDC_STATUS_NEXTLUT_NEXT_LUT_OFFSET = 0,

	/* EPDC_STATUS field values */
	EPDC_STATUS_LUTS_UNDERRUN = 0x4,
	EPDC_STATUS_LUTS_BUSY = 0x2,
	EPDC_STATUS_WB_BUSY = 0x1,

	/* EPDC_DEBUG field values */
	EPDC_DEBUG_UNDERRUN_RECOVER = 0x2,
	EPDC_DEBUG_COLLISION_OFF = 0x1,

	/* EPDC_GPIO field values */
	EPDC_GPIO_PWRCOM = 0x40,
	EPDC_GPIO_PWRCTRL_MASK = 0x3c,
	EPDC_GPIO_PWRCTRL_OFFSET = 2,
	EPDC_GPIO_BDR_MASK = 0x3,
	EPDC_GPIO_BDR_OFFSET = 0,
};

#endif
